<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-wrench"></i> Utilitários do Sistema
                    </h3>
                </div>
                <div class="box-body">

                    <?php if (!empty($message)): ?>
                        <div class="alert alert-<?php echo $messageType; ?> alert-dismissable">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <strong><?php echo ucfirst($messageType); ?>!</strong> <?php echo $message; ?>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="box box-warning">
                                <div class="box-header with-border">
                                    <h4 class="box-title">
                                        <i class="fa fa-folder-open"></i> License Alerts Log
                                    </h4>
                                </div>
                                <div class="box-body">
                                    <p>
                                        <strong>Caminho:</strong><br>
                                        <small><code><?php echo $logFile; ?></code></small>
                                    </p>
                                    <p>
                                        <strong>Tamanho:</strong> 
                                        <span class="label label-info">
                                            <?php 
                                            if ($logFileSize == 0) {
                                                echo 'Vazio';
                                            } elseif ($logFileSize < 1024) {
                                                echo $logFileSize . ' B';
                                            } elseif ($logFileSize < 1024 * 1024) {
                                                echo round($logFileSize / 1024, 2) . ' KB';
                                            } else {
                                                echo round($logFileSize / (1024 * 1024), 2) . ' MB';
                                            }
                                            ?>
                                        </span>
                                    </p>
                                    <p>
                                        <strong>Última modificação:</strong><br>
                                        <small><?php echo $logFileLastModified; ?></small>
                                    </p>
                                    <hr>
                                    <form method="post" style="display: inline;">
                                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                                        <button type="submit" name="clear_license_alerts" value="1" class="btn btn-danger" onclick="return confirm('Tem certeza que deseja limpar o license alerts log? Esta ação não pode ser desfeita.');">
                                            <i class="fa fa-trash"></i> Limpar License Alerts Log
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="box box-info">
                                <div class="box-header with-border">
                                    <h4 class="box-title">
                                        <i class="fa fa-info-circle"></i> Informações do Sistema
                                    </h4>
                                </div>
                                <div class="box-body">
                                    <p>
                                        <strong>PHP Version:</strong> 
                                        <span class="label label-default"><?php echo phpversion(); ?></span>
                                    </p>
                                    <p>
                                        <strong>Sistema Operacional:</strong> 
                                        <span class="label label-default"><?php echo php_uname(); ?></span>
                                    </p>
                                    <p>
                                        <strong>OpenSSL:</strong> 
                                        <span class="label <?php echo extension_loaded('openssl') ? 'label-success' : 'label-danger'; ?>">
                                            <?php echo extension_loaded('openssl') ? '✓ Carregado' : '✗ Não carregado'; ?>
                                        </span>
                                    </p>
                                    <p>
                                        <strong>cURL:</strong> 
                                        <span class="label <?php echo extension_loaded('curl') ? 'label-success' : 'label-danger'; ?>">
                                            <?php echo extension_loaded('curl') ? '✓ Carregado' : '✗ Não carregado'; ?>
                                        </span>
                                    </p>
                                    <p>
                                        <strong>Memória Disponível:</strong> 
                                        <span class="label label-default"><?php echo ini_get('memory_limit'); ?></span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
