<style>
/* manter acções numa linha */
#SLData td:last-child,
#SLData th:last-child{
  white-space: nowrap !important;
}

/* botões compactos */
#SLData td:last-child .btn{
  padding: 4px 6px !important;
  margin: 0 1px !important;
  font-size: 12px !important;
  line-height: 1 !important;
}

/* botão bulk ao lado do length */
#SLData_length #btnSendAllAgt{
    margin-left:10px;
}
#SLData_length #agtBulkInfo{
    margin-left:8px;
    font-size:12px;
    display:inline-block;
}

/* Linhas anuladas a vermelho */
#SLData tr.row-anulado {
    background-color: #ffcccc !important;
}
#SLData tr.row-anulado td {
    background-color: #ffcccc !important;
    color: #8b0000;
    font-weight: 500;
}
</style>

<script>
$(document).ready(function () {

    function _upper(v){
        return (v === null || v === undefined) ? "" : (""+v).toUpperCase().trim();
    }

    function isAgtValido(st){
        st = _upper(st);
        return (st === "VALIDA" || st === "VALIDA" || st === "VALIDATED" || st === "V");
    }

    // tenta sacar o sale_id a partir dos links existentes nas ações
    function extractSaleId(actionsHtml){
        if(!actionsHtml) return 0;

        // procura um /<numero> no HTML
        // Ex: pos/printInvoice/123  | sales/view/123 | sales/edit/123
        var m = actionsHtml.match(/\/(\d+)(?:\?|["'\/]|$)/);
        return m ? parseInt(m[1], 10) : 0;
    }

    // injecta botão "Enviar AGT" nas ações quando permitido
    function addAgtActionButton(actionsHtml, row){
        actionsHtml = actionsHtml || "";

        var invoiceType = _upper(row[6]); // coluna 6: InvoiceType
        var agtSt       = _upper(row[7]); // coluna 7: agt_last_status
        var invoiceNo   = _upper(row[2] || ""); // coluna 2: InvoiceNo

        // NC: apenas botão de imprimir (primeiro botão)
        if(invoiceType === "NC" || invoiceNo.indexOf("NC") === 0){
            var $wrap = $("<div>").html(actionsHtml);
            var $firstPrint = $wrap.find(".btn-group .print" + extractSaleId(actionsHtml)).closest(".btn");
            if($firstPrint.length){
                return '<div class="text-center"><div class="btn-group">' + $firstPrint.clone().wrap('<div>').parent().html() + '</div></div>';
            }
            // fallback: primeiro botão
            var $first = $wrap.find(".btn-group a").first();
            if($first.length){
                return '<div class="text-center"><div class="btn-group">' + $first.clone().wrap('<div>').parent().html() + '</div></div>';
            }
            return actionsHtml;
        }

        var sale_id = extractSaleId(actionsHtml);
        if(!sale_id) return actionsHtml;

        var sendBtn = '';
        var consultBtn = '';

        // já validado: não mostra nenhum botão AGT
        if(isAgtValido(agtSt)){
            return actionsHtml;
        }

        // ENVIADO: só mostra consultar
        if(agtSt === "ENVIADO"){
            consultBtn = '<a href="' + base_url + 'agt/obter_estado/' + sale_id + '?send=1" ' +
                'class="tip btn btn-default btn-xs btn-agt-consult" title="Actualizar estado AGT">' +
                '<i class="fa fa-refresh"></i></a>';
            return actionsHtml + consultBtn;
        }

        // CONSULTADO, ERRO ou outros: mostra ambos
        sendBtn = '<a href="' + base_url + 'agt/registar_factura/' + sale_id + '?send=1" ' +
            'class="tip btn btn-info btn-xs btn-agt-send" title="Enviar AGT" data-sale-id="' + sale_id + '">' +
            '<i class="fa fa-cloud-upload"></i></a>';

        consultBtn = '<a href="' + base_url + 'agt/obter_estado/' + sale_id + '?send=1" ' +
            'class="tip btn btn-default btn-xs btn-agt-consult" title="Actualizar estado AGT">' +
            '<i class="fa fa-refresh"></i></a>';

        return actionsHtml + sendBtn + consultBtn;
    }

    // --------- BULK (envio em massa) ----------
    var runningBulk = false;

    function bulkInfo(msg){
        $("#agtBulkInfo").html(msg || "");
    }

    function sleep(ms){
        return new Promise(resolve => setTimeout(resolve, ms));
    }

    async function consultarDepoisDeEnviar(saleId){
        // consulta estado 2s após o envio
        await sleep(2000);
        try {
            await $.ajax({
                url: base_url + "agt/obter_estado/" + saleId,
                type: "GET",
                data: { send: 1 },
                dataType: "json",
                timeout: 60000
            });
        } catch (e) {
            // mantemos silencioso para não travar a fila
        }
    }

    async function enviarFila(ids){
        if(!ids || !ids.length){
            bulkInfo("<span class='text-muted'>Nada pendente.</span>");
            return;
        }

        runningBulk = true;
        $("#btnSendAllAgt").prop("disabled", true);

        var ok = 0, erro = 0;

        for (var i = 0; i < ids.length; i++) {
            var id = ids[i];

            bulkInfo("A enviar <b>"+(i+1)+"</b>/"+ids.length+" | OK: "+ok+" | ERRO: "+erro);

            try{
                await $.ajax({
                    url: base_url + "agt/registar_factura/" + id,
                    type: "GET",
                    data: { send: 1 },
                    dataType: "json",
                    timeout: 60000
                });
                ok++;
                await consultarDepoisDeEnviar(id);
            }catch(e){
                erro++;
            }

            await sleep(400); // pausa anti-bombardeio
        }

        runningBulk = false;
        $("#btnSendAllAgt").prop("disabled", false);

        bulkInfo("<span class='text-success'><b>Concluído</b></span> | OK: "+ok+" | ERRO: "+erro);

        // refresca sem perder página
        $('#SLData').dataTable().fnDraw(false);
    }

    // --------- DataTable ----------
    $('#SLData').dataTable({
        "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, '<?= lang('all'); ?>']],
        "aaSorting": [[0, "desc"]],
        "iDisplayLength": <?= $Settings->rows_per_page ?>,
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": "<?= site_url('sales/get_sales') ?>",
        "fnServerData": function (sSource, aoData, fnCallback) {
            aoData.push({
                "name": "<?= $this->security->get_csrf_token_name() ?>",
                "value": "<?= $this->security->get_csrf_hash() ?>"
            });
            $.ajax({
                "dataType": "json",
                "type": "POST",
                "url": sSource,
                "data": aoData,
                "success": fnCallback
            });
        },

        // Ordem dos campos:
        // 0 date
        // 1 customer_name
        // 2 InvoiceNo
        // 3 total_discount
        // 4 grand_total
        // 5 paid
        // 6 InvoiceType
        // 7 agt_last_status
        // 8 Actions
            "aoColumns": [
            { "mRender": function(data, type, row) {
                    var v = (typeof hrld === 'function') ? hrld(data) : (data || '');
                    v = (v === null || v === undefined) ? '' : (''+v);
                    return v ? v.split(' ')[0] : '';
                } },                 // 0 Data (apenas data, sem horas)
            null,                                // 1 Cliente
            null,                                // 2 Número da Factura
            { "mRender": currencyFormat },       // 3 Desc.
            { "mRender": currencyFormat },       // 4 Total a Pagar
            { "mRender": currencyFormat },       // 5 Pago
            {                                    // 6 Status (Normal / Anulado) usando InvoiceType
                "mRender": function (data, type, row) {
                    if (data == "NC") {
                        return "<?= lang('Anulado'); ?>";
                    }
                    return "<?= lang('normal'); ?>";
                }
            },
            {                                     // 7 AGT Status (badge)
                "mRender": function (data, type, row) {
                    var st = (data || '').toString().toUpperCase();
                    if (!st) return "";

                    if (st === 'ENVIADO')   return '<span class="label label-info">ENVIADO</span>';
                    if (st === 'SUBMITTED') return '<span class="label label-info">SUBMITTED</span>';
                    if (st === 'CONSULTADO')return '<span class="label label-default">CONSULTADO</span>';

                    if (st === 'ERRO_HTTP' || st === 'ERRO') {
                        return '<span class="label label-danger">Erro envio</span>';
                    }
                    if (st === 'VALIDA' || st === 'VALIDA' || st === 'V' || st === 'VALIDATED') {
                        return '<span class="label label-success">VALIDA</span>';
                    }
                    if (st === 'PENDENTE' || st === 'PENDING_PAYLOAD' || st === 'P') {
                        return '<span class="label label-warning">Pendente</span>';
                    }
                    return '<span class="label label-default">' + st + '</span>';
                }
            },
            {   // 8 Actions (inject botão AGT aqui)
                "bSortable": false,
                "bSearchable": false,
                "mRender": function (data, type, row) {
                    return addAgtActionButton(data, row);
                }
            }
        ],

        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull){
            // Destaca linhas anuladas a vermelho
            if(aData[6] === "NC"){
                $(nRow).addClass("row-anulado");
            }
            return nRow;
        },

        "fnInitComplete": function () {
            // injeta botão bulk ao lado do Show entries
            if(!$("#btnSendAllAgt").length){
                $("#SLData_length").append(
                    '<button id="btnSendAllAgt" type="button" class="btn btn-primary btn-sm">' +
                        '<i class="fa fa-send"></i> Enviar Pendentes p/ AGT' +
                    '</button>' +
                    '<span id="agtBulkInfo"></span>'
                );
            }

            // evento bulk
            $("body").off("click", "#btnSendAllAgt").on("click", "#btnSendAllAgt", function(){
                if(runningBulk) return;

                if(!confirm("Queres enviar para a AGT todas as facturas pendentes (AGT != VALIDA/VALIDADO e não NC)?")){
                    return;
                }

                bulkInfo("<span class='text-muted'>A carregar pendentes...</span>");

                $.ajax({
                    url: base_url + "sales/get_pending_agt_sales_ids",
                    type: "GET",
                    dataType: "json",
                    timeout: 60000,
                    success: function(res){
                        if(!res || !res.ok){
                            bulkInfo("<span class='text-danger'>Erro ao buscar pendentes.</span>");
                            return;
                        }
                        enviarFila(res.ids || []);
                    },
                    error: function(){
                        bulkInfo("<span class='text-danger'>Erro de rede.</span>");
                    }
                });
            });
        }
    });

    // Envio individual: envia e consulta estado 2s depois
    $("body").off("click", ".btn-agt-send").on("click", ".btn-agt-send", async function(e){
        e.preventDefault();

        var $btn = $(this);
        if($btn.data("busy")) return;
        $btn.data("busy", true);

        var saleId = parseInt($btn.data("sale-id"), 10) || extractSaleId($btn.attr("href"));
        if(!saleId){
            $btn.data("busy", false);
            return window.location.href = $btn.attr("href");
        }

        try{
            await $.ajax({
                url: base_url + "agt/registar_factura/" + saleId,
                type: "GET",
                data: { send: 1 },
                dataType: "json",
                timeout: 60000
            });
            await consultarDepoisDeEnviar(saleId);
        }catch(err){
            // se falhar envio continuamos a refrescar
        }

        $btn.data("busy", false);
        $('#SLData').dataTable().fnDraw(false);
    });

});
</script>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('list_results'); ?></h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="SLData" class="table table-striped table-bordered table-condensed table-hover">
                            <thead>
                            <tr class="active">
                                <th style="width: 80px;"><?php echo $this->lang->line("date"); ?></th>
                                <th class="col-xs-3"><?php echo $this->lang->line("customer"); ?></th>
                                <th class="col-xs-2"><?php echo $this->lang->line("InvoiceNo"); ?></th>
                                <th style="width: 70px;"><?php echo $this->lang->line("discount"); ?></th>
                                <th class="col-xs-1"><?php echo $this->lang->line("grand_total"); ?></th>
                                <th class="col-xs-1"><?php echo $this->lang->line("paid"); ?></th>
                                <th class="text-center" style="width: 80px;"><?php echo $this->lang->line("status"); ?></th>
                                <th class="text-center col-agt">AGT</th>
                                <th class="col-xs-2"><?php echo $this->lang->line("actions"); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td colspan="10" class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="modal" data-easein="flipYIn" id="ncModal" tabindex="-1" role="dialog" aria-labelledby="tsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md modal-success">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                    <i class="fa fa-times"></i>
                </button>
                <h4 class="modal-title" id="tsModalLabel"><?= lang('reason'); ?></h4>
            </div>
            <div class="modal-body">
                <input type="text"
                       class="form-control input-sm kb-pad"
                       id="nc_reason"
                       onClick="this.select();"
                       value=""
                       placeholder="Atenção, está acção não permitirá recuperar está Factura"
                       style="height: 40px;">
                <input type="hidden" id="invoice_id">
                Esta informação será enviada a AGT
            </div>
            <div class="modal-footer">
                <button type="button"
                        class="btn btn-default btn-sm pull-left"
                        data-dismiss="modal">
                    <?= lang('close') ?>
                </button>
                <button type="button"
                        id="convertNc"
                        class="btn btn-primary btn-sm">
                    <?= lang('save') ?>
                </button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(function () {

    $("body").on("click", ".convert-nc-btn", function () {
        $("#nc_reason").val("");
        $("#invoice_id").val($(this).data("id"));
        $('#ncModal').modal({backdrop: 'static'});
    });

    $("body").on("click", "#convertNc", function () {
        var invoiceId = $("#invoice_id").val();
        var reason = $("#nc_reason").val();
        
        if(!invoiceId){
            alert("Erro: ID da factura não encontrado.");
            return;
        }

        var data = { 
            id: invoiceId, 
            reason: reason
        };
        
        // Adiciona CSRF token
        var csrfName = "<?= $this->security->get_csrf_token_name() ?>";
        var csrfHash = "<?= $this->security->get_csrf_hash() ?>";
        data[csrfName] = csrfHash;

        $.ajax({
            type: "get",
            url: base_url + 'sales/convert_Nc_invoice',
            data: data,
            dataType: "json",
            success: function (res) {
                if(res && res.sale_id){
                    $('#ncModal').modal("hide");
                    $('#SLData').dataTable().fnDraw(false);
                    window.open(base_url + 'pos/printInvoice/' + res.sale_id, '_blank');
                } else {
                    alert("Erro: " + (res.message || "Falha ao criar NC"));
                }
            },
            error: function(xhr, status, error){
                alert("Erro ao enviar: " + error);
            }
        });
    });

<?php if ($this->session->userdata("add_payment") == "yes") { ?>
    window.open("sales/printPaymentInvoice/<?= $this->session->userdata("sale_id") ?>", "PrintPaymentInvoice");
<?php
    $this->session->unset_userdata("add_payment");
    $this->session->unset_userdata("sale_id");
} ?>
});
</script>
