<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <title><?= lang('Fecho Diário') . " | " . $Settings->site_name; ?></title>
        <base href="<?= base_url() ?>"/> 
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
        <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
      
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width: 90%; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 5px; }
            .table {
    border-radius: 3px;
    border: 1px solid #ddd;
    font-size: 10px;
}
         
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .cancelado {
                    display: block;
                    position: absolute;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;
                    
                }
            @media print {
                .no-print { display: none; }
                /* #wrapper { max-width: 780px; width: 100%; min-width: 250px; margin: 0 auto; } */
            }
        </style>
        
    </head>
    <body >
		
        <div id="wrapper" >
            <div class="cancelado">
                <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logotipo"  width="100%" class="img-responsive" border="0" />
            </div>
            <div  style="al font-size: 12px;" id="receipt-data">
                <div class="text-left">
                    <div id="">
                        <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logo" width="150"  class="img-responsive" border="0">
                        <br>
                        <?= $Settings->CompanyName; ?>
                        <br>
                        <?= $Settings->TaxRegistrationNumber; ?>
                        <br>
                        <?= $Settings->AddressDetail; ?>
                        <br>
                        <?= $Settings->phone;; ?>
                        
                        <br>      
                    </div>
                </div>
					<div class="col-md-12 text-center">
                        <h4>Relatório de Venda / Lucro</h4>
                    </div>
                    <div class="date-value">
                       <?php echo lang("date"); ?> 
                       </div>
                    <div class="col-md-12 text-center"><span class="date-value"><?php echo lang("De").": ".$start_date; ?> <br>
              <?php echo lang("Á")."  &nbsp;:  ".$end_date; ?></span></div>
              <?php 
                    $total_cost=0;
                    $total_income=0;
                    $total_profit=0;
                    $total_purchases=0;
                    $total_sold=0;
                    $total_tax=0;
                    $total_discount = 0;
                ?>  
                <?php if($group_by_date==1){ ?>
                <div class="row" style="margin-top:10px;">
                    <div class="col-md-12">
                        <table class="table table-bordered" width="100%">
                            <thead>
                                <tr>
                                    <th bgcolor="#DBDBDB"  class="text-center"><?= lang("Data"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("Quantidade"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("Total"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center" ><?= lang("Total Descontos"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("Custo"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("Lucro"); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($alldata as $key=>$arr){ 
                                    $total_cost= $total_cost+$arr->cost;
                                    $total_income= $total_income+$arr->income;
                                    $total_profit= $total_profit+$arr->profit;
                                    // $total_purchases = $total_purchases + $arr->purchases;
                                    $total_sold = $total_sold + $arr->sold;
                                    $total_tax = $total_tax + $arr->tax;
                                    $total_discount = $total_discount + $arr->total_discount;
                                    ?>
                                    
                                    <tr>
                                        <td style="width:25%"><?php echo $arr->sale_date ?></td>
                                        <td  class="text-right" style="width:10%"><?php echo $arr->sold ?></td>
                                        <td  class="text-right" style="width:10%"><?php echo number_format($arr->income,2)  ?></td>
                                        <td class="text-right" style="width:10%"><?php echo number_format($arr->total_discount,2)  ?></td>
                                        <td class="text-right" style="width:5%"><?php echo number_format($arr->cost,2)  ?></td>
                                        <td class="text-right" style="width:10%"><?php echo number_format($arr->profit,2)  ?></td>
                                    </tr>
                                <?php }?>
                                <tr>
                                    <th class="text-center">Totais:</th>
                                    <th class="text-right"><?php echo number_format($total_sold,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_income,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_discount,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_cost,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_profit,2) ?></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                </div>
                <?php }else{ ?>
                    <div class="row" style="margin-top:10px;">
                    <div class="col-md-12">
                        <table class="table table-bordered" width="100%">
                            <thead>
                                <tr>
                                    <th bgcolor="#DBDBDB"  class="text-center"><?= lang("name"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("code"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("Compra"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center" ><?= lang("qtd"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("tax"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("cost"); ?></th>
                                    <th bgcolor="#DBDBDB" class="text-center"><?= lang("income"); ?></th>
                                    <th nowrap="nowrap" bgcolor="#DBDBDB" class="text-center" ><?= lang("profit"); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($alldata as $key=>$arr){ 
                                    $total_cost= $total_cost+$arr->cost;
                                    $total_income= $total_income+$arr->income;
                                    $total_profit= $total_profit+$arr->profit;
                                    $total_purchases = $total_purchases + $arr->purchases;
                                    $total_sold = $total_sold + $arr->sold;
                                    $total_tax = $total_tax + $arr->tax;
                                    ?>
                                    <tr>
                                        <td style="width:25%"><?php echo $arr->name ?></td>
                                        <td  class="text-right" style="width:10%"><?php echo $arr->code ?></td>
                                        <td  class="text-right" style="width:10%"><?php echo $arr->purchases ?></td>
                                        <td class="text-right" style="width:10%"><?php echo $arr->sold ?></td>
                                        <td class="text-right" style="width:5%"><?php echo $arr->tax ?></td>
                                        <td class="text-right" style="width:10%"><?php echo number_format($arr->cost,2)  ?></td>
                                        <td class="text-right" style="width:10%"><?php echo number_format($arr->income,2)  ?></td>
                                        <td class="text-right" style="width:10%"><?php echo number_format($arr->profit,2) ?></td>
                                    </tr>
                                <?php }?>
                                <tr>
                                    <th colspan="2" class="text-center">Totais:</th>
                                    <th class="text-right"><?php echo number_format($total_purchases,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_sold,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_tax,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_cost,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_income,2) ?></th>
                                    <th class="text-right"><?php echo number_format($total_profit,2) ?></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                </div>
                <?php } ?>
                <div class="row" style="margin-top:20px;">
                    <div class="col-md-12">
                        <table class="table table-bordered" style="width: 30%;float: right;">
                            <tr>
                                <th width="50%">Total <?= lang("income"); ?>:</th>
                                <td width="50%" class="text-right"><?php echo number_format($total_income,2); ?></td>
                            </tr>
                            <tr>
                                <th>Total <?= lang("cost"); ?>:</th>
                                <td class="text-right"><?php echo number_format($total_cost,2); ?></td>
                            </tr>
                            <tr>
                                <th>Total <?= lang("profit"); ?>:</th>
                                <td class="text-right"><?php echo number_format($total_profit,2) ; ?></td>
                            </tr>
                        </table>
                    </div>                    
                </div>
            </div>
        </div>
    </body>
    <script src="<?php echo base_url(); ?>themes/default/assets/plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
    <script src="<?php echo base_url(); ?>themes/default/assets/plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>

    <script type="text/javascript">
        // $(function(){
        //     window.print();
        // })

        $(function(){
            $("#start_date").html("<?php echo $start_date; ?>");
            $("#end_date").html("<?php echo $end_date; ?>");
            // window.print();
        })
    </script>
</html>