<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<?php
$v = "?v=1";

if ($this->input->post('customer')) {
    $v .= "&customer=" . $this->input->post('customer');
}
if ($this->input->post('user')) {
    $v .= "&user=" . implode(",", (array)$this->input->post('user'));
}
if ($this->input->post('start_date')) {
    $v .= "&start_date=" . $this->input->post('start_date');
}
if ($this->input->post('end_date')) {
    $v .= "&end_date=" . $this->input->post('end_date');
}
if ($this->input->post('invoice_type')) {
    $v .= "&invoice_type=" . $this->input->post('invoice_type');
}
if ($this->input->post('products')) {
    $v .= "&products=" . implode(",", (array)$this->input->post('products'));
}
?>

<section class="content">
    <div class="row">
        <div class="col-sm-12">
            <div class="box box-primary">

                <div class="box-header">
                    <a href="#" class="btn btn-default btn-sm toggle_form pull-right"><?= lang("show_hide"); ?></a>

                    <a id="report_print_btn" class="btn btn-primary btn-sm pull-right" style="margin-right:10px;">
                        <i class="fa fa-print"></i>&nbsp;Relatorio POS
                    </a>

                    <a id="sale_print_btn" class="btn btn-primary btn-sm pull-right" style="margin-right:10px;">
                        <i class="fa fa-print"></i>&nbsp;Relatorio Facturas
                    </a>

                    <!-- ✅ BOTÃO AGT -->
                    <button type="button" id="btnListarAgt" class="btn btn-info btn-sm pull-right" style="margin-right:10px;">
                        <i class="fa fa-cloud-download"></i> Listar Facturas (AGT)
                    </button>

                    <h3 class="box-title"><?= lang('customize_report'); ?></h3>

                    <!-- PRINT FORM 1 -->
                    <?= form_open("reports/print_invoices",'id="print_form" target="_blank" style="display:none;"');?>
                        <?php
                        $cu[0] = lang("select")." ".lang("customer");
                        foreach($customers as $customer){
                            $cu[$customer->id] = $customer->name;
                        }
                        echo form_dropdown('customer', $cu, set_value('customer'));
                        ?>

                        <select class="form-control" multiple name="user[]" style="width:100%;">
                            <?php foreach ($users as $user): ?>
                                <?php if(in_array($user->id, (array)$this->input->post("user"))): ?>
                                    <option selected="selected" value="<?= $user->id ?>"><?= $user->first_name . " " . $user->last_name ?></option>
                                <?php else: ?>
                                    <option value="<?= $user->id ?>"><?= $user->first_name . " " . $user->last_name ?></option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </select>

                        <select class="form-control" multiple name="products[]" style="width:100%;">
                            <?php foreach ($products as $product): ?>
                                <?php if(in_array($product->id, (array)$this->input->post("products"))): ?>
                                    <option selected="selected" value="<?= $product->id ?>"><?= $product->name ?></option>
                                <?php else: ?>
                                    <option value="<?= $product->id ?>"><?= $product->name ?></option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </select>

                        <?= form_input('invoice_type', set_value('invoice_type'));?>
                        <?= form_input('start_date', set_value('start_date'));?>
                        <?= form_input('end_date', set_value('end_date'));?>
                    <?= form_close();?>

                    <!-- PRINT FORM 2 -->
                    <?= form_open("reports/print_invoices",'id="print_sale_form" target="_blank" style="display:none;"');?>
                        <?php
                        $cu2[0] = lang("select")." ".lang("customer");
                        foreach($customers as $customer){
                            $cu2[$customer->id] = $customer->name;
                        }
                        echo form_dropdown('customer', $cu2, set_value('customer'));
                        ?>

                        <select class="form-control" multiple name="user[]" style="width:100%;">
                            <?php foreach ($users as $user): ?>
                                <?php if(in_array($user->id, (array)$this->input->post("user"))): ?>
                                    <option selected="selected" value="<?= $user->id ?>"><?= $user->first_name . " " . $user->last_name ?></option>
                                <?php else: ?>
                                    <option value="<?= $user->id ?>"><?= $user->first_name . " " . $user->last_name ?></option>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </select>

                        <?= form_input('start_date', set_value('start_date'));?>
                        <?= form_input('end_date', set_value('end_date'));?>
                    <?= form_close();?>
                </div>

                <div class="box-body">

                    <div id="form" class="panel panel-warning" style="display:none;">
                        <div class="panel-body">
                            <?= form_open("reports/invoices");?>

                            <div class="row">
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="customer"><?= lang("customer"); ?></label>
                                        <?php
                                        $cu3[0] = lang("select")." ".lang("customer");
                                        foreach($customers as $customer){
                                            $cu3[$customer->id] = $customer->name;
                                        }
                                        echo form_dropdown('customer', $cu3, set_value('customer'), 'class="form-control select2" style="width:100%" id="customer');
                                        ?>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="start_date"><?= lang("start_date"); ?></label>
                                        <?= form_input('start_date', set_value('start_date'), 'class="form-control datetimepicker" id="start_date"');?>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="end_date"><?= lang("end_date"); ?></label>
                                        <?= form_input('end_date', set_value('end_date'), 'class="form-control datetimepicker" id="end_date"');?>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="invoice_type"><?= lang("invoice_type"); ?></label>
                                        <select id="invoice_type" name="invoice_type" class="form-control type select2" style="width:100%;">
                                            <option value=""><?= lang("select_invoice_type")?></option>
                                            <option value="FT"><?= lang("invoice")?></option>
                                            <option value="FR"><?= lang("invoice_receipt")?></option>
                                            <option value="FP"><?= lang("pro-forma")?></option>
                                            <option value="VD"><?= lang("cash_sale")?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="control-label" for="user"><?= lang("user"); ?></label>
                                        <select class="form-control" multiple name="user[]" id="user" style="width:100%;">
                                            <?php foreach ($users as $user): ?>
                                                <?php if(in_array($user->id, (array)$this->input->post("user"))): ?>
                                                    <option selected="selected" value="<?= $user->id ?>"><?= $user->first_name . " " . $user->last_name ?></option>
                                                <?php else: ?>
                                                    <option value="<?= $user->id ?>"><?= $user->first_name . " " . $user->last_name ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="control-label" for="products"><?= lang("products"); ?></label>
                                        <select class="form-control" multiple name="products[]" id="products" style="width:100%;">
                                            <?php foreach ($products as $product): ?>
                                                <?php if(in_array($product->id, (array)$this->input->post("products"))): ?>
                                                    <option selected="selected" value="<?= $product->id ?>"><?= $product->name ?></option>
                                                <?php else: ?>
                                                    <option value="<?= $product->id ?>"><?= $product->name ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-primary"><?= lang("submit"); ?></button>
                                </div>
                            </div>

                            <?= form_close();?>
                        </div>
                    </div>

                    <div class="clearfix"></div>

                    <div class="table-responsive">
                        <table id="SLRData" class="table table-striped table-bordered table-condensed table-hover">
                            <thead>
                                <tr class="active">
                                    <th class="col-sm-2"><?= lang("date"); ?></th>
                                    <th class="col-sm-2"><?= lang("customer"); ?></th>
                                    <th class="col-sm-2"><?= lang("InvoiceNo"); ?></th>
                                    <th class="col-sm-1"><?= lang("total"); ?></th>
                                    <th class="col-sm-1"><?= lang("tax"); ?></th>
                                    <th class="col-sm-1"><?= lang("discount"); ?></th>
                                    <th class="col-sm-1"><?= lang("grand_total"); ?></th>
                                    <th class="col-sm-1"><?= lang("paid"); ?></th>
                                    <th class="col-sm-2"><?= lang("due_amount"); ?></th>
                                    <th class="col-sm-1"><?= lang("action"); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="10" class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <?php if($this->input->post('customer')) { ?>
                        <div class="row">
                            <div class="col-md-6">
                                <button class="btn bg-purple btn-lg btn-block" style="cursor:default;">
                                    <strong><?= $total_sales ?></strong> <?= lang("total_sales"); ?>
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-success btn-lg btn-block" style="cursor:default;">
                                    <strong><?= $total_sales_value ? $total_sales_value : 0; ?></strong> <?= lang("total_sales_value"); ?>
                                </button>
                            </div>
                        </div>
                    <?php } ?>

                </div>
            </div>
        </div>
    </div>

    <!-- =========================================================
      MODAL: LISTAR FACTURAS NA AGT
    ========================================================= -->
    <div class="modal fade" id="modalListarAgt" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">

          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">Facturas na AGT</h4>
          </div>

          <div class="modal-body">

            <div class="row" style="margin-bottom:10px;">
              <div class="col-sm-3">
                <label>De</label>
                <input type="date" id="agtFromList" class="form-control" value="<?= date('Y-m-d'); ?>">
              </div>
              <div class="col-sm-3">
                <label>Até</label>
                <input type="date" id="agtToList" class="form-control" value="<?= date('Y-m-d'); ?>">
              </div>
              <div class="col-sm-3">
                <label>Tamanho</label>
                <input type="number" id="agtSizeList" class="form-control" value="50" min="1" max="500">
              </div>
              <div class="col-sm-3" style="padding-top:24px;">
                <button class="btn btn-primary" id="agtBuscarAgora">
                  <i class="fa fa-search"></i> Buscar
                </button>
              </div>
            </div>

            <div id="agtListarStatus" class="text-muted" style="margin-bottom:10px;"></div>
            <div id="agtListarErr" class="alert alert-danger" style="display:none;"></div>

            <div class="table-responsive">
              <table class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th style="width:70px;" class="text-center">Ação</th>
                    <th>Documento</th>
                    <th style="width:140px;">Data</th>
                    <th style="width:120px;">Tipo</th>
                  </tr>
                </thead>
                <tbody id="agtListBody">
                  <tr><td colspan="4" class="text-center">Sem dados</td></tr>
                </tbody>
              </table>
            </div>

            <details style="margin-top:10px;">
              <summary>Ver resposta completa (raw)</summary>
              <pre id="agtRaw" style="white-space:pre-wrap;"></pre>
            </details>

          </div>
        </div>
      </div>
    </div>

    <!-- =========================================================
      MODAL: DETALHE FACTURA NA AGT
    ========================================================= -->
    <div class="modal fade" id="modalAgtDetalhe" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">

          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">Detalhe da Factura – AGT</h4>
            <div class="text-muted" id="agtDetInvoiceNo" style="margin-top:4px;"></div>
          </div>

          <div class="modal-body">
            <div id="agtDetLoading" class="alert alert-info" style="display:none;">A consultar a AGT…</div>
            <div id="agtDetError" class="alert alert-danger" style="display:none;"></div>

            <div id="agtDetWrap" style="display:none;">
              <div class="row" style="margin-bottom:10px;">
                <div class="col-sm-4"><strong>Data:</strong> <span id="agtDetData">—</span></div>
                <div class="col-sm-4"><strong>Estado:</strong> <span id="agtDetEstado">—</span></div>
                <div class="col-sm-4"><strong>Total:</strong> <span id="agtDetTotal">—</span></div>
              </div>

              <div style="margin-bottom:10px;">
                <strong>Cliente:</strong> <span id="agtDetCliente">—</span>
              </div>

              <div class="table-responsive">
                <table class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th style="width:60px;">#</th>
                      <th>Descrição</th>
                      <th style="width:110px;" class="text-right">Qtd</th>
                      <th style="width:140px;" class="text-right">Preço</th>
                      <th style="width:140px;" class="text-right">Subtotal</th>
                    </tr>
                  </thead>
                  <tbody id="agtDetLinhas">
                    <tr><td colspan="5" class="text-center">—</td></tr>
                  </tbody>
                </table>
              </div>

              <details style="margin-top:10px;">
                <summary>Ver resposta RAW (debug)</summary>
                <pre id="agtDetRaw" style="white-space:pre-wrap;"></pre>
              </details>
            </div>

          </div>
        </div>
      </div>
    </div>

</section>

<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>

<script>
/** URLs certas (CI) */
var URL_AGT_LISTAR   = "<?= site_url('Agt/listar_facturas'); ?>";
var URL_AGT_DETALHE  = "<?= site_url('Agt/consultar_factura'); ?>";

/** Helpers */
function escapeHtml(str) {
    str = (str === null || str === undefined) ? '' : String(str);
    return str.replace(/[&<>"'`=\/]/g, function (s) {
        return ({
            '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;',
            '/':'&#x2F;','`':'&#x60;','=':'&#x3D;'
        })[s];
    });
}
function escapeAttr(str) { return escapeHtml(str).replace(/"/g, '&quot;'); }
function pickFirst(obj, keys) {
    if (!obj || typeof obj !== 'object') return null;
    for (var i=0; i<keys.length; i++) {
        var k = keys[i];
        if (obj[k] !== undefined && obj[k] !== null && obj[k] !== '') return obj[k];
    }
    return null;
}
function formatMoney(v) {
    if (v === null || v === undefined || v === '') return '—';
    var s = String(v).replace(/\s+/g,'').replace(',', '.');
    var n = parseFloat(s);
    if (isNaN(n)) return String(v);
    return n.toLocaleString('pt-PT', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}

/** Parse robusto (BOM, lixo, notices, JSON dentro de JSON) */
function safeParseAgt(anyBody) {
    if (!anyBody) return null;
    if (typeof anyBody === 'object') return anyBody;

    var s = String(anyBody).replace(/^\uFEFF/, '').trim();

    var parsed = null;
    try { parsed = JSON.parse(s); } catch(e) { parsed = null; }

    if (typeof parsed === 'string') {
        var s2 = String(parsed).replace(/^\uFEFF/, '').trim();
        try { parsed = JSON.parse(s2); } catch(e2) {}
    }

    if (!parsed) {
        var i1 = s.indexOf('{');
        var i2 = s.lastIndexOf('}');
        if (i1 >= 0 && i2 > i1) {
            var cut = s.substring(i1, i2 + 1);
            try { parsed = JSON.parse(cut); } catch(e3) { parsed = null; }
        }
    }

    return parsed;
}

$(document).ready(function () {

    // DataTable
    $('#SLRData').dataTable({
        "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, '<?= lang('all'); ?>']],
        "aaSorting": [[0, "desc"]],
        "iDisplayLength": <?= (int)$Settings->rows_per_page ?>,
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": "<?= site_url('reports/get_invoices/'. $v) ?>",
        "fnServerData": function (sSource, aoData, fnCallback) {
            aoData.push({
                "name": "<?= $this->security->get_csrf_token_name() ?>",
                "value": "<?= $this->security->get_csrf_hash() ?>"
            });
            $.ajax({"dataType":"json","type":"POST","url":sSource,"data":aoData,"success":fnCallback});
        },
        "aoColumns": [
            {"mRender": hrld},
            null,
            null,
            {"mRender": currencyFormat},
            {"mRender": currencyFormat},
            {"mRender": currencyFormat},
            {"mRender": currencyFormat},
            {"mRender": currencyFormat},
            {"mRender": currencyFormat},
            {"bSortable": false, "bSearchable": false}
        ]
    });

    // Toggle
    $('.toggle_form').click(function(){
        $("#form").slideToggle();
        return false;
    });

    // Datetimepicker
    $('.datetimepicker').datetimepicker({ format: 'YYYY-MM-DD HH:mm' });

    // Print buttons
    $("body").on("click","#report_print_btn",function(){ $("#print_form").submit(); });
    $("body").on("click","#sale_print_btn",function(){ $("#print_sale_form").submit(); });

    // Abrir modal listar AGT
    $('#btnListarAgt').on('click', function(){
        $('#agtListarErr').hide().html('');
        $('#agtListarStatus').html('Escolhe o intervalo e clica em <b>Buscar</b>.');
        $('#agtListBody').html('<tr><td colspan="4" class="text-center">Sem dados</td></tr>');
        $('#agtRaw').text('');
        $('#modalListarAgt').modal('show');
    });

    // Buscar lista AGT
    $('#agtBuscarAgora').on('click', function(){
        agtListarFacturas();
    });

    // Lupa (delegado)
    $(document).on('click', '.btn-agt-detalhe', function(e){
        e.preventDefault();
        agtOpenDetalhe($(this).data('invoiceno'));
    });
});

function agtListarFacturas()
{
    var from = ($('#agtFromList').val() || '').trim();
    var to   = ($('#agtToList').val() || '').trim();
    var size = ($('#agtSizeList').val() || '50').trim();

    $('#agtListarErr').hide().html('');
    $('#agtListarStatus').html('A consultar a AGT…');
    $('#agtListBody').html('<tr><td colspan="4" class="text-center">A carregar…</td></tr>');
    $('#agtRaw').text('');

    $.ajax({
        url: URL_AGT_LISTAR,     // ✅ CORRIGIDO
        method: "GET",
        dataType: "json",
        cache: false,
        data: { send: 1, from: from, to: to, size: size, debug: 0 }
    })
    .done(function(resp){

        try { $('#agtRaw').text(JSON.stringify(resp, null, 2)); } catch(e) {}

        if (!resp) {
            $('#agtListarErr').show().html('Resposta vazia do servidor.');
            return;
        }

        // Parse do body
        var agtJson = null;
        if (resp.agt && resp.agt.json && typeof resp.agt.json === 'object') {
            agtJson = resp.agt.json;
        } else if (resp.agt && resp.agt.body !== undefined) {
            agtJson = safeParseAgt(resp.agt.body);
        } else if (resp.body !== undefined) {
            agtJson = safeParseAgt(resp.body);
        }

        if (!agtJson) {
            var rawTxt = (resp.agt && resp.agt.body !== undefined) ? String(resp.agt.body) : JSON.stringify(resp, null, 2);
            $('#agtRaw').text(rawTxt);

            $('#agtListarErr').show().html(
                'Resposta inválida da AGT.<br>' +
                '<small>O backend devolveu texto que não é JSON (ou veio com HTML/avisos). Vê o RAW.</small>'
            );
            $('#agtListarStatus').html('');
            $('#agtListBody').html('<tr><td colspan="4" class="text-center">Sem dados</td></tr>');
            return;
        }

        $('#agtRaw').text(JSON.stringify(agtJson, null, 2));

        // DS-120: statusResult.resultEntryList[]
        var list = [];
        if (agtJson && agtJson.statusResult && Array.isArray(agtJson.statusResult.resultEntryList)) {
            list = agtJson.statusResult.resultEntryList;
        } else if (agtJson && Array.isArray(agtJson.resultEntryList)) {
            list = agtJson.resultEntryList;
        }

        var totalCount = (agtJson && agtJson.statusResult && agtJson.statusResult.documentResultCount)
            ? agtJson.statusResult.documentResultCount
            : list.length;

        $('#agtListarStatus').html('Registos: ' + totalCount);

        if (list.length === 0) {
            $('#agtListBody').html('<tr><td colspan="4" class="text-center">Nenhuma factura encontrada</td></tr>');
            return;
        }

        var html = '';
        for (var i=0; i<list.length; i++) {
            var row = list[i] || {};
            var it = row.documentEntryResult ? row.documentEntryResult : row;

            var invoiceNo = it.documentNo || it.invoiceNo || it.documentNumber || '';
            var issueDate = it.documentDate || it.issueDate || it.date || '';
            var tipo      = it.documentType || it.invoiceType || it.type || '';

            if (!invoiceNo) continue;

            html += '<tr>'
                + '<td class="text-center">'
                +   '<a href="#" class="btn btn-primary btn-xs btn-agt-detalhe"'
                +   ' data-invoiceno="' + escapeAttr(invoiceNo) + '" title="Ver detalhe">'
                +     '<i class="fa fa-search"></i>'
                +   '</a>'
                + '</td>'
                + '<td>' + escapeHtml(invoiceNo) + '</td>'
                + '<td>' + escapeHtml(issueDate) + '</td>'
                + '<td>' + escapeHtml(tipo) + '</td>'
                + '</tr>';
        }

        if (!html) html = '<tr><td colspan="4" class="text-center">Sem dados</td></tr>';
        $('#agtListBody').html(html);
    })
    .fail(function(xhr){
        var msg = "Erro AJAX ao listar a AGT.";
        if (xhr && xhr.responseText) {
            msg += "<br><small style='opacity:.85'>" + escapeHtml(xhr.responseText) + "</small>";
            $('#agtRaw').text(xhr.responseText);
        }
        $('#agtListarErr').show().html(msg);
        $('#agtListarStatus').html('');
        $('#agtListBody').html('<tr><td colspan="4" class="text-center">Sem dados</td></tr>');
    });
}

function agtOpenDetalhe(invoiceNo)
{
    invoiceNo = (invoiceNo || '').toString().trim();
    if (!invoiceNo) return;

    $('#agtDetInvoiceNo').text(invoiceNo);
    $('#agtDetError').hide().html('');
    $('#agtDetWrap').hide();
    $('#agtDetLoading').show();
    $('#agtDetData').text('—');
    $('#agtDetEstado').text('—');
    $('#agtDetTotal').text('—');
    $('#agtDetCliente').text('—');
    $('#agtDetLinhas').html('<tr><td colspan="5" class="text-center">A carregar…</td></tr>');
    $('#agtDetRaw').text('');

    $('#modalAgtDetalhe').modal('show');

    $.ajax({
        url: URL_AGT_DETALHE,    // ✅ CORRIGIDO
        method: "GET",
        dataType: "json",
        cache: false,
        data: { send: 1, invoiceNo: invoiceNo, debug: 0 }
    })
    .done(function(resp){

        $('#agtDetLoading').hide();

        if (!resp || resp.ok !== true) {
            var msg = "Erro ao consultar a AGT.";
            if (resp && resp.agt && resp.agt.body) {
                msg += "<br><small style='opacity:.85'>" + escapeHtml(resp.agt.body) + "</small>";
            }
            $('#agtDetError').show().html(msg);
            return;
        }

        var j = (resp.agt && resp.agt.json && typeof resp.agt.json === 'object')
            ? resp.agt.json
            : safeParseAgt(resp.agt ? resp.agt.body : null) || {};

        $('#agtDetRaw').text(JSON.stringify(j, null, 2));

        $('#agtDetData').text( pickFirst(j, ['issueDate','invoiceDate','date','documentDate','data']) || '—' );
        $('#agtDetEstado').text( pickFirst(j, ['status','invoiceStatus','estado']) || '—' );

        var total = pickFirst(j, ['total','invoiceTotal','grossTotal','totalAmount','totalPayable']);
        $('#agtDetTotal').text( formatMoney(total) );

        var cliente = pickFirst(j, ['customerName','buyerName','customer','cliente','customerDetail','buyer']);
        if (typeof cliente === 'object' && cliente) {
            cliente = pickFirst(cliente, ['name','nome','legalName','customerName','buyerName']) || JSON.stringify(cliente);
        }
        $('#agtDetCliente').text(cliente || '—');

        var linhas = pickFirst(j, ['lines','invoiceLines','items','lineItems']);
        if (!Array.isArray(linhas)) linhas = [];

        var html = '';
        for (var i=0; i<linhas.length; i++) {
            var l = linhas[i] || {};
            var desc  = pickFirst(l, ['description','desc','productDescription','itemDescription','name','nome']) || '—';
            var qtd   = pickFirst(l, ['quantity','qty','qtd']) || '';
            var preco = pickFirst(l, ['unitPrice','price','preco']) || '';
            var sub   = pickFirst(l, ['lineTotal','subtotal','total','amount']) || '';

            html += '<tr>'
                + '<td>' + (i+1) + '</td>'
                + '<td>' + escapeHtml(String(desc)) + '</td>'
                + '<td class="text-right">' + escapeHtml(String(qtd)) + '</td>'
                + '<td class="text-right">' + escapeHtml(formatMoney(preco)) + '</td>'
                + '<td class="text-right">' + escapeHtml(formatMoney(sub)) + '</td>'
                + '</tr>';
        }

        if (!html) html = '<tr><td colspan="5" class="text-center">Sem linhas</td></tr>';

        $('#agtDetLinhas').html(html);
        $('#agtDetWrap').show();
    })
    .fail(function(xhr){
        $('#agtDetLoading').hide();
        var msg3 = "Erro AJAX ao consultar a AGT.";
        if (xhr && xhr.responseText) {
            msg3 += "<br><small style='opacity:.85'>" + escapeHtml(xhr.responseText) + "</small>";
            $('#agtDetRaw').text(xhr.responseText);
        }
        $('#agtDetError').show().html(msg3);
    });
}
</script>

