<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('update_info'); ?></h3>
                </div>
                <div class="box-body">
                    <div class="col-lg-12">
                        <?= form_open_multipart("products/edit/" . $product->id, 'class="validation"'); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('type', 'type'); ?>
                                    <?php $opts = array('standard' => lang('standard'), 'combo' => lang('combo'), 'service' => lang('service')); ?>
                                    <?= form_dropdown('type', $opts, set_value('type', $product->type), 'class="form-control tip select2" id="type"  required="required" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('name', 'name'); ?>
                                    <?= form_input('name', $product->name, 'class="form-control tip" id="name"  required="required"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('code', 'code'); ?> <?= lang('can_use_barcode'); ?>
                                    <?= form_input('code', $product->code, 'class="form-control tip" id="code"  required="required"'); ?>
                                </div>
                                <div class="form-group all">
                                    <?= lang("barcode_symbology", "barcode_symbology") ?>
                                    <?php
                                    $bs = array('code25' => 'Code25', 'code39' => 'Code39', 'code128' => 'Code128', 'ean8' => 'EAN8', 'ean13' => 'EAN13', 'upca ' => 'UPC-A', 'upce' => 'UPC-E');
                                    echo form_dropdown('barcode_symbology', $bs, set_value('barcode_symbology', $product->barcode_symbology), 'class="form-control select2" id="barcode_symbology" required="required" style="width:100%;"');
                                    ?>
                                </div>

                                <div class="form-group">
                                    <?= lang('category', 'category'); ?>
                                    <?php
                                    $cat[''] = lang("select") . " " . lang("category");
                                    foreach ($categories as $category) {
                                        $cat[$category->id] = $category->name;
                                    }
                                    ?>
                                    <?= form_dropdown('category', $cat, $product->category_id, 'class="form-control select2 tip" id="category"  required="required"'); ?>
                                </div>

                                <div class="form-group">
                                    <?= lang('cost', 'cost'); ?>
                                    <?= form_input('cost', $product->cost, 'class="form-control tip" id="cost"  required="required"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('percent_price', 'percent_price'); ?>
                                    <?= form_input('percent', set_value('percent',$product->percent), 'class="form-control tip" id="percent" '); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('price', 'price'); ?>
                                    <?= form_input('price', $product->price, 'class="form-control tip" id="price"  required="required"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('product_tax', 'tax_id'); ?>
                                    <?php
                                    $tax_ids = [];
                                    $tax_infos = get_rows("tec_tax");
                                    foreach ($tax_infos as $tax_info) {
                                        $tax_ids[$tax_info['id']] = $tax_info['tax'] . "% | " . $tax_info['tax_type'] . " | " . $tax_info['reason'];
                                    }
                                    ?>

                                    <?= form_dropdown('tax_id', $tax_ids, $product->tax_id, 'class="form-control select2 tip" id="tax_id"  required="required" style="width:100%;"'); ?>

                                </div>

                                <!-- <div class="form-group">
                                <?= lang('product_tax', 'product_tax'); ?>
                                <?= form_input('product_tax', $product->tax, 'class="form-control tip" id="product_tax"  required="required"'); ?>
                                </div> -->
                                <div class="form-group">
                                    <?= lang('tax_method', 'tax_method'); ?>
                                    <?php $tm = array(0 => lang('inclusive'), 1 => lang('exclusive')); ?>
                                    <?= form_dropdown('tax_method', $tm, set_value('tax_method', $product->tax_method), 'class="form-control tip select2" id="tax_method"  required="required" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group" id="st">
                                    <?= lang('quantity', 'quantity'); ?>
                                    <?= form_input('quantity', set_value('quantity', $product->quantity), 'class="form-control tip" id="quantity"  required="required"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('Validity', 'Validity'); ?>
                                    <?php $opts2 = array('Yes' => lang('Yes'), 'No' => lang('No')); ?>
                                    <?= form_dropdown('validity', $opts2, set_value('validity', $product->validity), 'class="form-control tip select2" id="validity"  required="required" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group" id="validity_date_div">
                                    <?= lang('validity_date', 'validity_date'); ?>
                                    <?= form_input('validity_date', set_value('validity_date', $product->validity_date), 'class="form-control tip" id="validity_date"  required="required"'); ?>
                                </div>                              
                                <div class="form-group">
                                    <?= lang('UnitOfMeasure', 'UnitOfMeasure'); ?>
                                    <?php $opts_unit = array('Uni' => lang('Uni'), 'Cx' => lang('Cx')); ?>
                                    <?= form_dropdown('UnitOfMeasure', $opts_unit, set_value('tax_method', $product->UnitOfMeasure), 'class="form-control tip select2" id="UnitOfMeasure"  required="required" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group" style="display:<?php 
                                    if($product->UnitOfMeasure=='Uni'){
                                        echo "none";
                                    }
                                ?>">
                                    <?= lang('Qtd Na Caixa', 'Qtd Na Caixa'); ?>
                                    <?= form_input('qty_na_caixa', set_value('qty_na_caixa', $product->qty_na_caixa), 'class="form-control tip" id="qty_na_caixa" '); ?>
                                </div>

                                <div class="form-group" id="st">
                                    <?= lang('alert_quantity', 'alert_quantity'); ?>
                                    <?= form_input('alert_quantity', set_value('alert_quantity', $product->alert_quantity), 'class="form-control tip" id="alert_quantity"  required="required"'); ?>
                                </div>

                                <div class="form-group">
                                    <?= lang('image', 'image'); ?>
                                    <input type="file" name="userfile" id="image">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div id="ct" style="display:none;">

                                    <div class="form-group">
                                        <?= lang("add_product", "add_item"); ?>
                                        <?php echo form_input('add_item', '', 'class="form-control ttip" id="add_item" data-placement="top" data-trigger="focus" data-bv-notEmpty-message="' . lang('please_add_items_below') . '" placeholder="' . $this->lang->line("add_item") . '"'); ?>
                                    </div>
                                    <div class="control-group table-group">
                                        <label class="table-label" for="combo"><?= lang("combo_products"); ?></label>

                                        <div class="controls table-controls">
                                            <table id="prTable"
                                                   class="table items table-striped table-bordered table-condensed table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="col-xs-9"><?= lang("product_name") . " (" . $this->lang->line("product_code") . ")"; ?></th>
                                                        <th class="col-xs-2"><?= lang("quantity"); ?></th>
                                                        <th class=" col-xs-1 text-center"><i class="fa fa-trash-o trash-opacity-50"></i></th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                                <tfoot></tfoot>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <?= lang('details', 'details'); ?>
                            <?= form_textarea('details', $product->details, 'class="form-control tip redactor" id="details"'); ?>
                        </div>
                        <div class="form-group">
                            <?= form_submit('edit_product', lang('edit_product'), 'class="btn btn-primary"'); ?>
                        </div>
                        <?= form_close(); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<script src="<?= $assets ?>dist/js/jquery-ui.min.js" type="text/javascript"></script>
<script type="text/javascript" charset="utf-8">
    var price = 0;
    cost = 0;
    items = {};
    $("#UnitOfMeasure").on("change", function(e){
        if(e.target.value=="Cx"){
            $("#qty_na_caixa").closest('.form-group').show();
        }else{
            $("#qty_na_caixa").val("");
            $("#qty_na_caixa").closest('.form-group').hide();
        }
    })
    $(document).ready(function () {
        $('#type').change(function (e) {
            var type = $(this).val();
            if (type == 'combo') {
                $('#st').slideUp();
                $('#ct').slideDown();
                //$('#cost').attr('readonly', true);
            } else if (type == 'service') {
                $('#st').slideUp();
                $('#ct').slideUp();
                //$('#cost').attr('readonly', false);
            } else {
                $('#ct').slideUp();
                $('#st').slideDown();
                //$('#cost').attr('readonly', false);
            }
        });

        $('#validity').change(function (e) {
            var validity = $(this).val();
            if (validity === 'Yes') {
                $('#validity_date_div').slideDown();
                //$('#cost').attr('readonly', true);
            } else {
                $('#validity_date_div').slideUp();
                $('#validity_date').val('0000-00-00');
            }
        });

        $("#add_item").autocomplete({
            source: '<?= site_url('products/suggestions'); ?>',
            minLength: 1,
            autoFocus: false,
            delay: 200,
            response: function (event, ui) {
                if ($(this).val().length >= 16 && ui.content[0].id == 0) {
                    bootbox.alert('<?= lang('no_product_found') ?>', function () {
                        $('#add_item').focus();
                    });
                    $(this).val('');
                } else if (ui.content.length == 1 && ui.content[0].id != 0) {
                    ui.item = ui.content[0];
                    $(this).data('ui-autocomplete')._trigger('select', 'autocompleteselect', ui);
                    $(this).autocomplete('close');
                    $(this).removeClass('ui-autocomplete-loading');
                } else if (ui.content.length == 1 && ui.content[0].id == 0) {
                    bootbox.alert('<?= lang('no_product_found') ?>', function () {
                        $('#add_item').focus();
                    });
                    $(this).val('');

                }
            },
            select: function (event, ui) {
                event.preventDefault();
                if (ui.item.id !== 0) {
                    var row = add_product_item(ui.item);
                    if (row) {
                        $(this).val('');
                    }
                } else {
                    bootbox.alert('<?= lang('no_product_found') ?>');
                }
            }
        });
        $('#add_item').bind('keypress', function (e) {
            if (e.keyCode == 13) {
                e.preventDefault();
                $(this).autocomplete("search");
            }
        });

        $(document).on('click', '.del', function () {
            var id = $(this).attr('id');
            delete items[id];
            $(this).closest('#row_' + id).remove();
        });


        $(document).on('change', '.rqty', function () {
            var item_id = $(this).attr('data-item');
            items[item_id].row.qty = (parseFloat($(this).val())).toFixed(2);
            add_product_item(null, 1);
        });

        $(document).on('change', '.rprice', function () {
            var item_id = $(this).attr('data-item');
            items[item_id].row.price = (parseFloat($(this).val())).toFixed(2);
            add_product_item(null, 1);
        });

        function add_product_item(item, noitem) {
            if (item == null && noitem == null) {
                return false;
            }
            if (noitem != 1) {
                item_id = item.row.id;
                if (items[item_id]) {
                    items[item_id].row.qty = (parseFloat(items[item_id].row.qty) + 1).toFixed(2);
                } else {
                    items[item_id] = item;
                }
            }
            price = 0;
            cost = 0;

            $("#prTable tbody").empty();
            $.each(items, function () {
                var item = this.row;
                var row_no = item.id;
                var newTr = $('<tr id="row_' + row_no + '" class="item_' + item.id + '"></tr>');
                tr_html = '<td><input name="combo_item_code[]" type="hidden" value="' + item.code + '"><span id="name_' + row_no + '">' + item.name + ' (' + item.code + ')</span></td>';
                tr_html += '<td><input class="form-control text-center rqty" name="combo_item_quantity[]" type="text" value="' + formatDecimal(item.qty) + '" data-id="' + row_no + '" data-item="' + item.id + '" id="quantity_' + row_no + '" onClick="this.select();"></td>';
                //tr_html += '<td><input class="form-control text-center rprice" name="combo_item_price[]" type="text" value="' + formatDecimal(item.price) + '" data-id="' + row_no + '" data-item="' + item.id + '" id="combo_item_price_' + row_no + '" onClick="this.select();"></td>';
                tr_html += '<td class="text-center"><i class="fa fa-times tip del" id="' + row_no + '" title="Remove" style="cursor:pointer;"></i></td>';
                newTr.html(tr_html);
                newTr.prependTo("#prTable");
                //price += formatDecimal(item.price*item.qty);
                cost += formatDecimal(item.cost * item.qty);
            });
            $('#cost').val(cost);
            return true;
        }
        var type = $('#type').val();
        if (type == 'combo') {
            $('#st').slideUp();
            $('#ct').slideDown();
            //$('#cost').attr('readonly', true);
        } else if (type == 'service') {
            $('#st').slideUp();
            $('#ct').slideUp();
            //$('#cost').attr('readonly', false);
        } else {
            $('#ct').slideUp();
            $('#st').slideDown();
            //$('#cost').attr('readonly', false);
        }
<?php
if ($this->input->post('type') == 'combo') {
    $c = sizeof($_POST['combo_item_code']);
    $items = array();
    for ($r = 0; $r <= $c; $r++) {
        if (isset($_POST['combo_item_code'][$r]) && isset($_POST['combo_item_quantity'][$r])) {
            $items[] = array('id' => $_POST['combo_item_id'][$r], 'row' => array('id' => $_POST['combo_item_id'][$r], 'name' => $_POST['combo_item_name'][$r], 'code' => $_POST['combo_item_code'][$r], 'qty' => $_POST['combo_item_quantity'][$r], 'cost' => $_POST['combo_item_cost'][$r]));
        }
    }
    echo '
            var ci = ' . json_encode($items) . ';
            $.each(ci, function() { add_product_item(this); });
            ';
} elseif (!empty($items)) {
    echo '
            var ci = ' . json_encode($items) . ';
            $.each(ci, function() { add_product_item(this); });
            ';
}
?>
    });

</script>
<script>
    jQuery('input').on('keyup', function () {
        var m = parseInt(jQuery('#cost').val() != '' ? jQuery('#cost').val() : 0);

        var j = parseInt(jQuery('#percent').val() != '' ? jQuery('#percent').val() : 0);
        if (j != 0) {
            total = ((m + (m * (j / 100))));

            jQuery('#price').val(total.toFixed(2));
        }

    });
</script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });
    });
</script>
