<?php

include "QRCodeGenerator.class.php";

function product_name($name)
{
    return character_limiter($name, (isset($Settings->char_per_line) ? ($Settings->char_per_line-8) : 35));
}

if ($modal) {
    echo '<div class="modal-dialog no-modal-header"><div class="modal-content"><div class="modal-body"><button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i></button>';
} else { ?>
    <!doctype html>
    <html>
    <head>
        <meta charset="utf-8">
        <title><?= $page_title . " " . lang("no") . " " . $inv->id; ?></title>
        <base href="<?= base_url() ?>"/>
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
        <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="../../../../estilo.css" rel="stylesheet" type="text/css" />
<link href="../../../../css/print.css" rel="stylesheet" type="text/css" />  
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width: 480px; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 5px; }
            .table { border-radius: 3px; }
            .table th { background: #f5f5f5; }
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }

            @media print {
                .no-print { display: none; }
                #wrapper { max-width: 480px; width: 100%; min-width: 250px; margin: 0 auto; }
            }
        </style>
         <style type="text/css" media="all">
            .table { margin-bottom: 0px; }
            body { color: #000; }
            #wrapper { max-width: 780px; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 5px; }
            .table { border-radius: 3px; }
            .table th { background: #f5f5f5; }
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .print_color{ color: black!important; }
            .print-color-red{ color: red!important; }
            .td-color{
                background: #B8B3B3 !important;
                color: black!important;
                background-color: #B8B3B3 !important;
                color: black!important;
                width: 100%;
                padding: 0px;
                margin: 0px;
                font-size: 14px;
                padding: 5px 10px;
            }
            .tr-footer td{ font-weight: bold; }
            .print-spec{ min-height: 150px; }
            .no-screen{ display: none; }
            .cancelado {
                display: block; position: absolute; top: 50%; left: 50%;
                transform: translate(-50%, -50%); z-index: -1; opacity : 0.1;
            }
            @media print {
                .no-screen{ display: table; }
                .no-print { display: none; }
                .text-align-right{ text-align: right !important; width: 100% !important; }
                #wrapper { max-width: 780px; width: 100%; min-width: 250px; margin: 0 auto; }
                .print_color{ color: #000000 !important; }
                .print-color-red{ color: #ff8100 !important; }
                .td-color{
                    background-color: #B8B3B3 !important; color: black!important; width: 100%;
                    padding: 0px; margin: 0px; font-size: 18px; padding: 5px 0px; padding-left: 5px !important;
                }
                .td-color font{
                    background-color: #B8B3B3 !important; color: black!important; width: 100%;
                    padding: 0px; margin: 0px; font-size: 18px; padding: 5px 0px; padding-left: 5px !important;
                }
                .cancelado { display: block; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: -1; opacity : 0.1; }
            }
            p{ margin: 0px; }
            .total_table th{ height: 25px; vertical-align: top; font-size: 12px; }
            #qrcode img{ margin: auto; margin-top: 5px; margin-bottom: 5px; }

            #qrwrap{
  position: relative;
  width:350px;
  height: 350;
}

#qrcode{
  width: 350px;
  height: 350;
}

/* Logo no centro, com tamanho < 20% (70px) */
#agtLogo{
  position: absolute;
  left: 50%;
  top: 50%;
  width: 65;              /* < 70px (20% de 350) */
  height: 30px;
  transform: translate(-50%, -50%);
  background: #fff;         /* “ilha branca” para legibilidade */
  padding: 6px;
  border-radius: 2px;
  box-sizing: border-box;
  pointer-events: none;
}

        </style>
    </head>

    <body>

<?php } ?>
<div id="wrapper" >

    <div id="receiptData" width="270px" height="" border="0"  cellpadding="12" cellspacing="5" class="resultado">
    <div class="no-print">
        <?php if ($message) { ?>
            <div class="alert alert-success">
                <a  href="<?= site_url('pos'); ?>" class="btn btn-success"> <i class="glyphicon glyphicon-plus"></i> Voltar na venda POS</a><button data-dismiss="alert" class="close" type="button">×</button>
                <?= is_array($message) ? print_r($message, true) : $message; ?>
            </div>
        <?php } ?>
    </div>
    <div  style="al" id="receipt-data">
        <div class="text-center">
            <div id=""><img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logotipo"  width="<?= $Settings->cancel_sale; ?>" height="<?= $Settings->suspend_sale; ?>" border="0" />
    </div>
         <?php //include ("empresa.php") 
			    ?>
                 <span style="font-weight: bold">
                <?php
                             echo $Settings->CompanyName; 
                             ?>
                <br> </span>
                <span style="font-size: 12px">NIF:
<?php echo $Settings->TaxRegistrationNumber; ;
                               ?>
                <br>
              <?= $Settings->AddressDetail; ?>
                <br>
               Tel.: <?= $Settings->phone;; ?>
                
                <br>
                <br>
			<?php 
                                if($inv->InvoiceStatus == "A") echo lang("canceled");
                            ?>
                </span>
                <p class="print_color"  style="font-size: 12px;  text-align: right">
                         <b>   <?php
                                switch ($inv->InvoiceType) {
                                    case 'FR':
                                        echo lang("invoice_receipt");
                                        break;

                                    case 'FT':
                                        echo lang("invoice");
                                        break;
                                    
                                    case 'FP':
                                        echo lang("pro-forma");
                                        break;

                                    case 'VD':
                                        echo lang("cash_sale");
                                        break;
                                    default:
                                        # code...
                                        break;
                                }
							 ?> </b><br><b><?= $inv->InvoiceNo;?></b>
                      </br>
			
                <?= lang("date").': '.$this->tec->hrld($inv->date); ?> <br>
    <p class="print_color"  style="font-size: 12px;  text-align: left">   <?php  echo '<b style="font-size: 12px " class="text-left" >Exmo(s) Senhor(es): </b> ';  echo '</tr>'.$customer->name;?>
	  <br>  <?php $cusumidor= 'Consumidor Final';  echo '<b style="font-size: 12px " class="text-left">NIF: </b> '; if($customer->cf1 == "999999999") echo '</tr>'.$cusumidor; else echo '</tr>'.$customer->cf1;?>
	  <br>  <?php  echo '<b style="font-size: 12px " class="text-left">Morada: </b> ';echo '</tr>'.$customer->endereco;  ?>
      
                </p>
            <div style="clear:both;"></div>
            <table width="565" class="table table-striped table-condensed">
                <thead>
                    <tr>
                        <th class="text-left col-xs-8" style="font-size: 12px "><?=lang('description');?></th>
                        <th class="text-right col-xs-1"style="font-size: 12px "><?=lang('quantity');?></th>
                        <th class="text-right col-xs-1"style="font-size: 12px "><?=lang('price');?></th>
						
                        <th class="text-right col-xs-1"style="font-size: 12px "><?=lang('subtotal');?></th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $tax_summary = array();
                foreach ($rows as $row) {
                    if($item_code  != "")
                            echo '<td  style="font-size: 10px" width="70%"  align="left">'  . $row->product_name . $item_code.' </td>';
                        else 
                            echo '<td  style="font-size: 10px" width="70%"  align="left"><span class="print-color-black" style="font-size:9px; ">('.$row->tax_id.') </span>'  .$row->product_name .  ' </td>';
                    echo '<td style="font-size: 11px" class="text-right">' . $this->tec->formatNumber($row->quantity) . '</td>';
                    echo '<td style="font-size: 11px" class="text-right">';

                    if ($inv->total_discount != 0) {
                        $price_with_discount = $this->tec->formatMoney($row->net_unit_price + $this->tec->formatDecimal($row->item_discount / $row->quantity));
                        $pr_tax = $row->tax_method ?
                        $this->tec->formatDecimal((($price_with_discount) * $row->tax) / 100) :
                        $this->tec->formatDecimal((($price_with_discount) * $row->tax) / (100 + $row->tax));
                        echo '<del> ' . $this->tec->formatMoney($price_with_discount+$pr_tax) . '</del> ';
						
                    }

                    echo $this->tec->formatMoney($row->net_unit_price + ($row->item_tax / $row->quantity)) . '</td><td style="font-size: 12px" class="text-right">' . $this->tec->formatMoney($row->subtotal) . '</td></tr>'; 
					
					
                }
					
                ?>
                </tbody>
                <tfoot>
					
                <tr>
                    <th colspan="2" style="font-size: 12px "><?= lang("total"); ?></th>
                    <th colspan="2" class="text-right" style="font-size: 12px "><?= $this->tec->formatMoney($inv->total); ?></th>
                </tr>
					<tr>
                    <th colspan="2" style="font-size: 12px "><?= lang("tax"); ?></th>
                    <th colspan="2" class="text-right" style="font-size: 12px "><?= $this->tec->formatMoney( $inv->product_tax); ?></th>
                </tr>
                <?php
                if ($inv->order_tax != 0) {
                    echo '<tr><th colspan="2" style="font-size: 12px " >' . lang("order_tax") . '</th><th colspan="2" class="text-right">' . $this->tec->formatMoney($inv->order_tax) . '</th></tr>';
                }
                if ($inv->total_discount != 0) {
                    echo '<tr><th colspan="2" style="font-size: 12px ">' . lang("order_discount") . '</th><th colspan="2" class="text-right">' . $this->tec->formatMoney($inv->total_discount) . '</th></tr>';
                }

                if ($Settings->rounding) {
                    $round_total = $this->tec->roundNumber($inv->grand_total, $Settings->rounding);
                    $rounding = $this->tec->formatMoney($round_total - $inv->grand_total);
                ?>
                    <tr>
                        <th colspan="2" style="font-size: 12px "><?= lang("rounding"); ?></th>
                        <th colspan="2" class="text-right" style="font-size: 12px "><?= $rounding; ?></th>
                    </tr>
                    <tr>
                        <th colspan="2" style="font-size: 12px "><?= lang("grand_total"); ?></th>
                        <th colspan="2" class="text-right" style="font-size: 12px "><?= $this->tec->formatMoney($inv->grand_total + $rounding); ?></th>
                    </tr>
                <?php
                } else {
                    $round_total = $inv->grand_total;
                    ?>
                    <tr>
                        <th colspan="2" style="font-size: 12px "><?= lang("grand_total"); ?></th>
                        <th colspan="2" class="text-right" style="font-size: 12px "><?= $this->tec->formatMoney($inv->grand_total); ?></th>
                    </tr>
                <?php }
                if ($inv->paid < $round_total) { ?>
                    <tr>
                        <th colspan="2" style="font-size: 12px "><?= lang("paid_amount"); ?></th>
                        <th colspan="2" class="text-right" style="font-size: 12px "><?= $this->tec->formatMoney($inv->paid); ?></th>
                    </tr>
                    <tr>
                        <th colspan="2" style="font-size: 12px "><?= lang("due_amount"); ?></th>
                        <th colspan="2"  class="text-right" ><p class="td-color" style="font-size: 12px"><?= $this->tec->formatMoney($inv->grand_total - $inv->paid); ?></th>
                  </tr>
                <?php } ?>
                </tfoot>
            </table>
            <?php
            if ($payments) {
                echo '<table class="table table-striped table-condensed"  style="text-align: left; font-size: 12px"><tbody>';
                foreach ($payments as $payment) {
                    echo '<tr>';
                    if ($payment->paid_by == 'cash' && $payment->pos_paid) {
                        echo '<td>' . lang("paid_by") . ': ' . lang($payment->paid_by) . '</td>';
                        echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid) . '</td>';
                        echo '<td>' . lang("change") . ': ' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0) . '</td>';
                    }
                    if ($payment->paid_by == 'CC'  && $payment->pos_paid) {
                        echo '<td>' . lang("paid_by") . ': ' . Multicaixa . '</td>';
                        echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid) . '</td>';
						 echo '<td>' . lang("change") . ': ' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0) . '</td>';
                         
                    }
                    if ($payment->paid_by == 'Cheque' && $payment->cheque_no) {
                        echo '<td>' . lang("paid_by") . ': ' . lang($payment->paid_by) . '</td>';
                        echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                        echo '<td>' . lang("cheque_no") . ': ' . $payment->cheque_no . '</td>';
                    }
                    if ($payment->paid_by == 'gift_card' && $payment->pos_paid) {
                        echo '<td>' . lang("paid_by") . ': ' . lang($payment->paid_by) . '</td>';
                        echo '<td>' . lang("no") . ': ' . $payment->gc_no . '</td>';
                        echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid) . '</td>';
                        echo '<td>' . lang("balance") . ': ' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0) . '</td>';
                    }
                    if ($payment->paid_by == 'other' && $payment->amount) {
                        echo '<td>' . lang("paid_by") . ': ' . lang($payment->paid_by) . '</td>';
                        echo '<td>' . lang("amount") . ': ' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid) . '</td>';
                        echo $payment->note ? '</tr><td colspan="2">' . lang("payment_note") . ': ' . $payment->note . '</td>' : '';
                    }
                    echo '</tr>';
                }
                echo '</tbody></table>';
                
               
            }

            ?>
	<table width="100%">
                            <tr valign="top" style="border-bottom: 1px solid black; background-color: #e4e3e3 !important;">
                                <td colspan="5" style="text-align: left; font-size: 9px;">
                                    <?php echo lang("tax_summary"); ?>
                                </td>
                            </tr>
                            <tr>
                                <td width="8%" style="text-transform: uppercase; font-size: 9px;">
                                   <?= lang("rate"); ?>
                                </td>
                                <td width="15%" style="text-transform: uppercase; font-size: 9px">
                                   <?= lang("incidence"); ?>
                                </td>
                                <td width="20%" style="text-transform: uppercase; font-size: 9px">
                                   <?= lang("Monta. do impo."); ?>  
                                </td>
                                <td width="8%" align="center" style="text-transform: uppercase; font-size: 9px">
                                   <?= lang("tax_code"); ?>
                                </td>
                                <td width="49%" align="right" style="text-transform: uppercase; font-size: 9px">
                                    <?= lang("tax_reason"); ?>
                                </td>
                            </tr>
                            <?php
                               $this->db->order_by('tax_id', 'asc');
                                $sale_items = get_rows("tec_sale_items",array("sale_id"=>$inv->id));
                                $no = 0;
                                $tax_id = "";
                                foreach ($sale_items as $key => $sale_item) {
                                    $product_info = get_row("tec_products",array("id"=>$sale_item['product_id']));
                                    if($product_info['tax_id']*1 == 0) continue;
                                    // if($no>1) continue;
                                    $no++;
                                    if($tax_id == $sale_item['tax_id']) continue;
                                    $tax_info = get_row("tec_tax",array("id"=>$product_info['tax_id']));
                                    echo "<tr>";
                                    echo '<td style="font-size:9px; ">'.$tax_info['tax'].'(%)</td>';
                                    if($tax_info['tax_code'] == "NOR")
                                    echo '<td style="font-size:9px; ">'.$this->tec->formatMoney($sale_item->real_unit_price).'</td>';
                                    elseif($tax_info['tax_code'] == "OUT")
                                    echo '<td style="font-size:9px; ">'.$this->tec->formatMoney($sale_item->real_unit_price).'</td>';
                                    else echo "<td></td>"; 
                                         if($tax_info['tax_type'] == "IVA")
                                         echo '<td style="font-size:9px; ">'.$this->tec->formatMoney($inv->product_tax).'</td>';
                                         else
                                         echo "<td></td>"; 
                                  
                                    echo '<td style="font-size:9px; ">'.$tax_info['tax_code'].'<span class="print-color-black"> ('.$sale_item['tax_id'].') </span></td>';
                                    if($tax_info['tax_code'] == "ISE")
                                        echo '<td style="font-size:9px; " align="right">'.$tax_info['reason'].'</td>';
                                    else echo "<td></td>"; 

                                    echo "</tr>";
                                    $tax_id = $sale_item['tax_id'];
                                }
                            ?>
                        </table>
		
		 <p style="text-align: center;font-size: 10px;padding-bottom: 10px;">
			 <br> Regime IVA: <?= $Settings->regime; ?></br>
                            <?php
                                $hash_str = $inv->Hash;
                            ?>
                        <?php echo substr($hash_str, 0,1).substr($hash_str, 10,1).substr($hash_str, 20,1).substr($hash_str, 30,1) ; ?>-Processado por programa validado <span style="text-align: left;font-size: 12px;padding-bottom: 10px;"> nº FE/27/AGT/2025 SIF-POS</span>
                        <br > <b style="font-size: 9px " >Os bens/serviços foram colocados a disposição/prestados do/ao adquirente na data e local constante em cada factura.</b></p> 
            <?php echo '<b style="font-size: 12px " class="text-right">Operador:</b>'; ?> <?= $this->session->userdata('username'); ?>
          <!--   <?= $inv->note ? '<p class="text-center">' . $this->tec->decode_html($inv->note) . '</p>' : ''; ?> -->
            <div class="well well-sm" style="font-size: 12px ">
                <?= $Settings->header; ?>
          </div>
         <div style="text-align:center; margin: 12px 0;">
    <!-- QR Code AGT (350x350 + logo oficial) -->
<div style="text-align:center; margin: 12px 0;">
    <canvas id="qrcode_canvas" width="250" height="250" style="width:150px;height:150px;"></canvas>
    
</div>

<!-- gerador temporário (não aparece) -->
<div id="qrcode_tmp" style="display:none;"></div>

</div>

<?php if ($modal) {
    echo '</div></div></div></div>';
} else { ?>
<div id="buttons" style="padding-top:10px; text-transform:uppercase;" class="no-print">
    <hr>
    <?php if ($message) { ?>
    <div class="alert alert-success">
        <button data-dismiss="alert" class="close" type="button">×</button>
        <?= is_array($message) ? print_r($message, true) : $message; ?>
    </div>
<?php } ?>

    <?php if ($Settings->java_applet) { ?>
        <span class="col-xs-12"><a class="btn btn-block btn-primary" onClick="printReceipt()"><?= lang("print"); ?></a></span>
        <span class="col-xs-12"><a class="btn btn-block btn-info" type="button" onClick="openCashDrawer()"><?= lang('open_cash_drawer'); ?></a></span>
        <div style="clear:both;"></div>
    <?php } else { ?>
        <span class="pull-right col-xs-12">
        <a href="javascript:window.print()" id="web_print" class="btn btn-block btn-primary"
           onClick="window.print();return false;"><?= lang("web_print"); ?></a>
    </span>
    <?php } ?>
    <span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a></span>

    <span class="col-xs-12">
        <a class="btn btn-block btn-warning" href="<?= site_url('pos'); ?>"><?= lang("back_to_pos"); ?></a>
    </span>
    <?php if (!$Settings->java_applet) { ?>
        <div style="clear:both;"></div>
        <font>
    <?php } ?>
    <div style="clear:both;"></div>

</div>

</div>
<canvas id="hidden_screenshot" style="display:none;">

</canvas>
<div class="canvas_con" style="display:none;"></div>
<script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
<?php if ($Settings->java_applet) {

        function drawLine($Settings)
        {
            $size = $Settings->char_per_line;
            $new = '';
            for ($i = 1; $i < $size; $i++) {
                $new .= '-';
            }
            $new .= ' ';
            return $new;
        }

        function printLine($str, $Settings, $sep = ":", $space = NULL)
        {
            $size = $space ? $space : $Settings->char_per_line;
            $lenght = strlen($str);
            list($first, $second) = explode(":", $str, 2);
            $new = $first . ($sep == ":" ? $sep : '');
            for ($i = 1; $i < ($size - $lenght); $i++) {
                $new .= ' ';
            }
            $new .= ($sep != ":" ? $sep : '') . $second;
            return $new;
        }

        function printText($text, $Settings)
        {
            $size = $Settings->char_per_line;
            $new = wordwrap($text, $size, "\\n");
            return $new;
        }

        function taxLine($name, $code, $qty, $amt, $tax)
        {
            return printLine(printLine(printLine(printLine($name . ':' . $code, '', 18) . ':' . $qty, '', 25) . ':' . $amt, '', 35) . ':' . $tax, ' ');
        }

        ?>

        <script type="text/javascript" src="<?= $assets ?>plugins/qz/js/deployJava.js"></script>
        <script type="text/javascript" src="<?= $assets ?>plugins/qz/qz-functions.js"></script>
        <script type="text/javascript">
            deployQZ('themes/<?=$Settings->theme?>/assets/plugins/qz/qz-print.jar', '<?= $assets ?>plugins/qz/qz-print_jnlp.jnlp');
            usePrinter("<?= $Settings->receipt_printer; ?>");
            <?php /*$image = $this->tec->save_barcode($inv->reference_no);*/ ?>
            function printReceipt() {
                //var barcode = 'data:image/png;base64,<?php /*echo $image;*/ ?>';
                receipt = "";
                receipt += chr(27) + chr(69) + "\r" + chr(27) + "\x61" + "\x31\r";
                receipt += "<?= printText(strip_tags(preg_replace('/\s+/',' ', $Settings->header)), $Settings); ?>" + "\n";
                receipt += " \x1B\x45\x0A\r ";
                receipt += "<?=drawLine($Settings);?>\r\n";
                //receipt += "<?php // if($Settings->invoice_view == 1) { echo lang('tax_invoice'); } ?>\r\n";
                //receipt += "<?php // if($Settings->invoice_view == 1) { echo drawLine(); } ?>\r\n";
                receipt += "\x1B\x61\x30";
                receipt += "<?= printLine(lang("sale_no") . ": " . $inv->id, $Settings) ?>" + "\n";
                receipt += "<?= printLine(lang("sales_person") . ": " . $created_by->first_name." ".$created_by->last_name, $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("customer") . ": " . $inv->customer_name, $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("date") . ": " . $this->tec->hrld($inv->date), $Settings); ?>" + "\n\n";
                receipt += "<?php $r = 1;
            foreach ($rows as $row): ?>";
                receipt += "<?= "#" . $r ." "; ?>";
                receipt += "<?= product_name(addslashes($row->product_name)); ?>" + "\n";
                receipt += "<?= printLine($this->tec->formatNumber($row->quantity)."x".$this->tec->formatMoney($row->net_unit_price+($row->item_tax/$row->quantity)) . ":  ". $this->tec->formatMoney($row->subtotal), $Settings, ' ') . ""; ?>" + "\n";
                receipt += "<?php $r++;
            endforeach; ?>";
                receipt += "\x1B\x61\x31";
                receipt += "<?=drawLine($Settings);?>\r\n";
                receipt += "\x1B\x61\x30";
                receipt += "<?= printLine(lang("total") . ": " . $this->tec->formatMoney($inv->total+$inv->product_tax), $Settings); ?>" + "\n";
                <?php if ($inv->order_tax != 0) { ?>
                receipt += "<?= printLine(lang("tax") . ": " . $this->tec->formatMoney($inv->order_tax), $Settings); ?>" + "\n";
                <?php } ?>
                <?php if ($inv->total_discount != 0) { ?>
                receipt += "<?= printLine(lang("discount") . ": " . $this->tec->formatMoney($inv->total_discount), $Settings); ?>" + "\n";
                <?php } ?>
                <?php if($Settings->rounding) { ?>
                receipt += "<?= printLine(lang("rounding") . ": " . $rounding, $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("grand_total") . ": " . $this->tec->formatMoney($inv->grand_total + $rounding), $Settings); ?>" + "\n";
                <?php } else { ?>
                receipt += "<?= printLine(lang("grand_total") . ": " . $this->tec->formatMoney($inv->grand_total), $Settings); ?>" + "\n";
                <?php } ?>
                <?php if($inv->paid < $inv->grand_total) { ?>
                receipt += "<?= printLine(lang("paid_amount") . ": " . $this->tec->formatMoney($inv->paid), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("due_amount") . ": " . $this->tec->formatMoney($inv->grand_total-$inv->paid), $Settings); ?>" + "\n\n";
                <?php } ?>
                <?php
                if($payments) {
                    foreach($payments as $payment) {
                        if ($payment->paid_by == 'cash' && $payment->pos_paid) { ?>
                receipt += "<?= printLine(lang("paid_by") . ": " . lang($payment->paid_by), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("amount") . ": " . $this->tec->formatMoney($payment->pos_paid), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("change") . ": " . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : 0), $Settings); ?>" + "\n";
                <?php } if (($payment->paid_by == 'CC' || $payment->paid_by == 'ppp' || $payment->paid_by == 'stripe') && $payment->cc_no) { ?>
                receipt += "<?= printLine(lang("paid_by") . ": " . lang($payment->paid_by), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("amount") . ": " . $this->tec->formatMoney($payment->pos_paid), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("card_no") . ": xxxx xxxx xxxx " . substr($payment->cc_no, -4), $Settings); ?>" + "\n";
                <?php  } if ($payment->paid_by == 'gift_card') { ?>
                receipt += "<?= printLine(lang("paid_by") . ": " . lang($payment->paid_by), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("amount") . ": " . $this->tec->formatMoney($payment->pos_paid), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("card_no") . ": " . $payment->gc_no, $Settings); ?>" + "\n";
                <?php } if ($payment->paid_by == 'Cheque' && $payment->cheque_no) { ?>
                receipt += "<?= printLine(lang("paid_by") . ": " . lang($payment->paid_by), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("amount") . ": " . $this->tec->formatMoney($payment->pos_paid), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("cheque_no") . ": " . $payment->cheque_no, $Settings); ?>" + "\n";
                <?php if ($payment->paid_by == 'other' && $payment->amount) { ?>
                receipt += "<?= printLine(lang("paid_by") . ": " . lang($payment->paid_by), $Settings); ?>" + "\n";
                receipt += "<?= printLine(lang("amount") . ": " . $this->tec->formatMoney($payment->amount), $Settings); ?>" + "\n";
                receipt += "<?= printText(lang("payment_note") . ": " . $payment->note, $Settings); ?>" + "\n";
                <?php }
            }

        }
    }

    /* if($Settings->invoice_view == 1) {
        if(!empty($tax_summary)) {
    ?>
                receipt += "\n" + "<?= lang('tax_summary'); ?>" + "\n";
                receipt += "<?= taxLine(lang('name'),lang('code'),lang('qty'),lang('tax_excl'),lang('tax_amt')); ?>" + "\n";
                receipt += "<?php foreach ($tax_summary as $summary): ?>";
                receipt += "<?= taxLine($summary['name'],$summary['code'],$this->tec->formatNumber($summary['items']),$this->tec->formatMoney($summary['amt']),$this->tec->formatMoney($summary['tax'])); ?>" + "\n";
                receipt += "<?php endforeach; ?>";
                receipt += "<?= printLine(lang("total_tax_amount") . ":" . $this->tec->formatMoney($inv->product_tax)); ?>" + "\n";
                <?php
                    }
                } */
                ?>
                receipt += "\x1B\x61\x31";
                <?php if ($inv->note) { ?>
                receipt += "<?= printText(strip_tags(preg_replace('/\s+/',' ', $this->tec->decode_html($inv->note))), $Settings); ?>" + "\n";
                <?php } ?>
                receipt += "<?= printText(strip_tags(preg_replace('/\s+/',' ', $Settings->footer)), $Settings); ?>" + "\n";
                receipt += "\x1B\x61\x30";
                <?php if(isset($Settings->cash_drawer_cose)) { ?>
                print(receipt, '', '<?=$Settings->cash_drawer_cose;?>');
                <?php } else { ?>
                print(receipt, '', '');
                <?php } ?>

            }

        </script>
    <?php } ?>
            <script type="text/javascript">
                $(document).ready(function () {
                    $('#email').click(function () {
                        var email = prompt("<?= lang("email_address"); ?>", "<?= $customer->email; ?>");
                        if (email != null) {
                            $.ajax({
                                type: "post",
                                url: "<?= site_url('pos/email_receipt') ?>",
                                data: {<?= $this->security->get_csrf_token_name(); ?>: "<?= $this->security->get_csrf_hash(); ?>", email: email, id: <?= $inv->id; ?>},
                                dataType: "json",
                                success: function (data) {
                                    alert(data.msg);
                                },
                                error: function () {
                                    alert('<?= lang('ajax_request_failed'); ?>');
                                    return false;
                                }
                            });
                        }
                        return false;
                    });
                });
        <?php if (!$Settings->java_applet && !$noprint) { ?>
        $(window).load(function () {
            window.print();
        });
    <?php } ?>
            </script>

<script src="https://cdn.jsdelivr.net/gh/davidshimjs/qrcodejs/qrcode.min.js"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    var tmp = document.getElementById("qrcode_tmp");
    var canvasOut = document.getElementById("qrcode_canvas");
    if (!tmp || !canvasOut || typeof QRCode === "undefined") return;

    // 1) Dados (conforme AGT)
    var emissor = "<?= trim($Settings->TaxRegistrationNumber); ?>";
    var documentNo = "<?= trim($inv->InvoiceNo); ?>";

    // Regra AGT: só espaços -> %20 (não mexer em /)
    documentNo = documentNo.replace(/ /g, "%20");

    // URL oficial AGT (produção) conforme manual
    var url = "https://quiosqueagt.minfin.gov.ao/facturacao-electronica/consultar-fe"
            + "?emissor=" + emissor
            + "&document=" + documentNo;

    // 2) Gerar QR (temporário)
    tmp.innerHTML = "";
    new QRCode(tmp, {
        text: url,
        width: 250,
        height: 250,
        correctLevel: QRCode.CorrectLevel.M // M (15%) conforme manual
    });

    // 3) Pegar o QR gerado (img/canvas) e desenhar num canvas 350x350
    var ctx = canvasOut.getContext("2d");
    ctx.clearRect(0, 0, 250, 250);

    // O qrcodejs pode criar <img> ou <canvas>
    var qrImg = tmp.querySelector("img");
    var qrCan = tmp.querySelector("canvas");

    function drawQR(baseImg) {
        ctx.drawImage(baseImg, 0, 0, 250, 250);

        // 4) Logo oficial AGT (do manual)
        var logo = new Image();
        logo.crossOrigin = "anonymous";
        logo.onload = function () {

            // Limite: logo < 20% (vamos limitar a 70x70)
            var maxW = 70, maxH = 70;

            // manter proporção
            var w = logo.width, h = logo.height;
            var scale = Math.min(maxW / w, maxH / h);
            var lw = Math.round(w * scale);
            var lh = Math.round(h * scale);

            var x = Math.round((250 - lw) / 2);
            var y = Math.round((250 - lh) / 2);

            // fundo branco (para leitura do QR)
            var pad = 10;
            ctx.fillStyle = "#FFFFFF";
            ctx.fillRect(x - pad, y - pad, lw + pad*2, lh + pad*2);

            // desenhar logo
            ctx.drawImage(logo, x, y, lw, lh);
        };

        // Link do logo oficial (manual AGT)
        logo.src="<?= $assets ?>images/header/logo_agt.png"
    }

    if (qrCan) {
        // já é canvas
        drawQR(qrCan);
    } else if (qrImg) {
        // é imagem
        var base = new Image();
        base.onload = function () { drawQR(base); };
        base.src = qrImg.src;
    }

});
</script>



</body>
</table >
</html>
<?php } ?>
