<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('enter_info'); ?></h3>
                </div>
                <div class="box-body">
                    <?php echo form_open("customers/add");?>

                    <!-- NIF -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="cf1"><?= $this->lang->line("NIF"); ?></label>
                            <?= form_input(
                                'cf1',
                                set_value('cf1'),
                                'class="form-control input-sm" id="cf1" required="required"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Nome -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="name"><?= $this->lang->line("name"); ?></label>
                            <?= form_input(
                                'name',
                                set_value('name'),
                                'class="form-control input-sm" id="name"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="email"><?= $this->lang->line("email"); ?></label>
                            <?= form_input(
                                'email',
                                set_value('email'),
                                'class="form-control input-sm" id="email"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Telefone -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="phone"><?= $this->lang->line("phone"); ?></label>
                            <?= form_input(
                                'phone',
                                set_value('phone'),
                                'class="form-control input-sm" id="phone"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Endereço / Bairro (AddressDetail) -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="bairro"><?= $this->lang->line("AddressDetail"); ?></label>
                            <?= form_input(
                                'bairro',
                                set_value('bairro'),
                                'class="form-control input-sm" id="bairro" required="required"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Número (BuildingNumber) -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="numero">CAE</label>
                            <?= form_input(
                                'numero',
                                set_value('numero'),
                                'class="form-control input-sm" id="numero"'
                            ); ?>
                        </div>
                    </div>

                    <!-- País -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="Country"><?= $this->lang->line("País"); ?></label>
                            <?= form_input(
                                'Country',
                                set_value('Country', 'Angola'),
                                'class="form-control input-sm" id="Country"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Município (cidade) -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="cidade"><?= $this->lang->line("City"); ?></label>
                            <?= form_input(
                                'cidade',
                                set_value('cidade'),
                                'class="form-control input-sm" id="cidade" required="required"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Província (estado) -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="estado"><?= $this->lang->line("Province"); ?></label>
                            <?= form_input(
                                'estado',
                                set_value('estado'),
                                'class="form-control input-sm" id="estado" required="required"'
                            ); ?>
                        </div>
                    </div>

                  

                    <?php
                        // Opções SIM/NÃO
                        $optsSN = ['1' => 'SIM', '2' => 'NÃO'];

                        // Valor seleccionado para Retenção na Fonte
                        $selected_ret = set_value(
                            'ret',
                            isset($settings->ret) && $settings->ret !== '' ? (string) $settings->ret :
                            (isset($settings->regime) && $settings->regime !== '' ? (string) $settings->regime : '2')
                        );

                        // Valor seleccionado para IVA cativo
                        $selected_iva = set_value(
                            'iva',
                            isset($settings->iva) && $settings->iva !== '' ? (string) $settings->iva :
                            (isset($settings->regime) && $settings->regime !== '' ? (string) $settings->regime : '2')
                        );
                    ?>

                    <!-- Retenção na Fonte / IVA cativo -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="ret">Retenção na Fonte?</label>
                            <?= form_dropdown(
                                'ret',
                                $optsSN,
                                $selected_ret,
                                'class="form-control select2" id="ret" style="width:100%;" required="required"'
                            ); ?>
                        </div>

                        <div class="form-group">
                            <label class="control-label" for="iva">IVA cativo?</label>
                            <?= form_dropdown(
                                'iva',
                                $optsSN,
                                $selected_iva,
                                'class="form-control select2" id="iva" style="width:100%;" required="required"'
                            ); ?>
                        </div>
                    </div>

                    <!-- Botão submit -->
                    <div class="col-xs-6">
                        <div class="form-group">
                            <?php
                                echo form_submit(
                                    'add_customer',
                                    $this->lang->line("add_customer"),
                                    'class="btn btn-primary"'
                                );
                            ?>
                        </div>
                    </div>

                    <?php echo form_close();?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Toast plugin -->
<link rel="stylesheet" href="<?= $assets ?>plugins/jquery-toast-plugin-master/src/jquery.toast.css">
<script src="<?= $assets ?>plugins/jquery-toast-plugin-master/src/jquery.toast.js"></script>


<script>
/**
 * Auto-preenchimento de Cliente a partir do NIF (consulta AGT / MinFin)
 * Usa o endpoint: /api/consultar-nif/{nif}
 */
(function($){
    var ENDPOINT = '<?= site_url("api/consultar-nif") ?>';
    var DEBUG    = true;
    var isConsultingNif = false; // evita chamadas duplicadas

    function log() {
        if (DEBUG && window.console && console.log) {
            console.log.apply(console, ['[NIF-AutoFill]'].concat([].slice.call(arguments)));
        }
    }

    function showToast(msg, icon) {
        icon = icon || 'info';
        if ($.toast) {
            $.toast({
                text: msg,
                icon: icon,
                position: 'top-right',
                hideAfter: 4000,
                loader: false
            });
        } else if (window.bootbox) {
            bootbox.alert(msg);
        } else {
            alert(msg);
        }
    }

    // AGORA: não removemos letras nem o sufixo, só tiramos espaços
    function normalizarDocumento(str) {
        return String(str || '').trim();
    }

    function validEmail(email) {
        return /.+@.+\..+/.test(String(email || ''));
    }

    function setVal(selector, value) {
        if (value === undefined || value === null || value === '') return;
        var $el = $(selector);
        if ($el.length) {
            $el.val(value);
        }
    }

    function toggleSubmit(disabled) {
        $('input[name="add_customer"], input[type=submit], button[type=submit]')
            .prop('disabled', !!disabled);
    }

    function fillCustomer(data) {
        setVal('#name',           data.name    || data.company || $('#name').val());
        setVal('#email',          data.email   || $('#email').val());
        setVal('#phone',          data.phone   || $('#phone').val());
        setVal('#bairro',         data.address || $('#bairro').val());
        setVal('#cidade',         data.city    || $('#cidade').val());
        setVal('#estado',         data.state   || $('#estado').val());
        setVal('#Country',        data.country || $('#Country').val() || 'Angola');
        setVal('#numero',         data.cae     || $('#numero').val());

        // Se vier número de prédio na resposta (se adicionares no PHP)
        if (data.number) {
            setVal('#numero', data.number);
        }

        log('Campos preenchidos a partir do NIF', data);
    }

    function consultarNif() {
        var nif = normalizarDocumento($('#cf1').val());

        if (!nif || nif.length < 9) {
            return;
        }

        // evita chamadas duplicadas
        if (isConsultingNif) {
            log('Consulta de NIF ignorada porque já existe outra em curso.');
            return;
        }

        // Consumidor final
        if (nif === '999999999') {
            fillCustomer({
                name: 'Consumidor Final',
                company: 'Consumidor Final',
                country: 'Angola'
            });
            return;
        }

        var url = ENDPOINT + '/' + encodeURIComponent(nif);
        log('GET', url);

        isConsultingNif = true;
        toggleSubmit(true);
        showToast('A consultar NIF na AGT...', 'info');

        $.getJSON(url)
            .done(function (resp) {
                    if (resp && resp.success) {
                        // API retorna dados em resp.data — prefira isso quando disponível
                        fillCustomer(resp.data || resp);
                        showToast('Dados do contribuinte carregados com sucesso.', 'success');
                    } else {
                    var msg = (resp && resp.message)
                        ? resp.message
                        : 'Contribuinte não encontrado na AGT.';
                    showToast(msg, 'warning');
                }
            })
            .fail(function (jqXHR, textStatus) {
                log('Erro na chamada AJAX', textStatus, jqXHR);
                showToast('Falha ao consultar NIF (rede ou API).', 'error');
            })
            .always(function () {
                isConsultingNif = false;
                toggleSubmit(false);
            });
    }

    // CHAMAR APENAS COM blur (não usar blur + change)
    $(document).on('blur', '#cf1', function () {
        consultarNif();
    });

    // Opcional: consulta logo ao abrir a página se já houver NIF preenchido (ex.: edição)
    $(function () {
        var nifInicial = normalizarDocumento($('#cf1').val());
        if (nifInicial.length >= 9) {
            consultarNif();
        }
    });

    // Validação simples do e-mail na submissão
    $('form').on('submit', function (ev) {
        var email = $('#email').val();
        if (email && !validEmail(email)) {
            ev.preventDefault();
            showToast('E-mail inválido. Por favor verifique.', 'warning');
        }
    });

})(jQuery);

// Inicialização Select2 (se o plugin estiver carregado globalmente)
jQuery(function($){
    if ($.fn.select2) {
        $('#ret, #iva').select2({ width: '100%' });
    }
});
</script>
