<!DOCTYPE html>
<html>
<head>
    <title>Inicializar Séries AGT</title>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; }
        .btn { padding: 12px 24px; background: #3498db; color: white; border: none; cursor: pointer; border-radius: 5px; }
        .success { background: #27ae60; color: white; padding: 15px; margin: 15px 0; border-radius: 5px; }
        .error { background: #e74c3c; color: white; padding: 15px; margin: 15px 0; border-radius: 5px; }
        pre { background: #2c3e50; color: #00ff00; padding: 15px; border-radius: 5px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Inicializar Colunas de Séries AGT</h1>
        
        <?php
        // Ler configuração da base de dados do ficheiro config
        require_once __DIR__ . '/app/config/database.php';
        
        $host = DB_HOST;
        $user = DB_USER;
        $pass = DB_PASS;
        $db = DB_NAME;

        $conn = new mysqli($host, $user, $pass, $db);

        if ($conn->connect_error) {
            die("<div class='error'>Erro de conexão: " . $conn->connect_error . "</div>");
        }

        $series_columns = [
            'FT-seriesCode' => 'VARCHAR(50) DEFAULT NULL COMMENT "Série para Facturas"',
            'FR-seriesCode' => 'VARCHAR(50) DEFAULT NULL COMMENT "Série para Facturas Recibo"',
            'GF-seriesCode' => 'VARCHAR(50) DEFAULT NULL COMMENT "Série para Guias de Transporte"',
            'NC-seriesCode' => 'VARCHAR(50) DEFAULT NULL COMMENT "Série para Notas de Crédito"',
            'RC-seriesCode' => 'VARCHAR(50) DEFAULT NULL COMMENT "Série para Recibos"'
        ];

        echo "<h2>Verificando e Adicionando Colunas...</h2>";

        $added = 0;
        $existed = 0;

        foreach ($series_columns as $col_name => $col_definition) {
            // Verificar se a coluna existe
            $check_sql = "SHOW COLUMNS FROM `tec_settings` LIKE '" . $conn->real_escape_string($col_name) . "'";
            $result = $conn->query($check_sql);

            if ($result && $result->num_rows > 0) {
                echo "<p>✅ Coluna <code>{$col_name}</code> já existe</p>";
                $existed++;
            } else {
                // Adicionar a coluna
                $add_sql = "ALTER TABLE `tec_settings` ADD COLUMN `{$col_name}` {$col_definition}";
                
                if ($conn->query($add_sql)) {
                    echo "<p style='color:green;'>✅ Coluna <code>{$col_name}</code> adicionada com sucesso!</p>";
                    $added++;
                } else {
                    echo "<p style='color:red;'>❌ Erro ao adicionar <code>{$col_name}</code>: " . $conn->error . "</p>";
                }
            }
        }

        echo "<div class='success'>";
        echo "<strong>Resumo:</strong><br>";
        echo "✅ {$existed} coluna(s) já existiam<br>";
        echo "➕ {$added} coluna(s) adicionadas<br>";
        echo "</div>";

        // Verificar estado actual
        echo "<h2>Estado Actual na Base de Dados:</h2>";
        
        $sql = "SELECT 
            `FT-seriesCode`,
            `FR-seriesCode`,
            `GF-seriesCode`,
            `NC-seriesCode`,
            `RC-seriesCode`,
            TaxRegistrationNumber
        FROM tec_settings 
        LIMIT 1";

        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            
            echo "<table border='1' cellpadding='10' style='width:100%; border-collapse: collapse;'>";
            echo "<tr style='background:#3498db; color:white;'><th>Campo</th><th>Valor</th></tr>";
            
            foreach (array_keys($series_columns) as $col) {
                $value = isset($row[$col]) && $row[$col] !== null ? $row[$col] : '(vazio/NULL)';
                $style = ($value === '(vazio/NULL)') ? 'color:#e74c3c;' : 'color:#27ae60;';
                
                echo "<tr>";
                echo "<td><strong>{$col}</strong></td>";
                echo "<td style='{$style}'>{$value}</td>";
                echo "</tr>";
            }
            
            echo "</table>";
            
            echo "<p><strong>NIF:</strong> {$row['TaxRegistrationNumber']}</p>";
            
            $all_empty = true;
            foreach (array_keys($series_columns) as $col) {
                if (isset($row[$col]) && $row[$col] !== null && $row[$col] !== '') {
                    $all_empty = false;
                    break;
                }
            }
            
            if ($all_empty) {
                echo "<div class='success'>";
                echo "<h3>✅ Pronto para Configurar!</h3>";
                echo "<p>As colunas estão vazias e prontas para receber as séries da AGT.</p>";
                echo "<p><strong>Próximo passo:</strong></p>";
                echo "<ol>";
                echo "<li>Vá para <a href='/wpv_modelo/settings'>Settings</a></li>";
                echo "<li>Clique no botão <strong>'Consultar Séries (AGT) e Guardar'</strong></li>";
                echo "<li>Aguarde alguns segundos</li>";
                echo "<li>As séries serão preenchidas automaticamente</li>";
                echo "</ol>";
                echo "<a href='/wpv_modelo/settings' class='btn'>Ir para Settings Agora</a>";
                echo "</div>";
            } else {
                echo "<div class='success'>";
                echo "<h3>✅ Séries Já Configuradas!</h3>";
                echo "<p>Algumas séries já têm valores. Você pode editá-las directamente na página de Settings se necessário.</p>";
                echo "<a href='/wpv_modelo/settings' class='btn'>Ir para Settings</a>";
                echo "</div>";
            }
            
        } else {
            echo "<div class='error'>❌ Nenhum registo encontrado em tec_settings!</div>";
        }

        $conn->close();
        ?>
        
        <hr>
        <p style="text-align:center; margin-top:30px;">
            <a href="/wpv_modelo/diagnostico_series.php" class="btn">Ver Diagnóstico Completo</a>
        </p>
    </div>
</body>
</html>
