<?php
/**
 * Script para corrigir o NIF na base de dados
 * Execute: php fix_nif_database.php
 */

// Configuração da base de dados
$host = 'localhost';
$user = 'root';
$pass = '';
$db = 'wpv_modelo';  // Altere se necessário

$nif_antigo = '5484026601';
$nif_correto = '5001441337';

echo "==================================================\n";
echo "  Correção de NIF na Base de Dados\n";
echo "==================================================\n\n";

try {
    // Conectar à base de dados
    $conn = new mysqli($host, $user, $pass, $db);
    
    if ($conn->connect_error) {
        die("✗ Erro de conexão: " . $conn->connect_error . "\n");
    }
    
    echo "✓ Conectado à base de dados: $db\n\n";
    
    // Verificar NIF atual
    echo "Verificando NIF atual...\n";
    $result = $conn->query("SELECT TaxRegistrationNumber, CompanyName FROM tec_settings LIMIT 1");
    
    if ($result && $row = $result->fetch_assoc()) {
        echo "  NIF atual: " . $row['TaxRegistrationNumber'] . "\n";
        echo "  Empresa: " . $row['CompanyName'] . "\n\n";
        
        if ($row['TaxRegistrationNumber'] == $nif_antigo) {
            echo "Atualizando para NIF correto: $nif_correto\n";
            
            $stmt = $conn->prepare("UPDATE tec_settings SET TaxRegistrationNumber = ? WHERE TaxRegistrationNumber = ?");
            $stmt->bind_param("ss", $nif_correto, $nif_antigo);
            
            if ($stmt->execute()) {
                echo "✓ NIF atualizado com sucesso!\n\n";
                
                // Verificar atualização
                $result2 = $conn->query("SELECT TaxRegistrationNumber FROM tec_settings LIMIT 1");
                if ($result2 && $row2 = $result2->fetch_assoc()) {
                    echo "Novo NIF: " . $row2['TaxRegistrationNumber'] . "\n";
                }
            } else {
                echo "✗ Erro ao atualizar: " . $stmt->error . "\n";
            }
            
            $stmt->close();
        } else if ($row['TaxRegistrationNumber'] == $nif_correto) {
            echo "✓ NIF já está correto! Nenhuma alteração necessária.\n";
        } else {
            echo "⚠ NIF diferente do esperado: " . $row['TaxRegistrationNumber'] . "\n";
            echo "  Esperado: $nif_antigo ou $nif_correto\n";
        }
    } else {
        echo "✗ Nenhum registro encontrado em tec_settings\n";
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "✗ Erro: " . $e->getMessage() . "\n";
}

echo "\n==================================================\n";
echo "IMPORTANTE: Após corrigir o NIF, faça logout e\n";
echo "login novamente para testar a verificação.\n";
echo "==================================================\n";
