<?php
/**
 * Script para verificar o estado das séries AGT na base de dados
 */

// Ler configuração da base de dados do ficheiro config
require_once __DIR__ . '/app/config/database.php';

$host = DB_HOST;
$user = DB_USER;
$pass = DB_PASS;
$db = DB_NAME;

// Conectar
$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

echo "<h2>Estado das Séries AGT em tec_settings</h2>";

// Consultar campos de séries
$sql = "SELECT 
    `FT-seriesCode`,
    `FR-seriesCode`,
    `GF-seriesCode`,
    `NC-seriesCode`,
    `RC-seriesCode`,
    TaxRegistrationNumber,
    licence
FROM tec_settings 
LIMIT 1";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Valor</th><th>Estado</th></tr>";
    
    $series = [
        'FT-seriesCode' => 'Factura',
        'FR-seriesCode' => 'Factura Recibo',
        'GF-seriesCode' => 'Guia de Transporte',
        'NC-seriesCode' => 'Nota de Crédito',
        'RC-seriesCode' => 'Recibo'
    ];
    
    foreach ($series as $field => $label) {
        $value = isset($row[$field]) ? $row[$field] : '';
        $status = empty($value) ? '<span style="color:red;">❌ VAZIO</span>' : '<span style="color:green;">✅ OK</span>';
        
        echo "<tr>";
        echo "<td><strong>{$field}</strong><br><small>{$label}</small></td>";
        echo "<td>" . htmlspecialchars($value) . "</td>";
        echo "<td>{$status}</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<hr>";
    echo "<h3>Informações Adicionais</h3>";
    echo "<p><strong>NIF:</strong> " . htmlspecialchars($row['TaxRegistrationNumber']) . "</p>";
    echo "<p><strong>Licença:</strong> " . htmlspecialchars($row['licence']) . "</p>";
    
} else {
    echo "<p style='color:red;'>Nenhum registo encontrado na tabela tec_settings!</p>";
}

// Verificar se a coluna existe
echo "<hr><h3>Verificar Estrutura da Tabela</h3>";
$sql = "SHOW COLUMNS FROM tec_settings LIKE '%-seriesCode'";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<p style='color:green;'>✅ Colunas de séries encontradas:</p>";
    echo "<ul>";
    while ($col = $result->fetch_assoc()) {
        echo "<li>" . $col['Field'] . " (" . $col['Type'] . ")</li>";
    }
    echo "</ul>";
} else {
    echo "<p style='color:red;'>❌ Nenhuma coluna de séries encontrada! Precisa adicionar as colunas à tabela tec_settings.</p>";
    echo "<p>Execute o seguinte SQL:</p>";
    echo "<pre>";
    echo "ALTER TABLE `tec_settings` 
ADD COLUMN `FT-seriesCode` VARCHAR(50) DEFAULT NULL,
ADD COLUMN `FR-seriesCode` VARCHAR(50) DEFAULT NULL,
ADD COLUMN `GF-seriesCode` VARCHAR(50) DEFAULT NULL,
ADD COLUMN `NC-seriesCode` VARCHAR(50) DEFAULT NULL,
ADD COLUMN `RC-seriesCode` VARCHAR(50) DEFAULT NULL;";
    echo "</pre>";
}

$conn->close();
?>

<style>
body {
    font-family: Arial, sans-serif;
    margin: 20px;
    background: #f5f5f5;
}
table {
    background: white;
    margin: 20px 0;
}
th {
    background: #2c3e50;
    color: white;
    padding: 12px;
}
td {
    padding: 10px;
}
pre {
    background: #2c3e50;
    color: #00ff00;
    padding: 15px;
    border-radius: 5px;
    overflow-x: auto;
}
</style>
