<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports_model extends CI_Model
{


	public function __construct()
	{
		parent::__construct();

	}

	public function getAllProducts()
	{
		$q = $this->db->get('products');
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}

			return $data;
		}
	}

	public function getAllCustomers()
	{
		$q = $this->db->get('customers');
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
	}

	public function topProducts()
	{
		$m = date('Y-m');
		$this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
		->join('products', 'products.id=sale_items.product_id', 'left')
		->join('sales', 'sales.id=sale_items.sale_id', 'left')
		->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
		->group_by('sale_items.product_id')
		->limit(10)
		->like('sales.date', $m, 'both');
		$this->db->where("InvoiceType!=","FP");
		$this->db->where("status =","paid");
		$this->db->where("tec_sales.mesa<>","NC");
		$q = $this->db->get('sale_items');
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
	}
	public function getfilterinvoice($customer, $user, $start_date, $end_date, $products, $invoice_type){
        $this->db->select("tec_sales.id, tec_sales.date, tec_sales.customer_name, tec_sales.InvoiceNo, tec_sales.total, tec_sales.total_tax, tec_sales.total_discount, tec_sales.grand_total, tec_sales.paid, (tec_sales.grand_total-tec_sales.paid) as balance")
				->from('tec_sales');
		$this->db->where("tec_sales.InvoiceStatus!=","A");
		$this->db->where("tec_sales.InvoiceType=","FT");
        if($customer) { $this->db->where('tec_sales.customer_id', $customer); }
        if($user) { $this->db->where_in('tec_sales.created_by', explode(",", $user)); }
        if($start_date) { $this->db->where('tec_sales.date >=', $start_date); }
        if($end_date) { $this->db->where('tec_sales.date <=', $end_date); }
        if($invoice_type) { $this->db->where('tec_sales.InvoiceType', $invoice_type); }
		if($products){
            $this->db->join("tec_sale_items","tec_sale_items.sale_id=tec_sales.id");
            $this->db->where_in('tec_sale_items.product_id', explode(",", $products)); 
        }
        $q = $this->db->get();
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }	
            return $data;	
        }
            return FALSE;
    }
	public function getallproductos($product, $start_date, $end_date)
	{
		$query = "SELECT 
				tec_products.id, 
				tec_products.name, tec_products.code, 
				COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.quantity ELSE tec_sale_items.quantity END), 0) AS sold, 
				ROUND(COALESCE(((SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END)*tec_products.tax)/100), 0), 2) AS tax, 
				COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.quantity*tec_sale_items.cost ELSE tec_sale_items.quantity*tec_sale_items.cost END), 0) AS cost, 
				COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END), 0) AS income,
				ROUND((COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END), 0)) - COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.quantity*tec_sale_items.cost ELSE tec_sale_items.quantity*tec_sale_items.cost END), 0) - COALESCE(((SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END)*tec_products.tax)/100), 0), 2)
						AS profit, tec_products.quantity
				FROM tec_sale_items 
				LEFT JOIN tec_products ON tec_sale_items.product_id = tec_products.id
				LEFT JOIN tec_sales ON tec_sales.id = tec_sale_items.sale_id";
		$where = " where 1 ";
		if($product) { $where.= " and tec_products.id='".$product."'"; }
	        if($start_date) { $where.= " and tec_sales.date>='".$start_date."'"; }
	        if($end_date) { $where.= " and tec_sales.date<='".$end_date."'"; }
		$query = $query.$where." GROUP BY tec_products.id";
		$rows = $this->db->query($query)->result();   
		$return_data = array();
		foreach($rows as $arr){
			$where_condition = " where 1 and tec_purchase_items.product_id=".$arr->id;
			if($start_date) { $where_condition.= " and tec_purchases.date>='".$start_date."'"; }
			if($end_date) { $where_condition.= " and tec_purchases.date<='".$end_date."'"; }

			$sql = "SELECT COALESCE(SUM(tec_purchase_items.quantity),0) AS purchases FROM tec_purchase_items 
			LEFT JOIN tec_purchases ON tec_purchase_items.purchase_id = tec_purchases.id ".$where_condition;
			$row = $this->db->query($sql)->result();   
			$arr->purchases = $row[0]->purchases;
			$return_data[] = $arr;
		}
		return $return_data;

		//  $this->db->select($this->db->dbprefix('products').".name, ".$this->db->dbprefix('products').".code, COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity), 0) as sold, ROUND(COALESCE(((sum(".$this->db->dbprefix('sale_items').".subtotal)*".$this->db->dbprefix('products').".tax)/100), 0), 2) as tax, COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity)*".$this->db->dbprefix('sale_items').".cost, 0) as cost, COALESCE(sum(".$this->db->dbprefix('sale_items').".subtotal), 0) as income,
		// 		ROUND((COALESCE(sum(".$this->db->dbprefix('sale_items').".subtotal), 0)) - COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity)*".$this->db->dbprefix('sale_items').".cost, 0) -COALESCE(((sum(".$this->db->dbprefix('sale_items').".subtotal)*".$this->db->dbprefix('products').".tax)/100), 0), 2)
		// 		as profit", FALSE)
		// 		->join('products', 'sale_items.product_id=products.id', 'left' )
		// 		->join('sales', 'sale_items.sale_id=sales.id', 'left' )
		// 		->group_by('products.id');
		// $this->db->where("InvoiceType!=","FP");
		// $this->db->where("status =","paid");
		// $this->db->where("tec_sales.mesa<>","NC");
		// if($product) { $this->db->where('products.id', $product); }
        // if($start_date) { $this->db->where('date >=', $start_date); }
        // if($end_date) { $this->db->where('date <=', $end_date); }
		// $q = $this->db->get('sale_items');
		// if($q->num_rows() > 0) {
		// 	foreach (($q->result()) as $row) {
		// 		$data[] = $row;
		// 	}
		// 	return $data;
		// }
	}
	public function getallproductos_group_by($product, $start_date, $end_date)
	{
		$query = "SELECT 
				DATE_FORMAT(tec_sales.date, '%Y-%m-%d') AS sale_date, 
				COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.quantity ELSE tec_sale_items.quantity END), 0) AS sold, 
				ROUND(COALESCE(((SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END)*tec_products.tax)/100), 0), 2) AS tax, 
				COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.quantity*tec_sale_items.cost ELSE tec_sale_items.quantity*tec_sale_items.cost END), 0) AS cost, 
				COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END), 0) AS income,
				COALESCE(SUM(tec_sale_items.item_discount), 0) AS total_discount,
				ROUND((COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END), 0)) - COALESCE(SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.quantity*tec_sale_items.cost ELSE tec_sale_items.quantity*tec_sale_items.cost END), 0) - COALESCE(((SUM(CASE WHEN tec_sales.InvoiceType = 'NC' THEN -tec_sale_items.subtotal ELSE tec_sale_items.subtotal END)*tec_products.tax)/100), 0), 2)
						AS profit, tec_products.quantity
				FROM tec_sale_items 
				LEFT JOIN tec_products ON tec_sale_items.product_id = tec_products.id
				LEFT JOIN tec_sales ON tec_sales.id = tec_sale_items.sale_id";
		$where = " where 1 ";
		if($product) { $where.= " and tec_products.id='".$product."'"; }
	        if($start_date) { $where.= " and tec_sales.date>='".$start_date."'"; }
	        if($end_date) { $where.= " and tec_sales.date<='".$end_date."'"; }
		$query = $query.$where." GROUP BY tec_products.id ";
		$query_1 = "SELECT w.sale_date, SUM(w.sold) AS sold, 
		SUM(w.tax) AS tax, 
		SUM(w.cost) AS cost, 
		SUM(w.total_discount) AS total_discount, 
		SUM(w.income) AS income, 
		SUM(w.profit) AS profit, 
		SUM(w.quantity) AS quantity 
			FROM ( ".$query." ) w GROUP BY sale_date order by sale_date";
		$rows = $this->db->query($query_1)->result();   
		
		return $rows;

	}
	public function get_sale_group_tax($sale_id, $products)
	{
		if($products){
			$product_str = implode(",", $products);
			$query = "SELECT w.tax_id, w.tax_pro, COALESCE(SUM(w.item_tax), 0) AS tot_tax FROM (SELECT a.tax_id, a.item_tax, b.tax AS tax_pro  FROM tec_sale_items a LEFT JOIN tec_tax b ON a.`tax_id` = b.`id` WHERE a.sale_id='".$sale_id."' AND  a.product_id IN (".$product_str.")) w GROUP BY w.tax_id";
		}else{
			$query = "SELECT w.tax_id, w.tax_pro, COALESCE(SUM(w.item_tax), 0) AS tot_tax FROM (SELECT a.tax_id, a.item_tax, b.tax AS tax_pro  FROM tec_sale_items a LEFT JOIN tec_tax b ON a.`tax_id` = b.`id` WHERE a.sale_id='".$sale_id."') w GROUP BY w.tax_id";
		}
		$q = $this->db->query($query, false);
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;

	}
	public function get_total_sale_group_tax($sale_ids)
	{
		$sales_str = implode(",", $sale_ids);
		$query = "SELECT w.tax_id, w.tax_pro, COALESCE(SUM(w.item_tax), 0) AS tot_tax FROM (SELECT a.tax_id, a.item_tax, b.tax AS tax_pro  FROM tec_sale_items a LEFT JOIN tec_tax b ON a.`tax_id` = b.`id` WHERE a.sale_id IN (".$sales_str.")) w GROUP BY w.tax_id";
		$q = $this->db->query($query, false);
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;

	}
	
	public function topProducts1()
	{
		$m = date('Y-m', strtotime('first day of last month'));
		$this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
		->join('products', 'products.id=sale_items.product_id', 'left')
		->join('sales', 'sales.id=sale_items.sale_id', 'left')
		->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
		->group_by('sale_items.product_id')
		->limit(10)
		->like('sales.date', $m, 'both');
		$this->db->where("InvoiceType!=","FP");
		$this->db->where("tec_sales.InvoiceStatus!=","A");
		$this->db->where("tec_sales.mesa!=","NC");
		$q = $this->db->get('sale_items');
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
	}

	public function topProducts3()
	{
		$this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
		->join('products', 'products.id=sale_items.product_id', 'left')
		->join('sales', 'sales.id=sale_items.sale_id', 'left')
		->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
		->group_by('sale_items.product_id')
		->limit(10)
		->where($this->db->dbprefix('sales').'.date >= last_day(now()) + interval 1 day - interval 3 month', NULL, FALSE);
		$q = $this->db->get('sale_items');
		$this->db->where("InvoiceType!=","FP");
		$this->db->where("tec_sales.InvoiceStatus!=","A");
		$this->db->where("tec_sales.mesa!=","NC");
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
	}

	public function topProducts12()
	{
		$this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
		->join('products', 'products.id=sale_items.product_id', 'left')
		->join('sales', 'sales.id=sale_items.sale_id', 'left')
		->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
		->group_by('sale_items.product_id')
		->limit(10)
		->where($this->db->dbprefix('sales').'.date >= last_day(now()) + interval 1 day - interval 12 month', NULL, FALSE);
		$this->db->where("InvoiceType!=","FP");
		$this->db->where("tec_sales.InvoiceStatus!=","A");
		$this->db->where("tec_sales.mesa!=","NC");
		$q = $this->db->get('sale_items');
		
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}

			return $data;
		}
	}

	public function getDailySales($year, $month)
	{

		$myQuery = "SELECT DATE_FORMAT( date,  '%e' ) AS date, 
                COALESCE(sum(paid), 0) as total, 
                COALESCE(sum(grand_total), 0) as grand_total,
		COALESCE(sum(total_tax), 0) as tax, 
                
                (SELECT COALESCE(sum(subtotal), 0) AS totalProducts FROM {$this->db->dbprefix('sale_items')} INNER JOIN {$this->db->dbprefix('sales')} ON {$this->db->dbprefix('sale_items')}.sale_id = {$this->db->dbprefix('sales')}.id) AS totalProducts, 
                (SELECT COALESCE(sum(subtotal), 0) AS totalAdtional FROM {$this->db->dbprefix('sale_sub_items')} INNER JOIN {$this->db->dbprefix('sales')} ON {$this->db->dbprefix('sale_sub_items')}.sale_id = {$this->db->dbprefix('sales')}.id) AS totalAdtional, 
                
                COALESCE(sum(total_discount), 0) as discount FROM (".$this->db->dbprefix('sales').")
		WHERE DATE_FORMAT( date,  '%Y-%m' ) =  '{$year}-{$month}'
		AND InvoiceStatus = 'N'
		AND InvoiceType <> 'NC' 
		AND InvoiceType <> 'FP'
		AND mesa <> 'NC'
		
		GROUP BY DATE_FORMAT( date,  '%e' )";
		$q = $this->db->query($myQuery, false);
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}


	public function getMonthlySales($year)
	{

		$myQuery = "SELECT DATE_FORMAT( date,  '%c' ) AS date, 
                
                (SELECT COALESCE(sum(subtotal), 0) AS totalProducts FROM {$this->db->dbprefix('sale_items')} INNER JOIN {$this->db->dbprefix('sales')} ON {$this->db->dbprefix('sale_items')}.sale_id = {$this->db->dbprefix('sales')}.id) AS totalProducts, 
                (SELECT COALESCE(sum(subtotal), 0) AS totalAdtional FROM {$this->db->dbprefix('sale_sub_items')} INNER JOIN {$this->db->dbprefix('sales')} ON {$this->db->dbprefix('sale_sub_items')}.sale_id = {$this->db->dbprefix('sales')}.id) AS totalAdtional, 
                
                COALESCE(sum(paid), 0) as total, 
                COALESCE(sum(grand_total), 0) as grand_total,
		        COALESCE(sum(total_tax), 0) as tax, COALESCE(sum(total_discount), 0) as discount
		FROM (".$this->db->dbprefix('sales').")
		WHERE DATE_FORMAT( date,  '%Y' ) =  '{$year}'
		AND InvoiceStatus = 'N'
		AND InvoiceType <> 'NC' 
		AND InvoiceType <> 'FP'
		AND mesa <> 'NC'
	    GROUP BY date_format( date, '%c' ) ORDER BY date_format( date, '%c' ) ASC";
		$q = $this->db->query($myQuery, false);
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
	}

	public function getTotalSalesforCustomer($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL, $InvoiceType = null)
	{
		if($start_date && $end_date) {
			$this->db->where('date >=', $start_date);
			$this->db->where('date <=', $end_date);
		}
                if($InvoiceType != null){
                    $this->db->where('InvoiceType =', $InvoiceType);
                }
                //InvoiceType
		if($user != NULL) {
			$this->db->where_in('created_by', implode(",", $user));
		}
		 $q=$this->db->get_where('sales', array('customer_id' => $customer_id));
		 return $q->num_rows();

	}

	public function getRowSalesforCustomer($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL)
	{
		if($start_date && $end_date) {
			$this->db->where('date >=', $start_date);
			$this->db->where('date <=', $end_date);
		}
		if($user) {
			$this->db->where_in('created_by', $user);
		}
		 $q=$this->db->get_where('sales', array('customer_id' => $customer_id));
		 return $q->result_array();

	}

	public function getRowSales($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL)
	{
		if($start_date && $end_date) {
			$this->db->where('date >=', $start_date);
			$this->db->where('date <=', $end_date);
		}
		if($user) {
			$this->db->where('created_by', $user);
		}
		 $q=$this->db->get_where('sales');
		 return $q->result_array();

	}


	public function getSaleItem($sale_id=""){
		$this->db->where("sale_id", $sale_id);
		$res = $this->db->get("sale_items");
		return $res->row_array();
	}

	public function getTotalSalesValueforCustomer($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL, $InvoiceType = NULL)
	{
		$this->db->select('sum(total) as total');
		if($start_date && $end_date) {
			$this->db->where('date >=', $start_date);
			$this->db->where('date <=', $end_date);
		}
                if($InvoiceType != null){
                    $this->db->where('InvoiceType =', $InvoiceType);
                }
		if($user!=NULL) {
			$this->db->where_in('created_by', $user);
		}
		 $q=$this->db->get_where('sales', array('customer_id' => $customer_id));
		 if( $q->num_rows() > 0 )
		  {
			$s = $q->row();
			return $s->total;
		  }
		return FALSE;
	}

	public function getAllStaff()
    {

        $q = $this->db->get('users');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

	public function getTotalSales($start, $end)
    {
        $this->db->select('count(id) as paid, sum(COALESCE(grand_total, 0)) as total_amount, SUM(COALESCE(paid, 0)) as paid, SUM(COALESCE(total_tax, 0)) as tax', FALSE)
			->where("InvoiceStatus = 'N'")
		    ->where("date >= '{$start}' and date <= '{$end}'", NULL, FALSE);
        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getTotalPurchases($start, $end)
    {
        $this->db->select('count(id) as total, sum(COALESCE(total, 0)) as total_amount', FALSE)
            ->where("date >= '{$start}' and date <= '{$end}'", NULL, FALSE);
        $q = $this->db->get('purchases');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getTotalExpenses($start, $end)
    {
        $this->db->select('count(id) as total, sum(COALESCE(amount, 0)) as total_amount', FALSE)
            ->where("date >= '{$start}' and date <= '{$end}'", NULL, FALSE);
        $q = $this->db->get('expenses');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }


}
