<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Purchases_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function getPurchaseByID($id) {
        $q = $this->db->get_where('purchases', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    
    public function getSupplierByID($id) {
        $q = $this->db->get_where('suppliers', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getAllPurchaseItems($purchase_id) {
        $this->db->select('purchase_items.*, products.code as product_code, products.name as product_name, products.price as product_price')
                ->join('products', 'products.id=purchase_items.product_id', 'left')
                ->group_by('purchase_items.id')
                ->order_by('id', 'asc');
        $q = $this->db->get_where('purchase_items', array('purchase_id' => $purchase_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function getfilterlist($user, $start_date, $end_date, $products){
        $this->db->select("purchases.id as id,  purchases.date, reference, total,  suppliers.name, note, CASE WHEN received=1 THEN 'Received' WHEN received = 0 THEN 'Not Yet Received' END, attachment")
            ->from('purchases')
            ->join('suppliers', 'suppliers.id=purchases.supplier_id', 'left');
        if($start_date) { $this->db->where('purchases.date >=', $start_date); }
        if($end_date) { $this->db->where('purchases.date <=', $end_date); }
        $q = $this->db->get();
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }	
            return $data;	
        }
            return FALSE;
    }

    public function getExpensesFilterList($user = NULL, $start_date = NULL, $end_date= NULL, $products= NULL){
        
        $myQuery ="SELECT {$this->db->dbprefix('expenses')}.id AS id, DATE, reference, amount, note, CONCAT({$this->db->dbprefix('users')}.first_name, ' ', {$this->db->dbprefix('users')}.last_name) AS USER, attachment
                    FROM {$this->db->dbprefix('expenses')}  
                    LEFT JOIN {$this->db->dbprefix('users')}  ON {$this->db->dbprefix('users')}.id={$this->db->dbprefix('expenses')}.created_by 
                    WHERE 1 ";   
        if($start_date) { $myQuery = $myQuery . " and {$this->db->dbprefix('expenses')}.date >='".$start_date."'"; }
        if($end_date) { $myQuery = $myQuery . " and {$this->db->dbprefix('expenses')}.date <='".$end_date."'";  }   
		$q = $this->db->query($myQuery, false);
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
		return FALSE;
    }

    public function getTaxes($payload) {
        foreach ($payload as $value) {
            $q = $this->db->get_where('tax', array('id' => $value->tax_id), 1);
            if ($q->num_rows() > 0) {
                $data[] = $q->row();
            }
        }
        return $data;
    }

    public function addPurchase($data, $items) {
        if ($this->db->insert('purchases', $data)) {
            $purchase_id = $this->db->insert_id();
            foreach ($items as $item) {
                $item['purchase_id'] = $purchase_id;
                if ($this->db->insert('purchase_items', $item)) {
                    $product = $this->site->getProductByID($item['product_id']);
                    if ($data['received'] == 1) {
                        $this->db->update('products', array('cost' => $item['cost'], 'quantity' => ($product->quantity + $item['quantity'])), array('id' => $product->id));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public function updatePurchase($id, $data = NULL, $items = array()) {
        $oitems = $this->getAllPurchaseItems($id);
        foreach ($oitems as $oitem) {
            $product = $this->site->getProductByID($oitem->product_id);
            $this->db->update('products', array('quantity' => ($product->quantity - $oitem->quantity)), array('id' => $product->id));
        }
        if ($this->db->update('purchases', $data, array('id' => $id)) && $this->db->delete('purchase_items', array('purchase_id' => $id))) {
            foreach ($items as $item) {
                $item['purchase_id'] = $id;
                if ($this->db->insert('purchase_items', $item)) {
                    $product = $this->site->getProductByID($item['product_id']);
                    if ($data['received'] == 1) {
                        $this->db->update('products', array('quantity' => ($product->quantity + $item['quantity'])), array('id' => $product->id));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public function deletePurchase($id) {
        $oitems = $this->getAllPurchaseItems($id);
        foreach ($oitems as $oitem) {
            $product = $this->site->getProductByID($oitem->product_id);
            $this->db->update('products', array('quantity' => ($product->quantity - $oitem->quantity)), array('id' => $product->id));
        }
        if ($this->db->delete('purchases', array('id' => $id)) && $this->db->delete('purchase_items', array('purchase_id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function getProductNames($term, $limit = 10) {
        $this->db->where("type != 'combo' AND (name LIKE '%" . $term . "%' OR code LIKE '%" . $term . "%' OR  concat(name, ' (', code, ')') LIKE '%" . $term . "%')");
        $this->db->limit($limit);
        $q = $this->db->get('products');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getExpenseByID($id) {
        $q = $this->db->get_where('expenses', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addExpense($data = array()) {
        if ($this->db->insert('expenses', $data)) {
            return true;
        }
        return false;
    }

    public function updateExpense($id, $data = array()) {
        if ($this->db->update('expenses', $data, array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function deleteExpense($id) {
        if ($this->db->delete('expenses', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

}
