<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Printer_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /*
     * Get printer by printer_id
     */

    function get_printer($printer_id) {
        return $this->db->get_where('printers', array('printer_id' => $printer_id))->row_array();
    }

    /*
     * Get all printers count
     */

    function get_all_printers_count() {
        $this->db->from('printers');
        return $this->db->count_all_results();
    }

    /*
     * Get all printers
     */

    function get_all_printers($params = array()) {
        $this->db->order_by('printer_id', 'desc');
        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset']);
        }
        return $this->db->get('printers')->result_array();
    }

    /*
     * function to add new printer
     */

    function add_printer($params) {
        try {
            $this->db->insert('printers', $params);
           // echo "errors mtd: " . print_r($this->db->error(),true);
            //exit;
            return $this->db->insert_id();
        } catch (Exception $ex) {
           // echo "Error:: " . $ex->getMessage();
            //exit;
        }
    }

    /*
     * function to update printer
     */

    function update_printer($printer_id, $params) {
        $this->db->where('printer_id', $printer_id);
        return $this->db->update('printers', $params);
    }

    /*
     * function to delete printer
     */

    function delete_printer($printer_id) {
        return $this->db->delete('printers', array('printer_id' => $printer_id));
    }

}
