<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Logged_model extends CI_Model {

    protected $table = 'tec_logged_status';

    public function __construct()
    {
        parent::__construct();
    }

    public function insert($data = [])
    {
        if (empty($data) || !isset($data['TaxRegistrationNumber'])) return false;
        return $this->db->insert($this->table, $data);
    }

    public function get_last_by_nif($nif)
    {
        return $this->db->from($this->table)->where('TaxRegistrationNumber', $nif)
                    ->order_by('id', 'DESC')->limit(1)->get()->row_array();
    }

    /**
     * Retorna o último registo de tec_licences para um NIF (se existir)
     */
    public function get_latest_licence_by_nif($nif)
    {
        $tbl = 'tec_licences';
        $q = $this->db->from($tbl)->where('TaxRegistrationNumber', $nif)->order_by('id', 'DESC')->limit(1)->get();
        if ($q && $q->num_rows() > 0) {
            return $q->row_array();
        }
        return null;
    }

    // Nonce helpers for replay protection
    public function nonce_exists($nonce)
    {
        $q = $this->db->from('sif_api_nonces')->where('nonce', $nonce)->limit(1)->get();
        return ($q && $q->num_rows() > 0);
    }

    public function store_nonce($nonce)
    {
        return $this->db->insert('sif_api_nonces', ['nonce' => $nonce, 'created_at' => date('Y-m-d H:i:s')]);
    }

}
