<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Customers_model extends CI_Model
{
	
	public function __construct() {
		parent::__construct();
	}
	
	public function getCustomerByID($id) 
	{
		$q = $this->db->get_where('customers', array('id' => $id), 1); 
		if( $q->num_rows() > 0 ) {
			return $q->row();
		} 
		return FALSE;
	}
	public function getCustomerByCf1($cf1) 
	{
		$q = $this->db->get_where('customers', array('cf1' => $cf1), 1); 
		if( $q->num_rows() > 0 ) {
			return $q->row();
		} 
		return FALSE;
	}
	
	public function getclientdata($id) 
	{
		$this->db->select("id, date, customer_name, InvoiceNo, status, tec_sales.grand_total, tec_sales.paid, (tec_sales.grand_total-tec_sales.paid) as balance ")
		->where('InvoiceType !=', "FP" )
		->where('InvoiceType !=', "NC")
		->where("mesa!=","NC")
		->where('customer_id', $id);
		$q = $this->db->get('sales');
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
	}
	public function getSaleDataById($id, $initial_date = null, $final_date = null){
		$where= "WHERE 1 ";
		if($initial_date || $final_date){
			
			if($initial_date){
				$where .= " and date(`date`) >= '".$initial_date."'";
			}
			if($final_date){
				$where .= " and date(`date`) <= '".$final_date."'";
			}
		}
		$sql ='SELECT w.* FROM (SELECT id AS sale_id, `date`, InvoiceNo,  grand_total AS subtotal, ("")pos_paid FROM tec_sales  '.$where.' and customer_id ='.$id.'  AND InvoiceType <> "FP" 
		UNION (SELECT a.`sale_id`, a.`date`, a.`InvoiceNo`, ("")subtotal, a.`amount` FROM `tec_payments` a 
		LEFT JOIN (SELECT * FROM tec_sales '.$where.') b ON a.`sale_id` =b.id  LEFT JOIN `tec_payments` c ON a.`sale_id`=c.sale_id WHERE b.customer_id ='.$id.'  AND b.InvoiceType <> "FP")) w ORDER BY sale_id ASC';
		$q= $this->db->query($sql);
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
	}
        public function getAllClientData($initial_date = null, $final_date = null) 
	{

		$this->db->select("id, date, customer_name, InvoiceNo,  status,  tec_sales.grand_total, tec_sales.paid, (tec_sales.grand_total-tec_sales.paid) as balance ")
		->where('InvoiceType !=', "FP" )
		->where('InvoiceType !=', "NC")
		->where("mesa!=","NC");
		if($initial_date != null){
			$this->db->where('date(date) >=', $initial_date);
		}
			if($final_date != null){
			$this->db->where('date(date) <=', $final_date);
		}
		//->where('customer_id', $id);
		$q = $this->db->get('sales');
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			return $data;
		}
	}
	public function addCustomer($data = array())
	{
		if($this->db->insert('customers', $data)) {
			return $this->db->insert_id();
		}
		return false;
	}
	
	public function updateCustomer($id, $data = array())
	{
		if($this->db->update('customers', $data, array('id' => $id))) {
			return true;
		}
		return false;
	}
        public function isCustomerInSales($id) 
	{
		$this->db->select("*")
		->where('customer_id', $id);
		$q = $this->db->get('sales');
		if($q->num_rows() > 0) {
			return true;
		}
                return false;
	}
	
	public function deleteCustomer($id) 
	{
		if($this->db->delete('customers', array('id' => $id))) {
			return true;
		}
		return FALSE;
	}

}
