<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Classe de verificação de integridade do sistema
 * NÃO MODIFICAR - Sistema de proteção de licença
 */
class Security_check {
    
    private static $protected_files = [
        'app/controllers/Auth.php',
        'app/core/Security_check.php',
        'app/core/MY_Controller.php'
    ];
    
    /**
     * Verifica integridade dos arquivos críticos
     * Retorna FALSE se detectar modificação não autorizada
     */
    public static function verify_integrity() {
        $base_path = FCPATH;
        $hash_file = APPPATH . '../.system_integrity';
        
        // Se não existe arquivo de hash, criar no primeiro uso
        if (!file_exists($hash_file)) {
            self::create_integrity_file($hash_file, $base_path);
            return true;
        }
        
        // Ler hashes armazenados
        $stored = @file_get_contents($hash_file);
        if (!$stored) return true; // Se não conseguir ler, permite execução
        
        $stored_hashes = json_decode(base64_decode($stored), true);
        if (!$stored_hashes) return true;
        
        // Verificar cada arquivo protegido
        foreach (self::$protected_files as $file) {
            $full_path = $base_path . $file;
            if (!file_exists($full_path)) continue;
            
            $current_hash = md5_file($full_path);
            $file_key = md5($file);
            
            if (isset($stored_hashes[$file_key])) {
                if ($stored_hashes[$file_key] !== $current_hash) {
                    // Arquivo foi modificado - registrar e bloquear
                    self::log_tampering($file);
                    return false;
                }
            }
        }
        
        return true;
    }
    
    /**
     * Cria arquivo de integridade inicial
     */
    private static function create_integrity_file($hash_file, $base_path) {
        $hashes = [];
        foreach (self::$protected_files as $file) {
            $full_path = $base_path . $file;
            if (file_exists($full_path)) {
                $file_key = md5($file);
                $hashes[$file_key] = md5_file($full_path);
            }
        }
        
        $encoded = base64_encode(json_encode($hashes));
        @file_put_contents($hash_file, $encoded, LOCK_EX);
        @chmod($hash_file, 0444); // Read-only
    }
    
    /**
     * Atualiza hashes após modificação autorizada
     */
    public static function update_integrity($authorized_key = null) {
        // Chave de autorização (alterar para um valor secreto)
        $secret_key = 'sifpos_2026_secure_' . md5('wpv_modelo');
        
        if ($authorized_key !== $secret_key) {
            return false;
        }
        
        $base_path = FCPATH;
        $hash_file = APPPATH . '../.system_integrity';
        
        @chmod($hash_file, 0644); // Temporariamente writable
        self::create_integrity_file($hash_file, $base_path);
        
        return true;
    }
    
    /**
     * Registra tentativa de adulteração
     */
    private static function log_tampering($file) {
        $log_file = APPPATH . '../logs/security_alert.log';
        $timestamp = date('Y-m-d H:i:s');
        $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'unknown';
        $msg = "[$timestamp] SECURITY ALERT: File tampering detected - $file | IP: $ip\n";
        @file_put_contents($log_file, $msg, FILE_APPEND | LOCK_EX);
    }
    
    /**
     * Verifica se a função de verificação de licença existe e não foi comentada
     */
    public static function verify_license_function_exists() {
        $auth_file = FCPATH . 'app/controllers/Auth.php';
        if (!file_exists($auth_file)) return false;
        
        $content = file_get_contents($auth_file);
        
        // Verificar se a função verify_remote_license existe
        if (strpos($content, 'function verify_remote_license') === false &&
            strpos($content, 'private function verify_remote_license') === false) {
            self::log_tampering('Auth.php - verify_remote_license function removed');
            return false;
        }
        
        // Verificar se a chamada existe no login
        if (strpos($content, '$this->verify_remote_license()') === false) {
            self::log_tampering('Auth.php - verify_remote_license call removed from login');
            return false;
        }
        
        return true;
    }
}
