<?php
// error_reporting(-1);
        // ini_set('display_errors', 1);
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

require realpath(__DIR__) . '/../../app/core/Request.php';
require realpath(__DIR__) . '/../../vendor/autoload.php';

class Settings extends MY_Controller {

    function __construct() {
        parent::__construct();

        if (!$this->loggedIn) {
            redirect('login');
        }

        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->load->library('form_validation');
        $this->load->model('settings_model');
        $this->load->helper("database_helper");
    }

 function index() {
    if ($this->session->userdata("settings") != 1) {
        $this->session->set_flashdata('error', lang('access_denied'));
        redirect('pos');
    }

    $this->form_validation->set_rules('site_name', lang('site_name'));
    $this->form_validation->set_rules('tel', lang('tel'));
    $this->form_validation->set_rules('language', lang('language'), 'required');
    $this->form_validation->set_rules('currency_prefix', lang('currency_code'));
    $this->form_validation->set_rules('default_discount', lang('default_discount'), 'required');
    $this->form_validation->set_rules('tax_rate', lang('default_tax_rate'), 'required');
    $this->form_validation->set_rules('rows_per_page', lang('rows_per_page'), 'required');
    $this->form_validation->set_rules('display_product', lang('display_product'), 'required');
    $this->form_validation->set_rules('pro_limit', lang('pro_limit'), 'required');
    $this->form_validation->set_rules('display_kb', lang('display_kb'), 'required');
    $this->form_validation->set_rules('default_category', lang('default_category'), 'required');
    $this->form_validation->set_rules('default_customer', lang('default_customer'), 'required');
    $this->form_validation->set_rules('dateformat', lang('date_format'), 'required');
    $this->form_validation->set_rules('timeformat', lang('time_format'), 'required');
    $this->form_validation->set_rules('item_addition', lang('item_addition'), 'required');

    if ($this->input->post('protocol') == 'smtp') {
        $this->form_validation->set_rules('smtp_host', lang('smtp_host'), 'required');
        $this->form_validation->set_rules('smtp_user', lang('smtp_user'), 'required');
        $this->form_validation->set_rules('smtp_pass', lang('smtp_pass'), 'required');
        $this->form_validation->set_rules('smtp_port', lang('smtp_port'), 'required');
    }

    if ($this->input->post('stripe')) {
        $this->form_validation->set_rules('stripe_secret_key', lang('stripe_secret_key'), 'required');
        $this->form_validation->set_rules('stripe_publishable_key', lang('stripe_publishable_key'), 'required');
    }

    $this->form_validation->set_rules('bill_header', lang('bill_header'), 'required');
    $this->form_validation->set_rules('bill_footer', lang('bill_footer'), 'required');

    $this->load->library('encrypt');

    if ($this->form_validation->run() == true) {

        // DEBUG: Verificar se tipo_faturacao está chegando via POST
        $tipo_faturacao_post = $this->input->post('tipo_faturacao');
        log_message('debug', 'Settings - tipo_faturacao POST: ' . var_export($tipo_faturacao_post, true));

        /* =========================================================
           TRAVA SERVIDOR: Séries AGT só gravam 1 vez
           - Se já existe na DB com formato válido (inicia com FT/FR/GF/NC/RC), mantém
           - Se for NULL ou não começar com o prefixo correto, aceita POST
        ========================================================== */
        $settingsObj = $this->site->getSettings();
        $current = is_object($settingsObj) ? (array)$settingsObj : array();

        $series_config = array(
            'FT-seriesCode' => 'FT',
            'FR-seriesCode' => 'FR',
            'GF-seriesCode' => 'GF',
            'NC-seriesCode' => 'NC',
            'RC-seriesCode' => 'RC'
        );
        
        $series_to_save = array();

        foreach ($series_config as $field => $prefix) {
            $dbval = isset($current[$field]) ? trim((string)$current[$field]) : '';
            $posted = trim((string)$this->input->post($field));

            // Verifica se DB já tem valor válido (começa com prefixo esperado e ano)
            // Formato esperado: "2026S001" ou similar
            $hasValidSeries = ($dbval !== '' && 
                               $dbval !== 'NULL' && 
                               preg_match('/^\d{4}[A-Z]/', $dbval));

            if ($hasValidSeries) {
                // Já existe série válida => mantém DB
                $series_to_save[$field] = $dbval;
            } else {
                // Não existe ou é inválido => aceita POST se vier algo
                $series_to_save[$field] = ($posted !== '' && $posted !== 'NULL') ? $posted : '';
            }
        }
        /* ======================= FIM TRAVA ======================= */

        $data = array(
            'site_name' => 'SIF-POS',
            'Telephone' => $this->input->post('tel'),
            'currency_prefix' => strtoupper($this->input->post('currency_prefix')),
            'default_tax_rate' => $this->input->post('tax_rate'),
            'language' => $this->input->post('language'),
            'default_discount' => $this->input->post('default_discount'),
            'rows_per_page' => $this->input->post('rows_per_page'),
            'bsty' => $this->input->post('display_product'),
            'pro_limit' => $this->input->post('pro_limit'),
            'display_kb' => $this->input->post('display_kb'),
            'default_category' => $this->input->post('default_category'),
            'default_customer' => $this->input->post('default_customer'),
            'barcode_symbology' => $this->input->post('barcode_symbology'),
            'dateformat' => $this->input->post('dateformat'),
            'timeformat' => $this->input->post('timeformat'),
            'header' => $this->input->post('bill_header'),
            'footer' => $this->input->post('bill_footer'),
            'default_email' => $this->input->post('default_email'),
            'protocol' => $this->input->post('protocol'),
            'smtp_host' => $this->input->post('smtp_host'),
            'smtp_user' => $this->input->post('smtp_user'),
            'smtp_port' => $this->input->post('smtp_port'),
            'smtp_crypto' => $this->input->post('smtp_crypto'),
            'pin_code' => $this->input->post('pin_code') ? $this->input->post('pin_code') : NULL,
            'receipt_printer' => $this->input->post('receipt_printer'),
            'cash_drawer_codes' => $this->input->post('cash_drawer_codes'),

            'cancel_sale' => $this->input->post('cancel_sale'),
            'suspend_sale' => $this->input->post('suspend_sale'),

            'private' => $this->input->post('private'),
            'public' => $this->input->post('public'),

            'pos_printers' => $this->input->post('pos_printers'),
            'java_applet' => DEMO ? '0' : $this->input->post('enable_java_applet'),
            'rounding' => $this->input->post('rounding'),
            'item_addition' => $this->input->post('item_addition'),
            'stripe' => $this->input->post('stripe'),
            'stripe_secret_key' => $this->input->post('stripe_secret_key'),
            'stripe_publishable_key' => $this->input->post('stripe_publishable_key'),

            'CompanyID' => $this->input->post('CompanyID'),
            'TaxRegistrationNumber' => $this->input->post('TaxRegistrationNumber'),
            'TaxAccountingBasis' => $this->input->post('TaxAccountingBasis'),
            'CompanyName' => $this->input->post('CompanyName'),
            'BusinessName' => $this->input->post('BusinessName'),
            'BuildingNumber' => $this->input->post('BuildingNumber'),
            'StreetName' => $this->input->post('StreetName'),
            'AddressDetail' => $this->input->post('AddressDetail'),
            'City' => $this->input->post('City'),
            'PostalCode' => $this->input->post('PostalCode'),
            'Province' => $this->input->post('Province'),
            'FiscalYear' => $this->input->post('FiscalYear'),
            'CurrencyCode' => $this->input->post('CurrencyCode'),
            'TaxEntity' => $this->input->post('TaxEntity'),
            'ProductCompanyTaxID' => $this->input->post('ProductCompanyTaxID'),
            'SoftwareValidationNumber' => $this->input->post('SoftwareValidationNumber'),

            'HeaderComment' => $this->input->post('HeaderComment'),
            'Fax' => $this->input->post('Fax'),
            'Email' => $this->input->post('Email'),
            'Website' => $this->input->post('Website'),
            'phone' => $this->input->post('phone'),
            'licence' => $this->input->post('licence'),
            'expired_month' => $this->input->post('expired_month'),
            'regime' => $this->input->post('regime'),
            'tipo_faturacao' => $this->input->post('tipo_faturacao'),

            // ===== SÉRIES AGT (com trava 1x) =====
            'FT-seriesCode' => $series_to_save['FT-seriesCode'],
            'FR-seriesCode' => $series_to_save['FR-seriesCode'],
            'GF-seriesCode' => $series_to_save['GF-seriesCode'],
            'NC-seriesCode' => $series_to_save['NC-seriesCode'],
            'RC-seriesCode' => $series_to_save['RC-seriesCode'],

            // ===== NÚMERO DO ESTABELECIMENTO =====
            'envato_username' => $this->input->post('establishmentNumber'),
        );

        if ($this->input->post('smtp_pass')) {
            $data['smtp_pass'] = $this->encrypt->encode($this->input->post('smtp_pass'));
        }

        if (isset($_FILES['userfile']) && $_FILES['userfile']['size'] > 0) {

            $this->load->library('upload');
            $config['upload_path'] = 'themes/default/assets/images/header/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '8000';
            $config['overwrite'] = FALSE;
            $this->upload->initialize($config);

            if (!$this->upload->do_upload()) {
                $error = $this->upload->display_errors();
                $this->session->set_flashdata('message', $error);
                redirect('settings');
            }

            $photo = $this->upload->file_name;

            if (isset($photo)) {
                $data['logo'] = $photo;
            }
        }

        if ($this->settings_model->updateSetting($data)) {
            // Garantir persistência explícita do tipo de faturação
            $tf = $this->input->post('tipo_faturacao');
            if ($tf !== null) {
                $this->settings_model->updateTipoFaturacao($tf);
            }

            $this->session->set_flashdata('message', lang('setting_updated'));
            redirect('settings');
        }
    }

    // fallback (GET ou validação falhou)
    $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
    $this->data['settings'] = $this->site->getSettings();
    $this->data['customers'] = $this->site->getAllCustomers();
    $this->data['categories'] = $this->site->getAllCategories();
    $this->data['smtp_pass'] = $this->encrypt->decode($this->data['settings']->smtp_pass);
    $this->data['page_title'] = lang('settings');
    $bc = array(array('link' => '#', 'page' => lang('settings')));
    $meta = array('page_title' => lang('settings'), 'bc' => $bc);
    $this->page_construct('settings/index', $this->data, $meta);
}


    function updates() {
        if($this->session->userdata("settings")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
       
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->form_validation->set_rules('purchase_code', lang("purchase_code"), 'required');
        $this->form_validation->set_rules('envato_username', lang("envato_username"), 'required');
       
    }

    function install_update($file, $m_version, $version) {
        if (DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->load->helper('update');
        save_remote_file($file . '.zip');
        $this->tec->unzip('./files/updates/' . $file . '.zip');
        if ($m_version) {
            $this->load->library('migration');
            if (!$this->migration->latest()) {
                $this->session->set_flashdata('error', $this->migration->error_string());
                redirect("settings/updates");
            }
        }
        $this->db->update('settings', array('version' => $version, 'update' => 0), array('setting_id' => 1));
        unlink('./files/updates/' . $file . '.zip');
        $this->session->set_flashdata('success', lang('update_done'));
        redirect("settings/updates");
    }

    function mesa() {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => '#', 'page' => lang('settings')));
        $meta = array('page_title' => "Mesas", 'bc' => $bc);
        $this->page_construct('settings/mesa', $this->data, $meta);
    }

    function table() {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $q = new Query();
        $q
                ->select()
                ->from("tec_mesas")
                ->where_equal(
                        array(
                            "id" => $_POST["id"]
                        )
                )
                ->limit(1)
                ->run();
        $data = $q->get_selected();
        if (!$data) {
            return print json_encode(array("error" => true));
            die();
        }

        return print json_encode(array("error" => false, "name" => $data["name"], "places" => $data["places"]));
        die();
    }

    function new_table() {
        $q = new Query();
        $q
                ->insert("tec_mesas", array("name" => $_POST["table_name"], "places" => $_POST["table_place"]))
                ->run();
        redirect("settings/mesa");
    }

    function update_mesa() {
        $q = new Query();
        $q
                ->update("tec_mesas", array("name" => $_POST["table_name"], "places" => $_POST["table_place"]))
                ->where_equal(
                        array(
                            "id" => $_POST["update"]
                        )
                )
                ->run();
        redirect("settings/mesa");
    }

    function remove_mesa() {
        if (empty($_GET["id"])) {
            redirect("settings/mesa");
        }
        $q = new Query();
        $q
                ->delete("tec_mesas")
                ->where_equal(
                        array(
                            "id" => $_GET["id"]
                        )
                )
                ->run();
        redirect("settings/mesa");
    }

    function get_mesas_logs() {
        $this->load->library('datatables');
        $this->datatables
                ->select("id, name, places, status,id AS ID", FALSE)
                ->from("tec_mesas");
        echo $this->datatables->generate();
    }

    function backups() {
        if($this->session->userdata("settings")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['files'] = glob('./files/backups/*.zip', GLOB_BRACE);
        $this->data['dbs'] = glob('./files/backups/*.sql', GLOB_BRACE);
        $bc   = array(array('link' => site_url('settings'), 'page' => lang('settings')), array('link' => '#', 'page' => lang('backups')));
        $meta = array('page_title' => lang('backups'), 'bc' => $bc);
        $this->page_construct('settings/backups', $this->data, $meta);
    }

    function backup_database() {
        
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->load->dbutil();
        $prefs = array(
            'format' => 'txt',
            'filename' => 'sifpos_db_backup.sql'
        );
        $back = $this->dbutil->backup($prefs);
        $backup = & $back;
        $db_name = 'sifpos_db_backup-' . date("Y-m-d H-i-s") . '.sql';
        $save = './files/backups/' . $db_name;
        $this->load->helper('file');
        write_file($save, $backup);
        $this->session->set_flashdata('messgae', lang('db_saved'));
        redirect("settings/backups");
    }

    function backup_files() {
        
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $name = 'file-backup-' . date("Y-m-d H:i:s");
        $this->tec->zip("./", './files/backups/', $name);
        $this->session->set_flashdata('message', lang('backup_saved'));
        redirect("settings/backups");
        exit();
    }

    function restore_database($dbfile) {
        
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $file = file_get_contents('./files/backups/' . $dbfile . '.sql');
        $this->db->conn_id->multi_query($file);
        $this->db->conn_id->close();
        redirect('logout/db');
    }

    function download_database($dbfile) {
        
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->load->library('zip');
        $this->zip->read_file('./files/backups/' . $dbfile . '.sql');
        $name = 'db_backup_' . date('Y_m_d_H_i_s') . '.zip';
        $this->zip->download($name);
        exit();
    }

    function download_backup($zipfile) {
        
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->load->helper('download');
        force_download('./files/backups/' . $zipfile . '.zip', NULL);
        exit();
    }

    function restore_backup($zipfile) {
       
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $file = './files/backups/' . $zipfile . '.zip';
        $this->tec->unzip($file, './');
        $this->session->set_flashdata('success', lang('files_restored'));
        redirect("settings/backups");
        exit();
    }

    function delete_database($dbfile) {
        if (DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        unlink('./files/backups/' . $dbfile . '.sql');
        $this->session->set_flashdata('messgae', lang('db_deleted'));
        redirect("settings/backups");
    }

    function delete_backup($zipfile) {
        if (DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        unlink('./files/backups/' . $zipfile . '.zip');
        $this->session->set_flashdata('messgae', lang('backup_deleted'));
        redirect("settings/backups");
    }

    public function saf_xsd(){
        if($this->session->userdata("settings")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $saf_xsd_field_row = get_row("tec_saf_setting",array("id"=>1));
        if($saf_xsd_field_row){
            $saf_xsd_fields = explode(",", $saf_xsd_field_row['field']);
        } else {
            $saf_xsd_fields = array();
        }
        $saf_xsd_setting = array();

        foreach ($saf_xsd_fields as $key => $saf_xsd_field) {
            $saf_xsd_row = get_row("tec_saf_setting",array("field"=>$saf_xsd_field));
            $saf_xsd_setting[$saf_xsd_field] = $saf_xsd_row['value'];
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('AF-AO XSD & XML Pattern');
        $this->data['exports'] =  get_rows("tec_saf_exports", array(), "export_date DESC");
        $bc = array(array('link' => site_url('settings'), 'page' => lang('settings')), array('link' => '#', 'page' => lang('AF-AO XSD & XML Pattern')));
        $meta = array('page_title' => lang('SAF-AO XSD & XML Pattern'), "saf_xsd_setting"=>$saf_xsd_setting,"bc"=>$bc);
        $this->page_construct('settings/saf_xsd',$this->data, $meta);

    }

    public function delete_xml($id){
        $xml = get_row("tec_saf_exports",array("id"=>$id));
        if($xml && file_exists("uploads/xml/".$xml['file_name'])){
            unlink("uploads/xml/".$xml['file_name']);
        }
        delete_row("tec_saf_exports",array("id"=>$id));
        $this->session->set_flashdata('message', lang("category_deleted"));
        redirect("settings/saf_xsd");
    }
    public function getXmlPattern(){
        $xml_content = htmlspecialchars_decode($this->input->post("xml"));
    
        $sub_str = $this->get_string_between($xml_content,"<Header>","</Header>");
        $data['Header'] = $sub_str;
        $xml_content = str_replace($sub_str, "Header_pattern", $xml_content);

        $sub_str = $this->get_string_include($xml_content,"<Account>","</Account>");
        $data['Account'] = $sub_str;
        $xml_content = str_replace($sub_str, "Account_pattern", $xml_content);

        $sub_str = $this->get_string_include($xml_content,"<Customer>","</Customer>");
        $data['Customer'] = $sub_str;
        $xml_content = str_replace($sub_str, "<Customer>Customer_pattern</Customer>", $xml_content);

        $sub_str = $this->get_string_include($xml_content,"<Supplier>","</Supplier>");
        $data['Supplier'] = $sub_str;
        $xml_content = str_replace($sub_str, "<Supplier>Supplier_pattern</Supplier>", $xml_content);
    
        $sub_str = $this->get_string_include($xml_content,"<Product>","</Product>");
        $data['Product'] = $sub_str;
        $xml_content = str_replace($sub_str, "<Product>Product_pattern</Product>", $xml_content);

        $sub_str = $this->get_string_between($xml_content,"<TaxTable>","</TaxTable>");
        $data['TaxTable'] = $sub_str;
        $xml_content = str_replace($sub_str, "TaxTable_pattern", $xml_content);

        $sub_str = $this->get_string_between($xml_content,"<GeneralLedgerEntries>","</GeneralLedgerEntries>");
        $data['GeneralLedgerEntries'] = $sub_str;
        $xml_content = str_replace($sub_str, "generalledgerentries_pattern", $xml_content);

        $sub_str = $this->get_string_between($xml_content,"<Invoice>","</Invoice>");
        $data['SalesInvoices'] = $sub_str;
        $xml_content = str_replace($sub_str, "SalesInvoices_pattern", $xml_content);

        $sub_str = $this->get_string_between($xml_content,"<StockMovement>","</StockMovement>");
        $data['MovementOfGoods'] = $sub_str;
        $xml_content = str_replace($sub_str, "MovementOfGoods_pattern", $xml_content);

        $sub_str = $this->get_string_between($xml_content,"<WorkDocument>","</WorkDocument>");
        $data['WorkingDocuments'] = $sub_str;
        $xml_content = str_replace($sub_str, "WorkingDocuments_pattern", $xml_content);

        $sub_str = $this->get_string_between($xml_content,"<Payment>","</Payment>");
        $data['Payments'] = $sub_str;
        $xml_content = str_replace($sub_str, "Payments_pattern", $xml_content);

        $sub_str = $this->get_string_between($xml_content,"<PurchaseInvoices>","</PurchaseInvoices>");
        $data['PurchaseInvoices'] = $sub_str;
        $xml_content = str_replace($sub_str, "PurchaseInvoices_pattern", $xml_content);

        $data['Audit'] = $xml_content;
        echo json_encode($data);
    }

    public function get_string_between($string, $start, $end){
        $string = ' ' . $string;
        $ini = strpos($string, $start);
        if ($ini == 0) return '';
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;
        return substr($string, $ini, $len);
    }


    public function get_string_include($string, $start, $end){
        $string = $string;
        $ini = strpos($string, $start);
        if ($ini == 0) return '';
        // $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini + strlen($end);
        return $substr = substr($string, $ini, $len);
    }

    public function save_pattern(){
        $data = $this->input->post();
        $saf_xsd_fields = "";
        foreach ($data as $key => $value) {
            $saf_xsd_fields.=$key.",";
        }
        $saf_xsd_fields = trim($saf_xsd_fields,",");
        delete_row("tec_saf_setting");
        create_row("tec_saf_setting",array("id"=>1,"field"=>$saf_xsd_fields,"value"=>""));
        foreach ($data as $key => $value) {
            $value = str_replace("[removed]", 'xmlns="urn:OECD:StandardAuditFile-Tax:AO_1.01_01" attributeFormDefault="unqualified" elementFormDefault="qualified" targetNamespace="urn:OECD:StandardAuditFile-Tax:AO_1.01_01" version="1.01_01" id="SAF-T_AO" xmlns', $value);
            // $value = str_replace("[1-9]+\d?/AGT/\d{4}|[0]","[1-9]+\\d?/AGT/\\d{4}|[0]", $value);
            // $value = str_replace("[1-9]+\d?/AGT/\d{4}|[0]","[0-9a-zA-Z\-/._+*]", $value);
            create_row("tec_saf_setting",array("field"=>$key,"value"=>htmlspecialchars_decode($value)));

        }
        redirect("settings/saf_xsd");
    }

    public function fill_xml_value($string,$start,$end,$value=""){
        // $sub_str = $this->get_string_between($xml_pattern,$start_string,$end_string);
        $string = $string;
        $ini = strpos($string, $start);
        if ($ini == 0) return '';
        // $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini + strlen($end);
        $substr = substr($string, $ini, $len);
        if(trim($value) == "" || $value == NULL) {
            $xml_pattern = str_replace($substr,  "", $string);
            // $xml_pattern = str_replace("\r\n    ".$substr,  "", $string);
            // $xml_pattern = str_replace("\r\n        ".$substr,  "", $string);
        }
        else {
             if($start =="<Customer>" || $start =="<Supplier>" || $start =="<Account>" || $start =="<Product>" || $start =="<Line>" || $start == "<Invoice>" || ($start == "<Payment>" && strlen($value)>100)){
                $xml_pattern = str_replace($substr,  $value, $string);

             }
            else 
                $xml_pattern = str_replace($substr,  $start.$value.$end, $string);

        }
        file_put_contents("1.xml", $this->finalize_saft_xml($xml_pattern));
        return $xml_pattern;
    }
    public function xmlReport(){
        $saf_xsd_field_row = get_row("tec_saf_setting",array("id"=>1));
        $saf_xsd_fields = explode(",", $saf_xsd_field_row['field']);
        $saf_xsd_pattern = array();

        $start_date = $this->input->post("start_date");
        $end_date = $this->input->post("end_date");

        foreach ($saf_xsd_fields as $key => $saf_xsd_field) {
            $saf_xsd_row = get_row("tec_saf_setting",array("field"=>$saf_xsd_field));
            $saf_xsd_pattern[$saf_xsd_field] = $saf_xsd_row['value'];
        }
        $header_pattern = $saf_xsd_pattern['header_pattern'];
        $setting_info = get_row("tec_settings",array("setting_id"=>1));
        $header_pattern = $this->fill_xml_value($header_pattern,"<AuditFileVersion>","</AuditFileVersion>","1.01_01");
        $header_pattern = $this->fill_xml_value($header_pattern,"<CompanyID>","</CompanyID>",$setting_info['CompanyID']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<TaxRegistrationNumber>","</TaxRegistrationNumber>",$setting_info['TaxRegistrationNumber']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<TaxAccountingBasis>","</TaxAccountingBasis>","F");
        $header_pattern = $this->fill_xml_value($header_pattern,"<CompanyName>","</CompanyName>",$setting_info['CompanyName']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<BusinessName>","</BusinessName>",$setting_info['BusinessName']);
        $buildingNum = trim($setting_info['BuildingNumber']) !== '' ? $setting_info['BuildingNumber'] : 'S/N';
        $header_pattern = $this->fill_xml_value($header_pattern,"<BuildingNumber>","</BuildingNumber>",$buildingNum);
        $header_pattern = $this->fill_xml_value($header_pattern,"<StreetName>","</StreetName>",$setting_info['StreetName']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<AddressDetail>","</AddressDetail>",$setting_info['AddressDetail']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<City>","</City>",$setting_info['City']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<PostalCode>","</PostalCode>",$setting_info['PostalCode']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<Province>","</Province>",$setting_info['Province']);
        $header_pattern = str_replace("<Country />", "<Country>AO</Country>",$header_pattern);
        $header_pattern = $this->fill_xml_value($header_pattern,"<FiscalYear>","</FiscalYear>",$setting_info['FiscalYear']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<StartDate>","</StartDate>",$start_date);
        $header_pattern = $this->fill_xml_value($header_pattern,"<EndDate>","</EndDate>", $end_date);
        $header_pattern = $this->fill_xml_value($header_pattern,"<CurrencyCode>","</CurrencyCode>",$setting_info['CurrencyCode']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<DateCreated>","</DateCreated>",date("Y-m-d"));
        $header_pattern = $this->fill_xml_value($header_pattern,"<TaxEntity>","</TaxEntity>",$setting_info['TaxEntity']);
        $prodCompanyTaxID = trim($setting_info['ProductCompanyTaxID']) !== '' ? $setting_info['ProductCompanyTaxID'] : $setting_info['TaxRegistrationNumber'];
        $header_pattern = $this->fill_xml_value($header_pattern,"<ProductCompanyTaxID>","</ProductCompanyTaxID>","103136359BA034");
        $header_pattern = $this->fill_xml_value($header_pattern,"<SoftwareValidationNumber>","</SoftwareValidationNumber>","230/AGT/2019");
        $header_pattern = $this->fill_xml_value($header_pattern,"<ProductID>","</ProductID>","SIF - POS/ JOSE  MANUEL BARROS");
        $header_pattern = $this->fill_xml_value($header_pattern,"<ProductVersion>","</ProductVersion>","1.0.4");
        $header_pattern = $this->fill_xml_value($header_pattern,"<HeaderComment>","</HeaderComment>",$setting_info['HeaderComment']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<Telephone>","</Telephone>",$setting_info['Telephone']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<Fax>","</Fax>",$setting_info['Fax']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<Email>","</Email>",$setting_info['Email']);
        $header_pattern = $this->fill_xml_value($header_pattern,"<Website>","</Website>",$setting_info['Website']);
         $account_pattern = $saf_xsd_pattern['account_pattern'];
        $account_info = array();
        $account_pattern = $this->fill_xml_value($account_pattern,"<AccountID>","</AccountID>",$account_info['AccountID']);
        $account_pattern = $this->fill_xml_value($account_pattern,"<AccountDescription>","</AccountDescription>",$account_info['AccountDescription']);
        $account_pattern = $this->fill_xml_value($account_pattern,"<OpeningDebitBalance>","</OpeningDebitBalance>",$account_info['OpeningDebitBalance']);
        $account_pattern = $this->fill_xml_value($account_pattern,"<OpeningCreditBalance>","</OpeningCreditBalance>",$account_info['OpeningCreditBalance']);
        $account_pattern = $this->fill_xml_value($account_pattern,"<ClosingDebitBalance>","</ClosingDebitBalance>",$account_info['OpeningCreditBalance']);
        $account_pattern = $this->fill_xml_value($account_pattern,"<ClosingCreditBalance>","</ClosingCreditBalance>",$account_info['ClosingCreditBalance']);
        $account_pattern = $this->fill_xml_value($account_pattern,"<GroupingCategory>","</GroupingCategory>",$account_info['GroupingCategory']);
        $account_pattern = $this->fill_xml_value($account_pattern,"<GroupingCode>","</GroupingCode>",$account_info['GroupingCode']);

        $start_date = $start_date." 00:00:00";
        $end_date = $end_date." 23:59:59";
        $proforma= "FP";

        $customer_pattern = "";
        $sale_infos = get_rows("tec_sales",array("date>="=>$start_date, "date<="=>$end_date, "InvoiceType!="=>$proforma)); 
        $customer_data = [];
        $product_data = [];
        foreach ($sale_infos as $key => $sale_info) {
            if(!in_array($sale_info["customer_id"], $customer_data))
                $customer_data[] = $sale_info["customer_id"];

            $sale_items = get_rows("tec_sale_items", array("sale_id"=>$sale_info['id']));
            foreach ($sale_items as $sale_item) {
                if(!in_array($sale_item["product_id"], $product_data))
                    $product_data[] = $sale_item["product_id"];
            }
        } 
         $customer_infos = get_rows("tec_customers");
        foreach ($customer_infos as $key => $customer_info) {
          /*   if(!in_array($customer_info["id"], $customer_data)) continue;  */
            $customer_pattern_sub = $saf_xsd_pattern['customer_pattern']."\r\n    ";
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<CustomerID>","</CustomerID>",$customer_info['id']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<AccountID>","</AccountID>",$customer_info['id']);
            if($customer_info['cf1'] == "") $customer_info['cf1'] = "999999999";
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<CustomerTaxID>","</CustomerTaxID>",$customer_info['cf1']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<CompanyName>","</CompanyName>",$customer_info['name']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Contact>","</Contact>",$customer_info['phone']);
            $custBuildingNum = trim($customer_info['numero']) !== '' ? $customer_info['numero'] : 'S/N';
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<BuildingNumber>","</BuildingNumber>",$custBuildingNum);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<StreetName>","</StreetName>",$customer_info['bairro']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<AddressDetail>","</AddressDetail>",$customer_info['bairro']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<City>","</City>",$customer_info['cidade']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<PostalCode>","</PostalCode>",$customer_info['postal_code']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Province>","</Province>",$customer_info['province']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Country>","</Country>","AO");
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Telephone>","</Telephone>",$customer_info['phone']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Fax>","</Fax>",$customer_info['Fax']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Email>","</Email>",$customer_info['email']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Website>","</Website>",$customer_info['website']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<SelfBillingIndicator>","</SelfBillingIndicator>","0");
            $customer_pattern.= $customer_pattern_sub; 
    
        
        }


        $supplier_pattern = "";
        $supplier_infos = get_rows("tec_purchases",array("date>="=>$start_date, "date<="=>$end_date)); 
        $customer_data = [];
       
        foreach ($supplier_infos as $key => $supplier_info) {
            if(!in_array($supplier_info["supplier_id"], $customer_data))
                $customer_data[] = $supplier_info["supplier_id"];

        } 
       
       
        $customer_infos = get_rows("tec_suppliers");
        foreach ($customer_infos as $key => $customer_info) {
            if(!in_array($customer_info["id"], $customer_data)) continue;
            $customer_pattern_sub = $saf_xsd_pattern['supplier_pattern']."\r\n    ";
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<SupplierID>","</SupplierID>",$customer_info['id']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<AccountID>","</AccountID>",$customer_info['id']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<SupplierTaxID>","</SupplierTaxID>",$customer_info['cf1']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<CompanyName>","</CompanyName>",$customer_info['name']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Contact>","</Contact>",$customer_info['phone']);
            $suppBuildingNum = trim($customer_info['numero']) !== '' ? $customer_info['numero'] : 'S/N';
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<BuildingNumber>","</BuildingNumber>",$suppBuildingNum);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<StreetName>","</StreetName>",$customer_info['bairro']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<AddressDetail>","</AddressDetail>",$customer_info['bairro']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<City>","</City>",$customer_info['cidade']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<PostalCode>","</PostalCode>",$customer_info['postal_code']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Province>","</Province>",$customer_info['estado']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Country>","</Country>","AO");
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Telephone>","</Telephone>",$customer_info['phone']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Fax>","</Fax>",$customer_info['Fax']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Email>","</Email>",$customer_info['email']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<Website>","</Website>",$customer_info['website']);
            $customer_pattern_sub = $this->fill_xml_value($customer_pattern_sub,"<SelfBillingIndicator>","</SelfBillingIndicator>","0");
            $supplier_pattern.= $customer_pattern_sub;
        }

        $product_pattern = "";
        $product_infos = get_rows("tec_products");
        foreach ($product_infos as $key => $product_info) {
            
           /*  if(!in_array($product_info["id"], $product_data)) continue; */

            $product_pattern_sub = $saf_xsd_pattern['product_pattern']."\r\n    ";
            $product_type =  ($product_info['type'] == "service")?"S":"P";
            $product_pattern_sub = $this->fill_xml_value($product_pattern_sub,"<ProductType>","</ProductType>",$product_type);
            $product_pattern_sub = $this->fill_xml_value($product_pattern_sub,"<ProductCode>","</ProductCode>",$product_info['code']);
            $product_category = get_row("tec_categories", array("id"=>$product_info['category_id']));
            $product_pattern_sub = $this->fill_xml_value($product_pattern_sub,"<ProductGroup>","</ProductGroup>",$product_category['name']);
            $product_pattern_sub = $this->fill_xml_value($product_pattern_sub,"<ProductDescription>","</ProductDescription>",$product_info['name']);
            $product_pattern_sub = $this->fill_xml_value($product_pattern_sub,"<ProductNumberCode>","</ProductNumberCode>",$product_info['code']);
            $product_pattern_sub = $this->fill_xml_value($product_pattern_sub,"<CustomsDetails>","</CustomsDetails>",$product_info['customsDetails']);
            $product_pattern .= $product_pattern_sub;
        }

        $taxtable_pattern = "";
        $tax_infos = get_rows("tec_tax");
        foreach ($tax_infos as $key => $tax_info) {
            $tax_pattern_sub = $saf_xsd_pattern['taxtable_pattern'];
            $tax_pattern_sub = $this->fill_xml_value($tax_pattern_sub,"<TaxType>","</TaxType>",trim($tax_info['tax_type']));
            $tax_pattern_sub = $this->fill_xml_value($tax_pattern_sub,"<TaxCountryRegion>","</TaxCountryRegion>","AO");
            $tax_pattern_sub = $this->fill_xml_value($tax_pattern_sub,"<TaxCode>","</TaxCode>",$tax_info['tax_code']);
            $tax_pattern_sub = $this->fill_xml_value($tax_pattern_sub,"<Description>","</Description>",$tax_info['reason']);
            $tax_pattern_sub = $this->fill_xml_value($tax_pattern_sub,"<TaxExpirationDate>","</TaxExpirationDate>",$tax_info['TaxExpirationDate']);
            if($tax_info['tax_type'] == "IS" && $tax_info['tax_code']!="ISE"){
                $tax_pattern_sub = str_replace("TaxPercentage", "TaxAmount", $tax_pattern_sub);
                $tax_pattern_sub = $this->fill_xml_value($tax_pattern_sub,"<TaxAmount>","</TaxAmount>",$tax_info['tax']);

            }  else {
                $tax_pattern_sub = $this->fill_xml_value($tax_pattern_sub,"<TaxPercentage>","</TaxPercentage>",$tax_info['tax']);
            }
            $taxtable_pattern .= $tax_pattern_sub;

        }
        $invoice_pattern = "";
        
        $sale_infos = get_rows("tec_sales",array("date>="=>$start_date, "date<="=>$end_date));
        // $sale_infos = get_rows("tec_sales");
        $sale_invoice_number = 0;
        $credit_total = 0;
        $debit_total = 0;
        foreach ($sale_infos as $key => $sale_info) {
            if($sale_info['InvoiceType'] == "FP") continue;
            $sale_invoice_number ++ ;
            // $total += $sale_info["grand_total"];
            $invoice_pattern_sub = "\r\n      <Invoice>".$saf_xsd_pattern['saleinvoice_pattern']."</Invoice>";
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<InvoiceNo>","</InvoiceNo>",$sale_info['InvoiceNo']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<InvoiceStatusDate>","</InvoiceStatusDate>",$sale_info['InvoiceStatusDate']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<Reason>","</Reason>",$sale_info['Reason']);
            $source_id = get_row("tec_users",array("id"=>$sale_info['created_by']));

            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<SourceID>","</SourceID>", $source_id['username']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<SourceBilling>","</SourceBilling>",$sale_info['SourceBilling']);
            
            // $hash_str = date("Y-m-d",strtotime($sale_info['date'])).";".$sale_info['date'].";".$sale_info['InvoiceNo'].";".str_replace(",", "", (number_format($sale_info['total'] + $sale_info['total_tax'],2)));
            // $hash_str =  base64_encode(hash("SHA1", $hash_str));

            // $hash_str = date("Y-m-d",strtotime($date)).";".date("Y-m-d",strtotime($date))."T".date("H:i:s",strtotime($date)).";".$this->input->post("invoice_type")." SIF".date("Y")."/".$invoice_number.";".str_replace(",","",number_format($grand_total,2)).";";

            // $sign_key = get_row("tec_signkey",array("id"=>1));
            // $privateKey=$sign_key['private'];
            // $publickey=$sign_key['public'];
            
            // openssl_public_encrypt($hash_str, $crypttext, $publickey);
            // $hash_str = base64_encode($crypttext);

            $hash_str = $sale_info['Hash'];
            
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<Hash>","</Hash>",$hash_str);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<HashControl>","</HashControl>",$sale_info['HashControl']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<Period>","</Period>",$sale_info['Period']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<InvoiceDate>","</InvoiceDate>",date("Y-m-d",strtotime($sale_info['date'])));
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<InvoiceType>","</InvoiceType>",$sale_info['InvoiceType']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<SelfBillingIndicator>","</SelfBillingIndicator>",$sale_info['SelfBillingIndicator']?$sale_info['SelfBillingIndicator']:"0");
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<CashVATSchemeIndicator>","</CashVATSchemeIndicator>",$sale_info['CashVATSchemeIndicator']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<ThirdPartiesBillingIndicator>","</ThirdPartiesBillingIndicator>",$sale_info['ThirdPartiesBillingIndicator']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<EACCode>","</EACCode>",$sale_info['EACCode']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<SystemEntryDate>","</SystemEntryDate>",$sale_info['InvoiceStatusDate']);
            // $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<TransactionID>","</TransactionID>",$sale_info['id']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<TransactionID>","</TransactionID>","");
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<CustomerID>","</CustomerID>",$sale_info['customer_id']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<CustomerID>","</CustomerID>",$sale_info['customer_id']);

            $customer_info = get_row("tec_customers",array("id"=>$sale_info['customer_id']));
            
            $sub_str = $this->get_string_between($invoice_pattern_sub,"<ShipTo>","</ShipTo>");
            $invoice_pattern_sub = str_replace($sub_str, "ShipTpPattern", $invoice_pattern_sub);
            $ship_to = $sub_str;
            
            $ship_from = $sub_str;
            $ship_to = $this->fill_xml_value($ship_to,"<DeliveryID>","</DeliveryID>",$customer_info['DeliveryID']);
            $ship_to = $this->fill_xml_value($ship_to,"<DeliveryDate>","</DeliveryDate>",$customer_info['DeliveryDate']);
            $shipToBuildingNum = trim($customer_info['numero']) !== '' ? $customer_info['numero'] : 'S/N';
            $ship_to = $this->fill_xml_value($ship_to,"<BuildingNumber>","</BuildingNumber>",$shipToBuildingNum);
            $ship_to = $this->fill_xml_value($ship_to,"<StreetName>","</StreetName>",$customer_info['bairro']);
            $ship_to = $this->fill_xml_value($ship_to,"<AddressDetail>","</AddressDetail>",$customer_info['bairro']);
            $ship_to = $this->fill_xml_value($ship_to,"<City>","</City>",$customer_info['cidade']);
            $ship_to = $this->fill_xml_value($ship_to,"<PostalCode>","</PostalCode>",$customer_info['postal_code']);
            $ship_to = $this->fill_xml_value($ship_to,"<Province>","</Province>",$customer_info['province']);
            $ship_to = $this->fill_xml_value($ship_to,"<Country>","</Country>","AO");
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<ShipTo>","</ShipTo>",$ship_to);
            $customer_info = get_row("tec_settings",array("setting_id"=>1));
            $ship_from = $this->fill_xml_value($ship_from,"<DeliveryID>","</DeliveryID>",$customer_info['DeliveryID']);
            $ship_from = $this->fill_xml_value($ship_from,"<DeliveryDate>","</DeliveryDate>",$customer_info['DeliveryDate']);
            $shipFromBuildingNum = trim($customer_info['BuildingNumber']) !== '' ? $customer_info['BuildingNumber'] : 'S/N';
            $ship_from = $this->fill_xml_value($ship_from,"<BuildingNumber>","</BuildingNumber>",$shipFromBuildingNum);
            $ship_from = $this->fill_xml_value($ship_from,"<StreetName>","</StreetName>",$customer_info['StreetName']);
            $ship_from = $this->fill_xml_value($ship_from,"<AddressDetail>","</AddressDetail>",$customer_info['AddressDetail']);
            $ship_from = $this->fill_xml_value($ship_from,"<City>","</City>",$customer_info['City']);
            $ship_from = $this->fill_xml_value($ship_from,"<PostalCode>","</PostalCode>",$customer_info['PostalCode']);
            $ship_from = $this->fill_xml_value($ship_from,"<Province>","</Province>",$customer_info['Province']);
            $ship_from = $this->fill_xml_value($ship_from,"<Country>","</Country>","AO");
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<ShipFrom>","</ShipFrom>",$ship_from);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<MovementEndTime>","</MovementEndTime>",$sale_info['MovementEndTime']);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<MovementStartTime>","</MovementStartTime>",$sale_info['MovementStartTime']);
            $sub_str = $this->get_string_include($invoice_pattern_sub,"<Line>","</Line>");
            $sale_item_infos = get_rows("tec_sale_items",array("sale_id"=>$sale_info['id']));
            $line_pattern = "";
            foreach ($sale_item_infos as  $sale_item_info) {
                $line_pattern_sub = $sub_str."\r\n        ";
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<LineNumber>","</LineNumber>",$sale_item_info['id']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<OriginatingON>","</OriginatingON>",$sale_info['id']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<OrderDate>","</OrderDate>",date("Y-m-d",strtotime($sale_info['date'])));

                $product_info = get_row("tec_products",array("id"=>$sale_item_info['product_id']));
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<ProductCode>","</ProductCode>",$product_info['code']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<ProductDescription>","</ProductDescription>",$product_info['name']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<Quantity>","</Quantity>",$sale_item_info['quantity']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<UnitOfMeasure>","</UnitOfMeasure>",$product_info['UnitOfMeasure']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<UnitPrice>","</UnitPrice>",$sale_item_info['net_unit_price']);
                // $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<UnitPrice>","</UnitPrice>",$sale_item_info['unit_price'] + $sale_item_info['unit_price']*14/100 );
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxBase>","</TaxBase>","");
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxPointDate>","</TaxPointDate>",date("Y-m-d",strtotime($sale_info['date'])));
                if($sale_info['InvoiceType'] == "NC"){
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<Reference>","</Reference>",$sale_info['OriginatingON']);
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<Reason>","</Reason>",$sale_info['Reason']);
                } else {
                    // Remover References para evitar erros de validação
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<References>","</References>","");
                }
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<Description>","</Description>",$product_info['name']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<ProductSerialNumber>","</ProductSerialNumber>",$sale_item_info['ProductSerialNumber']);
                if($sale_info['InvoiceType'] == "NC" || $sale_info['InvoiceStatus'] == "A")
                    $line_pattern_sub = str_replace("CreditAmount", "DebitAmount", $line_pattern_sub);
                else 
                    $line_pattern_sub = str_replace("DebitAmount", "CreditAmount", $line_pattern_sub);


                // $sub_total = $sale_item_info['total']*1;
                $sub_total = $sale_item_info['subtotal']*1 - $sale_item_info['item_tax'];

                if($sub_total == "" || $sub_total == 0)  $sub_total = "0.00";
                if($sale_info['InvoiceType'] == "NC" || $sale_info['InvoiceStatus'] == "A"){
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<DebitAmount>","</DebitAmount>",$sub_total);
                    $debit_total += $sub_total;

                }
                else {
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<CreditAmount>","</CreditAmount>",$sub_total);
                    $credit_total += $sub_total;
                }
                
                // $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<CreditAmount>","</CreditAmount>",$sale_item_info['net_unit_price']);

                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<SettlementAmount>","</SettlementAmount>",$sale_item_info['item_discount']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<CustomsInformation>","</CustomsInformation>",$sale_item_info['CustomsInformation']);
                $tax_info = get_row("tec_tax",array("id"=>$sale_item_info['tax_id']));
                if($tax_info['tax_type'] == "ISE") $tax_info['tax_type'] = "IS";
                if($tax_info['tax_type'] == "NS") $tax_info['tax_code'] = "NS";
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxType>","</TaxType>",$tax_info['tax_type']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxCountryRegion>","</TaxCountryRegion>","AO");
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxCode>","</TaxCode>",$tax_info['tax_code']);
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxPercentage>","</TaxPercentage>",$tax_info['tax']);
                if($tax_info['tax'] == 0){
                    $line_pattern_sub = str_replace("</Tax>","</Tax>\r\n          <TaxExemptionReason>".$tax_info['reason']."</TaxExemptionReason>\r\n          <TaxExemptionCode>".$tax_info['code']."</TaxExemptionCode>\r\n",$line_pattern_sub);

                }

                $line_pattern .= $line_pattern_sub;
            }
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<Line>","</Line>",$line_pattern);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<TaxPayable>","</TaxPayable>",$sale_info["total_tax"]);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<NetTotal>","</NetTotal>",$sale_info["total"]);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<GrossTotal>","</GrossTotal>",str_replace(",", "", (number_format($sale_info['total'] + $sale_info['total_tax'],2))) );

            // $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<GrossTotal>","</GrossTotal>",$sale_info["grand_total"]);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<Currency>","</Currency>",$sale_info["Currency"]);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<Settlement>","</Settlement>",$sale_info["Settlement"]);
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<PaymentMechanism>","</PaymentMechanism>","CC");
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<PaymentAmount>","</PaymentAmount>",str_replace(",", "", number_format($sale_info['grand_total'],2)));
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<PaymentDate>","</PaymentDate>",date("Y-m-d",strtotime($sale_info["date"])));
            $invoice_pattern_sub = $this->fill_xml_value($invoice_pattern_sub,"<WithholdingTax>","</WithholdingTax>","");
            $invoice_pattern .= $invoice_pattern_sub;

        }

        $purchaseinvoice_pattern = $saf_xsd_pattern['purchaseinvoice_pattern'];
        $p_invoice = "";
        $purchase_infos = get_rows("tec_purchases");
        $invoice_number = 0;
        foreach ($purchase_infos as $key => $purchase_info) {
            $invoice_number ++; 
            $p_invoice_sub = "\r\n      <Invoice>".$this->get_string_between($purchaseinvoice_pattern, "<Invoice>","</Invoice>")."</Invoice>";
            $invoice_no = "FT SIF".date("Y")."/".$purchase_info['id'];
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<InvoiceNo>","</InvoiceNo>",$invoice_no);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<Period>","</Period>",$purchase_info['Period']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<InvoiceDate>","</InvoiceDate>",$purchase_info['date']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<InvoiceType>","</InvoiceType>","FT");
            $supplier_info = get_row("tec_suppliers",array("id"=>$purchase_info['supplier_id']));
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<SourceID>","</SourceID>",$supplier_info['name']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<SupplierID>","</SupplierID>",$purchase_info['supplier_id']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<InputTax>","</InputTax>",$purchase_info['TaxPercentage']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<TaxPayable>","</TaxPayable>",$purchase_info['TaxPayable']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<NetTotal>","</NetTotal>",$purchase_info['NetTotal']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<GrossTotal>","</GrossTotal>",$purchase_info['total']);
            $p_invoice_sub = $this->fill_xml_value($p_invoice_sub,"<Currency>","</Currency>",$purchase_info['Currency']);
            $p_invoice .= $p_invoice_sub;
        }
        $purchaseinvoice_pattern = $this->fill_xml_value($purchaseinvoice_pattern,"<Invoice>","</Invoice>",$p_invoice);
        $purchaseinvoice_pattern = $this->fill_xml_value($purchaseinvoice_pattern,"<NumberOfEntries>","</NumberOfEntries>",$invoice_number);
 
        $payment_pattern = "";
        $payment_infos = get_rows("tec_payments",array("date>="=>$start_date, "date<="=>$end_date));
        $payment_number = 0;
        $payment_total = 0;
        foreach ($payment_infos as $key => $payment_info) {
            $payment_number ++;
            
            $sale_info = get_row("tec_sales",array("id"=>$payment_info['sale_id']));
            $payment_pattern_sub = "\r\n      <Payment>".$saf_xsd_pattern['payment_pattern']."</Payment>";
            // Normalizar PaymentRefNo: remover espaços duplicados e trim
            $paymentRefNo = preg_replace('/\s+/', ' ', trim($payment_info['InvoiceNo']));
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentRefNo>","</PaymentRefNo>", $paymentRefNo);

            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<Period>","</Period>","1");
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<TransactionID>","</TransactionID>",$payment_info['transaction_id']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<TransactionDate>","</TransactionDate>",date("Y-m-d",strtotime($payment_info['date'])));
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<Description>","</Description>",$payment_info['Description']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentType>","</PaymentType>",$payment_info['PaymentType']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<SystemID>","</SystemID>",$payment_info['SystemID']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentStatus>","</PaymentStatus>",$payment_info['PaymentStatus']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentStatusDate>","</PaymentStatusDate>",str_replace(" ","T",date("Y-m-d H:i:s",strtotime($payment_info['date']))));
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<Reason>","</Reason>",$payment_info['note']);
            
            $source_id = get_row("tec_users",array("id"=>$sale_info['created_by']));
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<SourceID>","</SourceID>", $source_id['username']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<SourcePayment>","</SourcePayment>",$payment_info['SourcePayment']);
            $paid_by = "";
            if($payment_info['paid_by'] == "cash") $paid_by = "NU"; else $paid_by = "TB";
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentMechanism>","</PaymentMechanism>",$paid_by);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentAmount>","</PaymentAmount>",$payment_info['amount']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentDate>","</PaymentDate>",date("Y-m-d", strtotime($payment_info['date'])));
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<PaymentAmount>","</PaymentAmount>",$payment_info['amount']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<SystemEntryDate>","</SystemEntryDate>",str_replace(" ","T",date("Y-m-d H:i:s",strtotime($payment_info['date']))));/* $sale_info['InvoiceStatusDate']); */
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<CustomerID>","</CustomerID>",$payment_info['customer_id']);
            

            $sub_str = $this->get_string_include($payment_pattern_sub,"<Line>","</Line>");
            $sale_item_infos = get_rows("tec_sale_items",array("sale_id"=>$sale_info['id']));
            $line_pattern = "";
            foreach ($sale_item_infos as  $sale_item_info) {
                $line_pattern_sub = $sub_str."\r\n        ";
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<LineNumber>","</LineNumber>",$sale_item_info['id']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<OriginatingON>","</OriginatingON>",$sale_info['id']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<InvoiceDate>","</InvoiceDate>",date("Y-m-d",strtotime($sale_info['date'])));

                $product_info = get_row("tec_products",array("id"=>$sale_item_info['product_id']));
                
                // $line_pattern_sub = str_replace("DebitAmount", "CreditAmount", $line_pattern_sub);
                
                if($sale_info['InvoiceType'] == "NC" || $sale_info['InvoiceStatus'] == "A")
                    $line_pattern_sub = str_replace("CreditAmount", "DebitAmount", $line_pattern_sub);
                else 
                    $line_pattern_sub = str_replace("DebitAmount", "CreditAmount", $line_pattern_sub);
                
                if($sale_info['InvoiceType'] == "NC" || $sale_info['InvoiceStatus'] == "A")
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<DebitAmount>","</DebitAmount>",str_replace(",","",$sale_item_info['net_unit_price'])*$sale_item_info['quantity']);
                else 
                    $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<CreditAmount>","</CreditAmount>",str_replace(",","",$sale_item_info['net_unit_price'])*$sale_item_info['quantity']);

                if($payment_info['PaymentStatus'] != "A")
                    $payment_total += str_replace(",","",$sale_item_info['net_unit_price'])*$sale_item_info['quantity'];
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<SettlementAmount>","</SettlementAmount>",$sale_item_info['subtotal']);
                $tax_info = get_row("tec_tax",array("id"=>$sale_item_info['tax_id']));
                
                if($tax_info['tax_type'] == "ISE") $tax_info['tax_type'] = "IS";
                if($tax_info['tax_type'] == "NS") $tax_info['tax_code'] = "NA";

                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxType>","</TaxType>",$tax_info['tax_type']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxCountryRegion>","</TaxCountryRegion>","AO");
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxCode>","</TaxCode>",$tax_info['tax_code']);
                $line_pattern_sub = $this->fill_xml_value($line_pattern_sub,"<TaxPercentage>","</TaxPercentage>",$tax_info['tax']);

                if($tax_info['tax'] == 0){
                    $line_pattern_sub = str_replace("</Tax>","</Tax>\r\n          <TaxExemptionReason>".$tax_info['reason']."</TaxExemptionReason>\r\n          <TaxExemptionCode>".$tax_info['code']."</TaxExemptionCode>\r\n",$line_pattern_sub);

                }

                $line_pattern .= $line_pattern_sub;
            }
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<TaxPayable>","</TaxPayable>",$sale_info['total_tax']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<NetTotal>","</NetTotal>",$sale_info['total']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<GrossTotal>","</GrossTotal>",str_replace(",", "", (number_format($sale_info['total'] + $sale_info['total_tax'],2))));
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<SettlementAmount>","</SettlementAmount>",$sale_info['paid']);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<Line>","</Line>",$line_pattern);
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<Currency>","</Currency>","");
            $payment_pattern_sub = $this->fill_xml_value($payment_pattern_sub,"<WithholdingTax>","</WithholdingTax>","");
            
            $payment_pattern.= $payment_pattern_sub;
        }
          

        $audit_pattern = $saf_xsd_pattern['audit_pattern'];
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<Header>","</Header>",$header_pattern);
        // $audit_pattern = $this->fill_xml_value($audit_pattern,"<GeneralLedgerAccounts>","</GeneralLedgerAccounts>",$account_pattern);
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<Customer>","</Customer>",$customer_pattern);
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<Supplier>","</Supplier>",$supplier_pattern);
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<Product>","</Product>",$product_pattern);
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<TaxTable>","</TaxTable>",$taxtable_pattern);
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<Payment>","</Payment>",$payment_pattern);

        $sale_invoice_pattern = $this->get_string_between($audit_pattern, "<SalesInvoices>","</SalesInvoices>");
        $sub_str = $sale_invoice_pattern;
        $sale_invoice_pattern = $this->fill_xml_value($sale_invoice_pattern,"<NumberOfEntries>","</NumberOfEntries>",$sale_invoice_number);
        if($debit_total == "" || $debit_total == 0) $debit_total = "0";
        $sale_invoice_pattern = $this->fill_xml_value($sale_invoice_pattern,"<TotalDebit>","</TotalDebit>",str_replace(",", "", (number_format($debit_total,2))));
        $sale_invoice_pattern = $this->fill_xml_value($sale_invoice_pattern,"<TotalCredit>","</TotalCredit>",str_replace(",", "", (number_format($credit_total,2))));
        $audit_pattern = str_replace($sub_str, $sale_invoice_pattern, $audit_pattern);
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<Invoice>","</Invoice>",$invoice_pattern);
        if($sale_invoice_number == 0)
            $audit_pattern = $this->fill_xml_value($audit_pattern,"<SalesInvoices>","</SalesInvoices>","");


        $payments_payment_pattern = $this->get_string_between($audit_pattern, "<Payments>","</Payments>");
        $sub_str = $payments_payment_pattern;
        $payments_payment_pattern = $this->fill_xml_value($payments_payment_pattern,"<NumberOfEntries>","</NumberOfEntries>",$payment_number);
        $payments_payment_pattern = $this->fill_xml_value($payments_payment_pattern,"<TotalDebit>","</TotalDebit>","0");
        $payments_payment_pattern = $this->fill_xml_value($payments_payment_pattern,"<TotalCredit>","</TotalCredit>",$payment_total);

        $audit_pattern = str_replace($sub_str, $payments_payment_pattern, $audit_pattern);

        if($payment_number == 0)
            $audit_pattern = $this->fill_xml_value($audit_pattern,"<Payments>","</Payments>","");

        $audit_pattern = $this->fill_xml_value($audit_pattern,"<PurchaseInvoices>","</PurchaseInvoices>","");
        // $audit_pattern = $this->fill_xml_value($audit_pattern,"<PurchaseInvoices>","</PurchaseInvoices>",$purchaseinvoice_pattern);
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<GeneralLedgerAccounts>","</GeneralLedgerAccounts>","");
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<GeneralLedgerEntries>","</GeneralLedgerEntries>","");
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<WorkingDocuments>","</WorkingDocuments>","");
        $audit_pattern = $this->fill_xml_value($audit_pattern,"<MovementOfGoods>","</MovementOfGoods>","");

        $audit_pattern = str_replace('xml version="1.0" encoding="utf-8"', 'xml version="1.0" encoding="UTF-8" standalone="yes"', $audit_pattern);
        $audit_pattern = str_replace('<AuditFile>', '<AuditFile xmlns="urn:OECD:StandardAuditFile-Tax:AO_1.01_01">', $audit_pattern);
        
        // Forçar 2 casas decimais nos montantes do XML
        $audit_pattern = $this->normalizeMoney2Decimals($audit_pattern);
file_put_contents("1.xml", $this->finalize_saft_xml($audit_pattern));

        $p_file = fopen("2.xml","w");
        if ($file = fopen("1.xml", "r")) {
            while(!feof($file)) {
                $line = fgets($file);
                if(strpos($line, "<") !== false) {
                    fwrite($p_file,$line);
                }
            }
            fclose($file);
        }
        fclose($p_file);       
        $file_name = time()."_SAF-T AO.xml";

        copy('2.xml', 'uploads/xml/'.$file_name);
        $this->session->set_flashdata('message', lang("products_added"));
        create_row("tec_saf_exports", array('file_name' => $file_name,'export_date' => $this->input->post("end_date"),'user_id' => $this->session->userdata('user_id')));
        redirect("settings/saf_xsd");
    }

    public function generate_licence(){
        if($this->session->userdata("settings")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if (!$this->Super_admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => '#', 'page' => lang('generate_licence')));
        $meta = array('page_title' => lang("generate_licence"), 'bc' => $bc);
        $this->data['settings'] = $this->site->getSettings();
        $this->page_construct('settings/generate_licence', $this->data, $meta);
    }

    public function generate(){

        // $expired_month = $this->input->post("expired_month");
        // $user_id = $this->input->post("user_id");
        // delete_row("tec_licences",array("user_id"=>$user_id));
        // $licence = strtotime(date("Y-m-d H:i:s"))."_".$user_id." ".$expired_month;
        // $licence = sha1($licence);
        // create_row("tec_licences", array("user_id"=>$user_id, "expired_month"=> base64_encode($expired_month), "licence"=> $licence));
        $CompanyName = $this->input->post("CompanyName");
        $nif = $this->input->post("nif");
        $expired_month = $this->input->post("expired_month");
        $status = $this->input->post("status");
        $version = $this->input->post("version");
        $url = $this->input->post("url");
        $licence_data = $CompanyName."^".$nif."^".$expired_month;
        $licence = hash("md5",$licence_data);
        $expired_month = base64_encode($expired_month);
        $license_id = $this->input->post("license_id");
        $change_data = array();
        $change_data["insert_date"] =date('Y-m-d');
        $change_data["status"] =$status;
        $change_data["CompanyName"] =$CompanyName;
        $change_data["url"] =$url;
        $change_data["TaxRegistrationNumber"] =$nif;
        $change_data["licence"] =$licence;
        $change_data["expired_month"] =$expired_month;
        $change_data["version"] =$version;
        

        if($license_id){
            $change_data["logged_ip"] =getHostByName(getHostName());
            update_row("tec_licences", $change_data,array('id' => $license_id));
        }else{
            create_row("tec_licences", $change_data);
        }
        $postParameter = array(
            'logged_ip' => $licence,
            'TaxRegistrationNumber'=>$this->input->post("expired_month")
        );
        if($url){
            $curlHandle = curl_init($url."/update_licence");
            curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
            curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
            
            $curlResponse = curl_exec($curlHandle);
            curl_close($curlHandle);
        }
      
        $data = array('CompanyName' => $CompanyName, 'TaxRegistrationNumber' => $nif, 'expired_month' => $expired_month,'licence' => $licence);
       /*  update_row('tec_licences', $data, array('setting_id' => 1)); */
        
        redirect("settings/generate_licence");
    }

    public function generate_up(){
        
        $CompanyName = $this->input->post("CompanyName");
        $TaxRegistrationNumber = $this->input->post("TaxRegistrationNumber");
        $expired_month = $this->input->post("expired_month");
        $license_id = $this->input->post("license_id");
        $licence_data = $CompanyName."^".$TaxRegistrationNumber."^".$expired_month;
        $licence = hash("md5",$licence_data);
        $expired_month = base64_encode($expired_month);
        $url = $this->input->post("url");
       $get_licenses = get_rows('tec_licences', array('id' => $license_id)); 
       
        foreach ($get_licenses as $key => $get_license) {
            $CompanyName = $get_license['Description'];
        }
        $postParameter = array(
            'logged_ip' => $licence,
            'TaxRegistrationNumber'=>$this->input->post("expired_month")
        );
        if($url){
            $curlHandle = curl_init($url."/update_licence");
            curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
            curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
            $curlResponse = curl_exec($curlHandle);
            curl_close($curlHandle);
        }
        $data = array('expired_month' => $expired_month,'licence' => $licence,'url' => $url, 'update_date' => date('Y-m-d H:i:s'));
        update_row('tec_licences', $data, array('id' => $license_id)); 
      
        redirect("settings/generate_licence");
    }

    public function sign_keys(){
        if($this->session->userdata("settings")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if (!$this->Super_admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("welcome");
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['sign_key'] = get_row("tec_signkey",array("id"=>1));
        $bc = array(array('link' => '#', 'page' => lang('Private & Public Key')));
        $meta = array('page_title' => lang("Private & Public Key"), 'bc' => $bc);
        $this->page_construct('settings/sign_keys', $this->data, $meta);
    }

    public function general_key(){
        $config = array(
        "digest_alg" => "sha1", /* sha512*/
        "private_key_bits" => 1024,
        "private_key_type" => OPENSSL_KEYTYPE_RSA,
        'x509_extensions' => 'v3_ca',
        'config' => 'C:/xampp/apache/conf/openssl.cnf'
        );
        $privateKey=openssl_pkey_new($config);

        openssl_pkey_export($privateKey, $privKey, null, [
            'config' => 'C:/xampp/apache/conf/openssl.cnf'
        ]);
         
        var_dump($privKey); // Just to test output
         
        $publickey=openssl_pkey_get_details($privateKey);
        $publickey=$publickey["key"];

        echo "<br/>Public Key <br/>".$publickey;

        delete_row("tec_signkey",array("id"=>1));
        create_row("tec_signkey",array("id"=>1, "public"=>$publickey,"private"=>$privKey));
        redirect("settings/sign_keys");
         
    }

    // === SAF-T Helpers (apenas normalização de montantes) ===
    private function m2($v){ return number_format((float)$v, 2, '.', ''); }

    private function normalizeMoney2Decimals($xml){
        return preg_replace_callback(
            '~<(TaxPayable|NetTotal|GrossTotal|CreditAmount|DebitAmount|UnitPrice|TaxAmount)>([^<]+)</\\1>~',
            function($m){
                $val = preg_replace('/[^0-9.\-]/','',$m[2]); // remove espaços, vírgulas etc.
                return '<'.$m[1].'>'.number_format((float)$val,2,'.','').'</'.$m[1].'>';
            },
            $xml
        );
    }
    


/**
 * Post-process SAF-T AO XML:
 * - Remove <TaxTable>...</TaxTable>
 * - Set <FiscalYear> to the year extracted from <StartDate>
 */
private function finalize_saft_xml($xmlString) {
    if (!is_string($xmlString) || $xmlString === '') return $xmlString;

    // Remove TaxTable block entirely
    $xmlString = preg_replace('~<TaxTable\b[^>]*>.*?</TaxTable>~s', '', $xmlString);

    // Extract StartDate (first occurrence in Header)
    if (preg_match('~<StartDate>(\d{4})-(\d{2})-(\d{2})</StartDate>~', $xmlString, $m)) {
        $fy = $m[1]; // year from StartDate
        // Replace or insert FiscalYear
        if (preg_match('~<FiscalYear>\d{4}</FiscalYear>~', $xmlString)) {
            $xmlString = preg_replace('~<FiscalYear>\d{4}</FiscalYear>~', '<FiscalYear>'.$fy.'</FiscalYear>', $xmlString, 1);
        } else {
            // insert after StartDate in Header
            $xmlString = preg_replace('~(<StartDate>\d{4}-\d{2}-\d{2}</StartDate>)~', '\\1<FiscalYear>'.$fy.'</FiscalYear>', $xmlString, 1);
        }
    }
    return $xmlString;
}

}
