<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Customers extends MY_Controller {

    function __construct() {
        parent::__construct();

        if (!$this->loggedIn) {
            redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('customers_model');
        $this->load->helper('database_helper');
    }

    function index() {

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('customers');
        $this->data['initial_date'] =$this->input->post('initial_date');
        $this->data['final_date'] = $this->input->post('final_date');
        $bc = array(array('link' => '#', 'page' => lang('customers')));
        $meta = array('page_title' => lang('customers'), 'bc' => $bc);
        $this->page_construct('customers/index', $this->data, $meta);
    }

    function get_customers() {       
        $this->load->library('datatables');
        
        if($this->input->get('initial_date') || $this->input->get('final_date')){
            $this->datatables
            ->select("tec_customers.id, tec_customers.name, tec_customers.phone,  tec_customers.email, tec_customers.cf1, tec_customers.endereco, tec_customers.cep, tec_customers.iva_cativo")
            ->from("sales");
            $this->datatables->join("tec_customers","tec_sales.customer_id=tec_customers.id");
            $this->datatables->where("tec_sales.InvoiceStatus!=","FP");
            $this->datatables->where("tec_sales.InvoiceType!=","NC");
            $this->datatables->where("tec_sales.mesa!=","NC");
            $initial_date= $this->input->get('initial_date');
            $final_date= $this->input->get('final_date');
            if($this->input->get('initial_date')){
                $this->datatables->where('date(tec_sales.date) >=', $this->input->get('initial_date'));
            }
            if($this->input->get('final_date')){
                $this->datatables->where('date(tec_sales.date) <=', $this->input->get('final_date'));
            }
            $customer_id = $this->input->get("customer_id") ? $this->input->get("customer_id") : NULL;
            if ($customer_id != NULL && $customer_id != "-1") {
                $this->datatables->where('tec_sales.customer_id', $customer_id);
            }
            $this->datatables->group_by("tec_customers.id");
            $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('customers/edit/$1') . "' class='edit_customer tip btn btn-warning btn-xs' title='" . $this->lang->line("edit_customer") . "'><i class='fa fa-edit'></i></a> <a href='" . site_url('customers/delete/$1') . "' onClick=\"return confirm('" . $this->lang->line('alert_x_customer') . "')\" class='tip btn btn-danger btn-xs' title='" . $this->lang->line("delete_customer") . "'><i class='fa fa-trash-o'></i></a><a href='" . site_url('customers/print_client/$1/$2/$3') . "' class='print_customer tip btn btn-success btn-xs' title='" . $this->lang->line("Conta Corrente") . "' target='blank'><i class='fa fa-print'></i></a></div></div>", "tec_customers.id, $initial_date, $final_date");
            $this->datatables->unset_column('tec_customers.id');
    
            echo $this->datatables->generate();
        }else{
            $this->datatables
            ->select("id, name, phone,  email, cf1, endereco, cep, iva_cativo")
            ->from("customers");
            $customer_id = $this->input->get("customer_id") ? $this->input->get("customer_id") : NULL;
            if ($customer_id != NULL && $customer_id != "-1") {
                $this->datatables->where('id', $customer_id);
            }
            $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('customers/edit/$1') . "' class='edit_customer tip btn btn-warning btn-xs' title='" . $this->lang->line("edit_customer") . "'><i class='fa fa-edit'></i></a> <a href='" . site_url('customers/delete/$1') . "' onClick=\"return confirm('" . $this->lang->line('alert_x_customer') . "')\" class='tip btn btn-danger btn-xs' title='" . $this->lang->line("delete_customer") . "'><i class='fa fa-trash-o'></i></a><a href='" . site_url('customers/print_client/$1') . "' class='print_customer tip btn btn-success btn-xs' title='" . $this->lang->line("Conta Corrente") . "' target='blank'><i class='fa fa-print'></i></a></div></div>", "id");
            $this->datatables->unset_column('id');
    
            echo $this->datatables->generate();
        }
       
      
    }

    function print_client($id, $initial_date = null, $final_date = null) {        
        $this->data['customer'] = $this->customers_model->getCustomerByID($id);
      //  $this->data['alldata'] = $this->customers_model->getclientdata($id);

       $this->data['alldata'] = $this->customers_model->getSaleDataById($id, $initial_date, $final_date);
        $this->data['page_title'] = lang('customers');
        $this->load->view($this->theme . 'customers/print_clients', $this->data);
    }

    function print_all_clients() {
        $initial_date = $this->input->post('initial_date') ? $this->input->post('initial_date') : null;
        $final_date = $this->input->post('final_date') ? $this->input->post('final_date') : null;        
        $this->data['alldata'] = $this->customers_model->getAllClientData($initial_date,$final_date);
        $this->data['page_title'] = lang('customers');
        $this->load->view($this->theme . 'customers/print_all_clients', $this->data);
    }

    function add() {
        $this->load->helper("database_helper");
        $this->form_validation->set_rules('name', $this->lang->line("name"), 'required');
        $this->form_validation->set_rules('cf1', $this->lang->line("cf1"), 'required');
        $this->form_validation->set_rules('bairro', $this->lang->line("Morada"), 'required');
        $this->form_validation->set_rules('Country', $this->lang->line("País"), 'required');

        if ($this->form_validation->run() == true) {
           

            $data = array('name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'cf1' => $this->input->post('cf1'),
                'endereco' => $this->input->post('bairro'),
                'numero' => $this->input->post('numero'),
                'bairro' => $this->input->post('bairro'),
                'cidade' => $this->input->post('cidade'),
                'estado' => $this->input->post('estado'),
                'data' => date("Y-m-d"),
                'AccountID' => 0,
                'Country' => $this->input->post('Country'),
                'complemento' => $this->input->post('bairro'),
                'cep' => $this->input->post('ret'),
                 'iva_cativo' => $this->input->post('iva'),
            );

            // print_r($data);
            // exit;
        }
        $exist_nif = $this->customers_model->getCustomerByCf1($this->input->post('cf1'));
        if($exist_nif){
            if ($this->input->is_ajax_request()) {
                echo json_encode(array('status' => 'failed', 'msg' =>"Este NIF já está a ser utilizado por outro cliente."));
                die();
            }
            $this->data['error'] = "Este NIF já está a ser utilizado por outro cliente.";
            $this->data['page_title'] = lang('add_customer');
            $bc = array(array('link' => site_url('customers'), 'page' => lang('customers')), array('link' => '#', 'page' => lang('add_customer')));
            $meta = array('page_title' => lang('add_customer'), 'bc' => $bc);
            $this->page_construct('customers/add', $this->data, $meta);
        }else{
            if ($this->form_validation->run() == true && $cid = $this->customers_model->addCustomer($data)) {
                if ($this->input->is_ajax_request()) {
                    echo json_encode(array('status' => 'success', 'msg' => $this->lang->line("customer_added"), 'id' => $cid, 'val' => $data['name']));
                    die();
                }
                $this->session->set_flashdata('message', $this->lang->line("customer_added"));
                redirect("customers");
            } else {
                if ($this->input->is_ajax_request()) {
                    echo json_encode(array('status' => 'failed', 'msg' => validation_errors()));
                    die();
                }
    
                $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
                $this->data['page_title'] = lang('add_customer');
                $bc = array(array('link' => site_url('customers'), 'page' => lang('customers')), array('link' => '#', 'page' => lang('add_customer')));
                $meta = array('page_title' => lang('add_customer'), 'bc' => $bc);
                $this->page_construct('customers/add', $this->data, $meta);
            }
        }

        
    }

    function cf1_validate(){
        $exist_nif = $this->customers_model->getCustomerByCf1($this->input->post('cf1'));
        if($exist_nif){
            echo json_encode(array('status' => 'failed', 'msg' =>"Este NIF já está a ser utilizado por outro cliente."));
            die();
        }else{
            echo json_encode(array('status' => 'success'));
            die();
        }
       
    }
    function edit($id = NULL) {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', $this->lang->line('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id', TRUE);
        }

        $this->form_validation->set_rules('name', $this->lang->line("name"), 'required');


        if ($this->form_validation->run() == true) {

            $data = array('name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'cf1' => $this->input->post('cf1'),
                'endereco' => $this->input->post('bairro'),
                'numero' => $this->input->post('numero'),
                'bairro' => $this->input->post('bairro'),
                'cidade' => $this->input->post('cidade'),
                'estado' => $this->input->post('estado'),
                'data' => date("Y-m-d"),
                'AccountID' => 0,
                'Country' => $this->input->post('Country'),
                'complemento' => $this->input->post('bairro'),
                'cep' => $this->input->post('ret'),
            );
        }

        if ($this->form_validation->run() == true && $this->customers_model->updateCustomer($id, $data)) {

            $this->session->set_flashdata('message', $this->lang->line("customer_updated"));
            redirect("customers");
        } else {

            $this->data['customer'] = $this->customers_model->getCustomerByID($id);
            $cf1 = $this->data['customer']->cf1;
            $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
            $this->data['page_title'] = lang('edit_customer');
            $bc = array(array('link' => site_url('customers'), 'page' => lang('customers')), array('link' => '#', 'page' => lang('edit_customer')));
            $meta = array('page_title' => lang('edit_customer'), 'bc' => $bc);
            $this->data['edit_nif'] = "yes";
            $this->load->helper("database_helper");
            // $rows = get_rows("tec_sales",array("customer_id"=>$id));
            // if(strpos($cf1, "999999999") === false && strlen($cf1) > 3 && count($rows) == 0)
            // 	$this->data['edit_nif'] = "no";
            if (strpos($cf1, "999999999") === false && strlen($cf1) > 3)
                $this->data['edit_nif'] = "no";

            $this->page_construct('customers/edit', $this->data, $meta);
        }
    }

    function delete($id = NULL) {
        if (DEMO) {
            $this->session->set_flashdata('error', $this->lang->line("disabled_in_demo"));
            redirect('pos');
        }

        if ($this->input->get('id')) {
            $id = $this->input->get('id', TRUE);
        }

        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang("access_denied"));
            redirect('pos');
        }
        if ($this->customers_model->isCustomerInSales($id)) {
            $this->session->set_flashdata('error', "Lamento! mas não pode eliminar clientes com movimetos.");
            redirect("customers");
        }

        if ($this->customers_model->deleteCustomer($id)) {
            $this->session->set_flashdata('message', lang("customer_deleted"));
            redirect("customers");
        }
    }

}
