# SISTEMA DE PROTEÇÃO DE INTEGRIDADE - SIFPOS
## Proteção contra modificação não autorizada

### 📋 O QUE FOI IMPLEMENTADO

O sistema agora possui **4 camadas de proteção**:

#### 1. **Verificação de Hash MD5**
- Arquivos críticos têm seus hashes armazenados em `.system_integrity`
- A cada requisição, o sistema verifica se os arquivos foram modificados
- Se detectar alteração, bloqueia o sistema com erro 503

#### 2. **Verificação de Função**
- Valida que a função `verify_remote_license()` existe
- Valida que a chamada `$this->verify_remote_license()` está presente
- Detecta se alguém comentou ou removeu o código de verificação

#### 3. **Proteção de Arquivos**
- `.htaccess` protege logs e arquivos sensíveis
- Arquivo `.system_integrity` bloqueado via HTTP
- Logs não acessíveis via navegador

#### 4. **Log de Segurança**
- Qualquer tentativa de adulteração é registrada
- Arquivo: `logs/security_alert.log`
- Inclui timestamp, IP e arquivo modificado


### 🔧 COMO USAR

#### Após instalação inicial:
```bash
cd c:\xampp5\htdocs\wpv_modelo
php update_integrity.php
```
Digite `s` quando solicitado. Isso cria o arquivo `.system_integrity` com os hashes iniciais.

#### Quando fizer modificações AUTORIZADAS em Auth.php:
1. Faça suas alterações
2. Execute novamente:
```bash
php update_integrity.php
```
3. Digite `s` para atualizar os hashes

**IMPORTANTE:** Se não atualizar os hashes, o sistema bloqueará na próxima requisição!


### ⚠️ ARQUIVOS PROTEGIDOS

- `app/controllers/Auth.php` - Controlador de autenticação e licença
- `app/core/Security_check.php` - Sistema de verificação de integridade
- `app/core/MY_Controller.php` - Executa verificação em TODAS as páginas


### 🔐 COMO FUNCIONA

1. **Primeiro acesso**: Cria arquivo `.system_integrity` com hashes
2. **Cada requisição**: 
   - MY_Controller carrega Security_check
   - Verifica MD5 dos arquivos protegidos
   - Verifica se função de licença existe
   - Se tudo OK, permite execução
   - Se detectar modificação, retorna erro 503

3. **Tentativa de burla**:
   - Se alguém remover `verify_remote_license()` → Sistema bloqueia
   - Se alguém comentar a chamada no login → Sistema bloqueia
   - Se alguém modificar Auth.php → Hash não bate, sistema bloqueia
   - Se alguém modificar Security_check.php → Hash não bate, sistema bloqueia


### 🛡️ CENÁRIOS DE PROTEÇÃO

❌ **Tentativa 1**: Remover função `verify_remote_license()`
- **Resultado**: `verify_license_function_exists()` detecta e bloqueia

❌ **Tentativa 2**: Comentar `$this->verify_remote_license()`
- **Resultado**: `verify_license_function_exists()` detecta e bloqueia

❌ **Tentativa 3**: Modificar Auth.php para sempre retornar true
- **Resultado**: Hash MD5 diferente, sistema bloqueia

❌ **Tentativa 4**: Modificar Security_check.php para desabilitar verificação
- **Resultado**: Hash MD5 diferente, sistema bloqueia

❌ **Tentativa 5**: Comentar verificação no MY_Controller
- **Resultado**: MY_Controller não está na lista de protegidos, mas ao comentar, o próprio Security_check.php detecta via hash


### 📊 LOGS E MONITORAMENTO

**Verificações de licença**: `logs/license_checks.log`
```
[2026-01-11 14:30:00] NIF=5000930091 HTTP=200 RAW={"licence":"ABC123"...}
```

**Alertas de licença**: `logs/license_alerts.log`
```
[2026-01-11 14:30:00] LICENÇA EXPIRADA! NIF: 5000930091 - Expirou em: 2025-12-31
```

**Alertas de segurança**: `logs/security_alert.log`
```
[2026-01-11 14:30:00] SECURITY ALERT: File tampering detected - app/controllers/Auth.php | IP: 192.168.1.100
```


### 🔑 CHAVE DE SEGURANÇA

A chave de atualização é gerada dinamicamente:
```php
'sifpos_2026_secure_' . md5('wpv_modelo')
```

**Para máxima segurança**, altere o valor em:
- `app/core/Security_check.php` linha 55
- `update_integrity.php` linha 13

Use um valor secreto único por instalação.


### 📝 MANUTENÇÃO

**Verificar logs de segurança**:
```bash
type logs\security_alert.log
```

**Verificar última verificação de licença**:
```bash
type logs\license_checks.log | Select-Object -Last 5
```

**Ver arquivo de integridade** (codificado):
```bash
type .system_integrity
```


### 🚨 EM CASO DE BLOQUEIO LEGÍTIMO

Se você fez modificações legítimas mas esqueceu de atualizar os hashes:

1. Execute: `php update_integrity.php`
2. Digite `s` para confirmar
3. O sistema voltará a funcionar normalmente

**NUNCA delete** o arquivo `.system_integrity` em produção - isso desabilita a proteção!


### 🎯 RESUMO

✅ **Protegido contra**:
- Remoção de código de verificação de licença
- Modificação de lógica de validação
- Comentar chamadas críticas
- Edição manual de arquivos protegidos

✅ **Fácil manutenção**:
- Script simples para atualizar após mudanças legítimas
- Logs detalhados de todas as tentativas
- Mensagem clara quando bloqueado

✅ **Performance**:
- Verificação rápida (apenas MD5 de 2 arquivos)
- Cache de hash em arquivo
- Impacto mínimo no tempo de resposta

