<?php
// saft_validator.php
if (PHP_SAPI !== 'cli') { header('Content-Type: application/json; charset=utf-8'); }
$xmlPath = $argv[1] ?? ($_GET['xml'] ?? '');
$xsdPath = $argv[2] ?? ($_GET['xsd'] ?? '');
if (!$xmlPath || !$xsdPath) {
    $out = array('ok'=>false, 'errors'=>array('Indique xml e xsd: php saft_validator.php ficheiro.xml XSD.xml'));
    echo json_encode($out, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE); exit(1);
}
libxml_use_internal_errors(true);
$doc = new DOMDocument();
$doc->load($xmlPath);
$schemaOk = $doc->schemaValidate($xsdPath);
$errors = array();
if (!$schemaOk) {
    foreach (libxml_get_errors() as $err) { $errors[] = trim($err->message).' @ line '.$err->line; }
}
libxml_clear_errors();
$xp = new DOMXPath($doc);
$xp->registerNamespace('ns','urn:OECD:StandardAuditFile-Tax:AO_1.01_01');
foreach ($xp->query('//ns:SourceDocuments//ns:Line') as $line) {
    $taxPct = $xp->evaluate('number(.//ns:TaxPercentage)', $line);
    $taxCode = $xp->evaluate('string(.//ns:TaxCode)', $line);
    if ($taxPct == 0 || in_array($taxCode, array('ISE','NS','OUT'))) {
        $hasCode = $xp->evaluate('string(.//ns:TaxExemptionCode)', $line) !== '';
        $hasReason = $xp->evaluate('string(.//ns:TaxExemptionReason)', $line) !== '';
        if (!($hasCode && $hasReason)) {
            $ln = $xp->evaluate('string(ns:LineNumber)', $line);
            $errors[] = "Linha {$ln}: falta TaxExemptionCode/Reason quando TaxPercentage=0 ou TaxCode in (ISE/NS/OUT).";
        }
    }
}
$badCodes = $xp->query('//ns:TaxTable/ns:TaxTableEntry[not(ns:TaxCode="NOR" or ns:TaxCode="ISE" or ns:TaxCode="OUT" or ns:TaxCode="NS")]');
if ($badCodes->length > 0) $errors[] = "TaxTable contém códigos fora do padrão (NOR/ISE/OUT/NS).";
$badNor = $xp->query('//ns:TaxTable/ns:TaxTableEntry[ns:TaxCode="NOR" and ns:TaxPercentage!=14]');
if ($badNor->length > 0) $errors[] = "TaxTable: NOR deve ter TaxPercentage=14.";
$out = array('ok'=>count($errors)===0, 'errors'=>$errors);
echo json_encode($out, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);