<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends MY_Controller
{

    function __construct() {
        parent::__construct();


        if ( ! $this->loggedIn) {
            redirect('login');
        }

        if ( ! $this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->load->model('reports_model');
        $this->load->model('purchases_model');
        $this->load->helper("database_helper");
    }

    function daily_sales($year = NULL, $month = NULL)
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if (!$year) { $year = date('Y'); }
        if (!$month) { $month = date('m'); }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->lang->load('calendar');
        $config = array(
            'show_next_prev' => TRUE,
            'next_prev_url' => site_url('reports/daily_sales'),
            'month_type' => 'long',
            'day_type' => 'long'
            );
        $config['template'] = '

        {table_open}<table border="0" cellpadding="0" cellspacing="0" class="table table-bordered" style="min-width:522px;">{/table_open}

        {heading_row_start}<tr class="active">{/heading_row_start}

        {heading_previous_cell}<th><div class="text-center"><a href="{previous_url}">&lt;&lt;</div></a></th>{/heading_previous_cell}
        {heading_title_cell}<th colspan="{colspan}"><div class="text-center">{heading}</div></th>{/heading_title_cell}
        {heading_next_cell}<th><div class="text-center"><a href="{next_url}">&gt;&gt;</a></div></th>{/heading_next_cell}

        {heading_row_end}</tr>{/heading_row_end}

        {week_row_start}<tr>{/week_row_start}
        {week_day_cell}<td class="cl_equal"><div class="cl_wday">{week_day}</div></td>{/week_day_cell}
        {week_row_end}</tr>{/week_row_end}

        {cal_row_start}<tr>{/cal_row_start}
        {cal_cell_start}<td>{/cal_cell_start}

        {cal_cell_content}<div class="cl_left">{day}</div><div class="cl_right">{content}</div>{/cal_cell_content}
        {cal_cell_content_today}<div class="cl_left highlight">{day}</div><div class="cl_right">{content}</div>{/cal_cell_content_today}

        {cal_cell_no_content}{day}{/cal_cell_no_content}
        {cal_cell_no_content_today}<div class="highlight">{day}</div>{/cal_cell_no_content_today}

        {cal_cell_blank}&nbsp;{/cal_cell_blank}

        {cal_cell_end}</td>{/cal_cell_end}
        {cal_row_end}</tr>{/cal_row_end}

        {table_close}</table>{/table_close}
        ';

        $this->load->library('calendar', $config);

        $sales = $this->reports_model->getDailySales($year, $month);

        if(!empty($sales)) {
            foreach($sales as $sale){
                $daily_sale[$sale->date] = "<span class='text-warning'>".number_format($sale->tax,2)."</span><br>".number_format($sale->discount,2)."<br><span class='text-success'>".number_format($sale->total,2)."</span><br><span style='border-top:1px solid #DDD;'>".number_format($sale->grand_total,2)."</span>";
            }
        } else {
            $daily_sale = array();
        }

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['calender'] = $this->calendar->generate($year, $month, $daily_sale);

        $start = $year.'-'.$month.'-01 00:00:00';
        $end = $year.'-'.$month.'-'.days_in_month($month, $year).' 23:59:59';
        $this->data['total_purchases'] = $this->reports_model->getTotalPurchases($start, $end);
        $this->data['total_sales'] = $this->reports_model->getTotalSales($start, $end);
        $this->data['total_expenses'] = $this->reports_model->getTotalExpenses($start, $end);

        $this->data['page_title'] = $this->lang->line("daily_sales");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('daily_sales')));
        $meta = array('page_title' => lang('daily_sales'), 'bc' => $bc);
        $this->page_construct('reports/daily', $this->data, $meta);

    }


    function monthly_sales($year = NULL)
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if(!$year) { $year = date('Y'); }
        $this->lang->load('calendar');
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $start = $year.'-01-01 00:00:00';
        $end = $year.'-12-31 23:59:59';
        $this->data['total_purchases'] = $this->reports_model->getTotalPurchases($start, $end);
        $this->data['total_sales'] = $this->reports_model->getTotalSales($start, $end);
        $this->data['total_expenses'] = $this->reports_model->getTotalExpenses($start, $end);
        $this->data['year'] = $year;
        $this->data['sales'] = $this->reports_model->getMonthlySales($year);
        $this->data['page_title'] = $this->lang->line("monthly_sales");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('monthly_sales')));
        $meta = array('page_title' => lang('monthly_sales'), 'bc' => $bc);
        $this->page_construct('reports/monthly', $this->data, $meta);
    }

    function index()
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
        if($this->input->post('customer')) {
            
            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
            $user = $_POST['user'] ? $_POST['user'] : NULL;
            $this->data['total_sales'] = $this->reports_model->getTotalSalesforCustomer($this->input->post('customer'), $user, $start_date, $end_date);
            $this->data['total_sales_value'] = $this->reports_model->getTotalSalesValueforCustomer($this->input->post('customer'), $user, $start_date, $end_date);
        }
        
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("sales_report");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('sales_report')));
        $meta = array('page_title' => lang('sales_report'), 'bc' => $bc);
        $this->page_construct('reports/sales', $this->data, $meta);
    }

     function invoices()
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        if($_POST) {
            
            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') :  date('Y-m-d 00:00:00');
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : date('Y-m-d 23:59:00');
            $user = $_POST['user'] ? $_POST['user'] : NULL;
            $InvoiceType = $this->input->post('invoice_type') ? $this->input->post('useinvoice_typer') : NULL;
            $product_id = $_POST['products'] ? $_POST['products'] : NULL;
            $this->data['total_sales'] = $this->reports_model->getTotalSalesforCustomer($this->input->post('customer'), $user, $start_date, $end_date, $InvoiceType);
            $this->data['total_sales_value'] = $this->reports_model->getTotalSalesValueforCustomer($this->input->post('customer'), $user, $start_date, $end_date, $InvoiceType);
        }
        
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("invoice_report");
        $bc = array(array('link' => '#', 'page' => lang('invoice_report')), array('link' => '#', 'page' => lang('invoice_report')));
        $meta = array('page_title' => lang('invoice_report'), 'bc' => $bc);
        $this->page_construct('reports/invoice_reports', $this->data, $meta);
    }


    function print_report() {
        $where = array();
        $where_in = array();
        $user = $_POST['user'] ? $_POST['user'] : NULL;
        $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : date('Y-m-d 00:00:00');
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : date('Y-m-d 23:59:00');
        $products = $_POST['products'] ? $_POST['products'] : NULL;
        $invoice_type = $this->input->post('invoice_type') ? $this->input->post('invoice_type') : NULL;
        // if($start_date!=NULL) array_push($where, array("date>="=>$start_date));
        // if($end_date!=NULL) array_push($where, array("date<="=>$end_date));
        if ($start_date != NULL)
            $where["tec_sales.date>="] = $start_date;
        if ($end_date != NULL)
            $where["tec_sales.date<="] = $end_date;
        if ($user != NULL)
            $where_in['tec_sales.created_by'] = $user;
        if ($invoice_type != NULL)
            $where['tec_sales.InvoiceType'] = $invoice_type;
            $where['tec_sales.InvoiceStatus!='] = "A";
            $where['tec_sales.InvoiceType<>'] = "NC";
            $where['tec_sales.InvoiceType!='] = "FP";
            $where['tec_sales.mesa<>'] = "NC";

         $sales = get_rows_join("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount", $where_in, array(array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")));
        if ($products != NULL) {
            $where_in['tec_sale_items.product_id'] = $products;
            $sales = get_rows_join("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount", $where_in, array(array("table" => "tec_sale_items", "where" => "tec_sale_items.sale_id=tec_sales.id"), array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")));
        }
        // var_dump($sales);
        $this->load->view($this->theme . 'reports/print_sales', array("sale_data" => $sales,"assets"=>$this->data["assets"], "start_date" => $start_date, "end_date" => $end_date));
    }

  /*   function print_sale(){
        $where = array();
        $where_in =  array();
        $user = $_POST['user'] ? $_POST['user'] : NULL;
        $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : date('Y-m-d 00:00:00');
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : date('Y-m-d 23:59:00');
        $products = $_POST['products'] ? $_POST['products'] : NULL;
        $invoice_type = $this->input->post('invoice_type') ? $this->input->post('invoice_type') : NULL;
        
        if($start_date!=NULL) $where["tec_sales.date>="] = $start_date;
        if($end_date!=NULL) $where["tec_sales.date<="] = $end_date;
        if($user!=NULL) $where_in['tec_sales.created_by'] = $user;
        if($invoice_type!=NULL) $where['tec_sales.InvoiceType'] = $invoice_type;
        $where['tec_sales.InvoiceStatus!='] = "A";
        $where['tec_sales.InvoiceType<>'] = "NC";
        $where['tec_sales.InvoiceType!='] = "FP";
        $where['tec_sales.mesa<>'] = "NC";

        $sales = get_rows_join("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount, tec_payments.date as payment_date", $where_in, array(array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")));
        
        if($products != NULL){
            $where_in['tec_sale_items.product_id'] = $products;
            $sales = get_rows_join("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount, tec_payments.date as payment_date", $where_in, array(array("table" => "tec_sale_items", "where" => "tec_sale_items.sale_id=tec_sales.id"), array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")));
        }


        $retrun_data = array();
        $sales_ids = array();
        foreach($sales as $obj){
            $taxes =  $this->reports_model->get_sale_group_tax($obj["id"], $products); 
            $obj["taxes"] = $taxes;
            $retrun_data[] = $obj;
            $sales_ids[]= $obj["id"];
        }
        $sales_taxs = $this->reports_model->get_total_sale_group_tax($sales_ids); 
        $this->load->view($this->theme . 'reports/print_sale_report', array("sale_data"=>$retrun_data,"sales_taxs"=>$sales_taxs,"start_date"=>$start_date,"end_date"=>$end_date,"assets"=>$this->data["assets"]));

    } */
function print_sale(){
        $where = array();
        $where_in =  array();
        $user = $_POST['user'] ? $_POST['user'] : NULL;
        $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : date('Y-m-d 00:00:00');
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : date('Y-m-d 23:59:00');
        $products = $_POST['products'] ? $_POST['products'] : NULL;
        $invoice_type = $this->input->post('invoice_type') ? $this->input->post('invoice_type') : NULL;
        
        if($start_date!=NULL) $where["tec_sales.date>="] = $start_date;
        if($end_date!=NULL) $where["tec_sales.date<="] = $end_date;
        if($user!=NULL) $where_in['tec_sales.created_by'] = $user;
        if($invoice_type!=NULL) $where['tec_sales.InvoiceType'] = $invoice_type;

        $where['tec_sales.InvoiceStatus!='] = "A";
        $where['tec_sales.InvoiceType<>'] = "NC";
        $where['tec_sales.InvoiceType!='] = "FP";
        $where['tec_sales.mesa<>'] = "NC";

        $sales_group = get_rows_join_group("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount, tec_payments.date as payment_date", $where_in, array(array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")), "id");
        $sales = get_rows_join("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount, tec_payments.date as payment_date", $where_in, array(array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")));
        if($products != NULL){
            $where_in['tec_sale_items.product_id'] = $products;
            $sales_group = get_rows_join_group("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount, tec_payments.date as payment_date", $where_in, array(array("table" => "tec_sale_items", "where" => "tec_sale_items.sale_id=tec_sales.id"), array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")), "id");
            $sales = get_rows_join("tec_sales", $where, " created_by ASC, tec_sales.date DESC", array(), "tec_sales.*, tec_payments.paid_by, tec_payments.amount as payment_amount, tec_payments.date as payment_date", $where_in, array(array("table" => "tec_sale_items", "where" => "tec_sale_items.sale_id=tec_sales.id"), array("table" => "tec_payments", "where" => "tec_payments.sale_id=tec_sales.id")));

        }
        $retrun_data = array();
        $sales_ids = array();
        foreach($sales_group as $obj){
            $taxes =  $this->reports_model->get_sale_group_tax($obj["id"], $products); 
            $obj["taxes"] = $taxes;
            $retrun_data[] = $obj;
            $sales_ids[]= $obj["id"];
        }
        $sales_taxs = $this->reports_model->get_total_sale_group_tax($sales_ids); 
        $this->load->view($this->theme . 'reports/print_sale_report', array("sale_group_data"=>$retrun_data,"sale_data"=>$sales,"sales_taxs"=>$sales_taxs,"start_date"=>$start_date,"end_date"=>$end_date,"assets"=>$this->data["assets"]));

    }

    function print_payments(){
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $ref = $this->input->get('payment_ref') ? $this->input->get('payment_ref') : NULL;
        $sale_id = $this->input->get('sale_no') ? $this->input->get('sale_no') : NULL;
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $paid_by = $this->input->get('paid_by') ? $this->input->get('paid_by') : NULL;
        $start_date = $this->input->get('start_date1') ? $this->input->get('start_date1') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;

        // $this->datatables
        // ->select($this->db->dbprefix('payments') . ".date, " . $this->db->dbprefix('payments') . ".reference as ref, " . $this->db->dbprefix('sales') . ".id as sale_no, paid_by, amount")
        // ->from('payments')
        // ->join('sales', 'payments.sale_id=sales.id', 'left')
        // ->group_by('payments.id');
        $where_in = array();

        $where = array();
        if ($user) {
            $where['tec_payments.created_by'] = $user;
        }
        if ($ref) {
            $where['tec_payments.reference'] = $ref;

        }
        if ($paid_by) {
            $where['tec_payments.paid_by'] = $paid_by;
        }
        if ($sale_id) {
            $where['tec_sales.id'] = $sale_id;

        }
        if ($customer) {
            $where['tec_sales.customer_id'] = $customer;

        }
 
        if($start_date!=NULL) $where["tec_payments.date>="] = $start_date;
        if($end_date!=NULL) $where["tec_payments.date<="] = $end_date;
        $payments = get_rows_join("tec_payments",$where," tec_payments.created_by ASC, tec_payments.date DESC",array(), "tec_payments.*, tec_sales.id as sale_id",   $where_in,array(array("table"=>"tec_sales","where"=>"tec_payments.sale_id=tec_sales.id")));
        $this->load->view($this->theme . 'reports/print_payments', array("payments"=>$payments,"start_date"=>$start_date,"end_date"=>$end_date));
    }
    function print_invoices(){   
        $user = $_POST['user'] ? $_POST['user'] : NULL;
        $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
        $products = $_POST['products'] ? $_POST['products'] : NULL;
        $invoice_type = $this->input->post('invoice_type') ? $this->input->post('invoice_type') : NULL;
        $customer = $this->input->post('customer') ? $this->input->post('customer') : NULL;
        $invoices_data = $this->reports_model->getfilterinvoice($customer, $user, $start_date, $end_date, $products, $invoice_type);        
        $this->load->view($this->theme . 'reports/print_invoices', array("invoices_data"=>$invoices_data,"start_date"=>$start_date,"end_date"=>$end_date, "assets"=>$this->data["assets"]));
    }
    function purchases()
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

        if($_POST) {

            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') :  date('Y-m-d 00:00:00');
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : date('Y-m-d 23:59:00');
            $user = $_POST['user'] ? $_POST['user'] : NULL;
            $product_id = $_POST['products'] ? $_POST['products'] : NULL;
            // $this->data['start_date'] = $start_date;
            // $this->data['end_date'] = $end_date;
            // $this->data['user'] = $user;
            // $this->data['product_id'] = $product_id;
            
        }
        
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("shoppings_report");
        $bc = array(array('link' => '#', 'page' => lang('shoppings_report')), array('link' => '#', 'page' => lang('shoppings_report')));
        $meta = array('page_title' => lang('shoppings_report'), 'bc' => $bc);
        $this->page_construct('reports/purchases_report', $this->data, $meta);
    }

    function get_purchases()
    {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $products = $this->input->get('products') ? $this->input->get('products') : NULL;
        $this->load->library('datatables');

        $this->datatables
                ->select($this->db->dbprefix('purchases') . ".id as id, " . $this->db->dbprefix('purchases') . ".date, reference, total, " . $this->db->dbprefix('suppliers') . ".name, note, CASE WHEN received=1 THEN 'Received' WHEN received = 0 THEN 'Not Yet Received' END, attachment")
                ->from('purchases')
                ->join('suppliers', 'suppliers.id=purchases.supplier_id', 'left');
   
        // if($customer) { $this->datatables->where('tec_sales.customer_id', $customer); }
        // if($user) { $this->datatables->where_in('tec_sales.created_by', explode(",", $user)); }
        if($start_date) { $this->datatables->where('tec_purchases.date >=', $start_date); }
        if($end_date) { $this->datatables->where('tec_purchases.date <=', $end_date); }
        // if($invoice_type) { $this->datatables->where('tec_sales.InvoiceType', $invoice_type); }
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a onclick=\"window.open('" . site_url('purchases/view/$1') . "', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;\" href='#' title='" . lang('print_purchases') . "' class='tip btn btn-primary btn-xs'><i class='fa fa-file-text-o'></i></a> </div></div>", "id");

        $this->datatables->unset_column('id');
        echo $this->datatables->generate();


    }

    function print_purchases(){
        
        $user = $_POST['user'] ? $_POST['user'] : NULL;
        $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
        $products = $_POST['products'] ? $_POST['products'] : NULL;   
        $purchases = $this->purchases_model->getfilterlist($user, $start_date, $end_date, $products);
        $this->load->view($this->theme . 'reports/print_purchases', array("purchases"=>$purchases,"start_date"=>$start_date,"end_date"=>$end_date, "assets"=>$this->data["assets"]));
    }
    function expenses()
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

        if($_POST) {

            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') :  date('Y-m-d 00:00:00');
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : date('Y-m-d 23:59:00');
            $user = $_POST['user'] ? $_POST['user'] : NULL;
            $product_id = $_POST['products'] ? $_POST['products'] : NULL;
            // $this->data['start_date'] = $start_date;
            // $this->data['end_date'] = $end_date;
            // $this->data['user'] = $user;
            // $this->data['product_id'] = $product_id;
            
        }
        
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("expenses_report");
        $bc = array(array('link' => '#', 'page' => lang('expenses_report')), array('link' => '#', 'page' => lang('expenses_report')));
        $meta = array('page_title' => lang('expenses_report'), 'bc' => $bc);
        $this->page_construct('reports/expenses_report', $this->data, $meta);
    }

    function get_expenses()
    {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $products = $this->input->get('products') ? $this->input->get('products') : NULL;
        $this->load->library('datatables');


        $detail_link = anchor('purchases/expense_note/$1', '<i class="fa fa-file-text-o"></i> ' . lang('expense_note'), 'data-toggle="modal" data-target="#myModal2"');
        $edit_link = anchor('purchases/edit_expense/$1', '<i class="fa fa-edit"></i> ' . lang('edit_expense'), 'data-toggle="modal" data-target="#myModal"');
        $delete_link = "<a href='#' class='po' title='<b>" . $this->lang->line("delete_expense") . "</b>' data-content=\"<p>"
                . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . site_url('purchases/delete_expense/$1') . "'>"
                . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i> "
                . lang('delete_expense') . "</a>";
        $action = '<div class="text-center"><div class="btn-group text-left">'
                . '<button type="button" class="btn btn-default btn-xs btn-primary dropdown-toggle" data-toggle="dropdown">'
                . lang('actions') . ' <span class="caret"></span></button>
        <ul class="dropdown-menu pull-right" role="menu">
            <li>' . $detail_link . '</li>
            <li>' . $edit_link . '</li>
            <li>' . $delete_link . '</li>
        </ul>
        </div></div>';

        $this->load->library('datatables');
        $this->datatables
                ->select($this->db->dbprefix('expenses') . ".id as id, date, reference, amount, note, CONCAT(" . $this->db->dbprefix('users') . ".first_name, ' ', " . $this->db->dbprefix('users') . ".last_name) as user, attachment", FALSE)
                ->from('expenses')
                ->join('users', 'users.id=expenses.created_by', 'left')
                ->group_by('expenses.id');

        if (!$this->Admin) {
            $this->datatables->where('created_by', $this->session->userdata('user_id'));
        }
        // if($customer) { $this->datatables->where('tec_sales.customer_id', $customer); }
        // if($user) { $this->datatables->where_in('tec_sales.created_by', explode(",", $user)); }
        if($start_date) { $this->datatables->where('tec_expenses.date >=', $start_date); }
        if($end_date) { $this->datatables->where('tec_expenses.date <=', $end_date); }
        // if($invoice_type) { $this->datatables->where('tec_sales.InvoiceType', $invoice_type); }
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a onclick=\"window.open('" . site_url('purchases/expense_note/$1') . "', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;\" href='#' title='" . lang('expense_note') . "' class='tip btn btn-primary btn-xs'><i class='fa fa-file-text-o'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }

    function print_expenses(){
        
        $user = $_POST['user'] ? $_POST['user'] : NULL;
        $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
        $products = $_POST['products'] ? $_POST['products'] : NULL;   
        $expenses = $this->purchases_model->getExpensesFilterList($user, $start_date, $end_date, $products);
        $this->load->view($this->theme . 'reports/print_expenses', array("expenses"=>$expenses,"start_date"=>$start_date,"end_date"=>$end_date, "assets"=>$this->data["assets"]));
    }
   
    function print_report1(){

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        if($this->input->post('customer')) {
            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
            $user = $_POST['user'] ? $_POST['user'] : NULL;
            $sales = $this->reports_model->getRowSalesforCustomer($this->input->post('customer'), $user, $start_date, $end_date);
           
        } else{
            $sales = $this->reports_model->getRowSales($this->input->post('customer'), $user, $start_date, $end_date);
        }
        $sale_data = $sales;
        $this->load->view($this->theme . 'reports/print_sales', array("sale_data"=>$sale_data));
    }
    
     function print_top_this_month(){         
         
            $this->data['topProducts'] = $this->reports_model->topProducts();
       // $this->data['topProducts1'] = $this->reports_model->topProducts1();
        //$this->data['topProducts3'] = $this->reports_model->topProducts3();
        ///$this->data['topProducts12'] = $this->reports_model->topProducts12();

        $this->data['page_title'] = $this->lang->line("top_products");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('top_products')));
        $meta = array('page_title' => lang('top_products'), 'bc' => $bc);
        //$this->page_construct('reports/top', $this->data, $meta);         
      
        $this->load->view($this->theme . 'reports/print_top_product_this_month', array("product"=>$this->data, "meta_data" => $meta));

    }      
    
     function print_top_last_month(){         
         
            //$this->data['topProducts'] = $this->reports_model->topProducts();
        $this->data['topProducts1'] = $this->reports_model->topProducts1();
        //$this->data['topProducts3'] = $this->reports_model->topProducts3();
        ///$this->data['topProducts12'] = $this->reports_model->topProducts12();

        $this->data['page_title'] = $this->lang->line("top_products");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('top_products')));
        $meta = array('page_title' => lang('top_products'), 'bc' => $bc);
        //$this->page_construct('reports/top', $this->data, $meta);         
      
        $this->load->view($this->theme . 'reports/print_top_product_last_month', array("product"=>$this->data, "meta_data" => $meta));

    }
    
    function print_top_last_3_months(){         
         
            //$this->data['topProducts'] = $this->reports_model->topProducts();
        //$this->data['topProducts1'] = $this->reports_model->topProducts1();
        $this->data['topProducts3'] = $this->reports_model->topProducts3();
        ///$this->data['topProducts12'] = $this->reports_model->topProducts12();

        $this->data['page_title'] = $this->lang->line("top_products");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('top_products')));
        $meta = array('page_title' => lang('top_products'), 'bc' => $bc);
        //$this->page_construct('reports/top', $this->data, $meta);         
      
        $this->load->view($this->theme . 'reports/print_top_product_last_3_month', array("product"=>$this->data, "meta_data" => $meta));

    }
    
     function print_top_last_12_months(){         
         
            //$this->data['topProducts'] = $this->reports_model->topProducts();
        //$this->data['topProducts1'] = $this->reports_model->topProducts1();
        // $this->data['topProducts3'] = $this->reports_model->topProducts3();
        $this->data['topProducts12'] = $this->reports_model->topProducts12();

        $this->data['page_title'] = $this->lang->line("top_products");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('top_products')));
        $meta = array('page_title' => lang('top_products'), 'bc' => $bc);
        //$this->page_construct('reports/top', $this->data, $meta);         
      
        $this->load->view($this->theme . 'reports/print_top_product_last_12_month', array("product"=>$this->data, "meta_data" => $meta));

    }    

    function get_sales() {


        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        //$paid_by = $this->input->get('paid_by') ? $this->input->get('paid_by') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : date('Y-m-d 00:00:00');
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : date('Y-m-d 23:59:00');
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $invoice_type = $this->input->get('invoice_type') ? $this->input->get('invoice_type') : NULL;
        //$invoice_type = 'FR';

        $this->load->library('datatables');
        $this->datatables
                ->select("id, date, customer_name, InvoiceNo, total, total_tax, total_discount, grand_total, paid, (grand_total-paid) as balance")
                ->from('sales')
                ->unset_column('id');
        $this->datatables->where("InvoiceStatus!=", "A");
        //$this->datatables->where("InvoiceType!=", "FP");
        $this->datatables->where("InvoiceType!=", "NC");
        $this->datatables->where("mesa!=", "NC");
        if ($customer) {
            $this->datatables->where('customer_id', $customer);
        }
        if ($user) {
            $this->datatables->where_in('created_by', explode(",", $user));
        }
        if ($start_date) {
            $this->datatables->where('date >=', $start_date);
        }
        if ($end_date) {
            $this->datatables->where('date <=', $end_date);
        }
        if ($invoice_type) {
            $this->datatables->where('tec_sales.InvoiceType', $invoice_type);
        }

        echo $this->datatables->generate();
    }
    function get_invoices()
    {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        //$paid_by = $this->input->get('paid_by') ? $this->input->get('paid_by') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $products = $this->input->get('products') ? $this->input->get('products') : NULL;
        $invoice_type = $this->input->get('invoice_type') ? $this->input->get('invoice_type') : NULL;

        $this->load->library('datatables');
        $this->datatables
        ->select("tec_sales.id, tec_sales.date, tec_sales.customer_name, tec_sales.InvoiceNo, tec_sales.total, tec_sales.total_tax, tec_sales.total_discount, tec_sales.grand_total, tec_sales.paid, (tec_sales.grand_total-tec_sales.paid) as balance")
        ->from('sales');
        
        $this->datatables->where("tec_sales.InvoiceStatus!=","A");
        $this->datatables->where("tec_sales.InvoiceType=","FT");

        if($customer) { $this->datatables->where('tec_sales.customer_id', $customer); }
        if($user) { $this->datatables->where_in('tec_sales.created_by', explode(",", $user)); }
        if($start_date) { $this->datatables->where('tec_sales.date >=', $start_date); }
        if($end_date) { $this->datatables->where('tec_sales.date <=', $end_date); }
        if($invoice_type) { $this->datatables->where('tec_sales.InvoiceType', $invoice_type); }

        if($products){
            // $this->datatables->join_where_in('tec_sale_items',"tec_sale_items.sale_id = tec_sales.id", "tec_sale_items.product_id",$products);
            $this->datatables->join("tec_sale_items","tec_sale_items.sale_id=tec_sales.id");
            $this->datatables->where_in('tec_sale_items.product_id', explode(",", $products)); 

        }
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='#' onClick=\"MyWindow=window.open('" . site_url('pos/printInvoice/$1') . "',target='_blank'); return false;\" title='".lang("print_invoice")."' class='tip btn btn-success btn-xs print$1'><i class='fa fa-print'></i></a> </div></div>","tec_sales.id");

        $this->datatables->unset_column('tec_sales.id');

        echo $this->datatables->generate();

    }

    function products()
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("products_report");

        $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : date('Y-m-d 00:00:00');
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : date('Y-m-d 23:59:00');

        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('products_report')));
        $meta = array('page_title' => lang('products_report'), 'bc' => $bc);
        $sales_data = array();
        $product = $this->input->post('product');
        $sales_data = $this->reports_model->getallproductos($product, $start_date, $end_date); 
        $this->data['start_date'] = $start_date;
        $this->data['end_date'] = $end_date;
        $this->data['sales_data'] = $sales_data;
        $this->page_construct('reports/products', $this->data, $meta);
    }
    function print_products()
    {

        $product = $this->input->post('product_hidden') ? $this->input->post('product_hidden') : NULL;
        $start_date = $this->input->post('start_date_hidden') ? $this->input->post('start_date_hidden') : date('Y-m-d 00:00:00');
        $end_date = $this->input->post('end_date_hidden') ? $this->input->post('end_date_hidden') : date('Y-m-d 23:59:00');

        $group_by_date = $this->input->post('group_by_date_hidden') ? 1 :0;

        $this->data['page_title'] = $this->lang->line("products_report");
        if($group_by_date==1){
            $this->data['alldata']=$this->reports_model->getallproductos_group_by($product, $start_date, $end_date);
        }else{
            $this->data['alldata']=$this->reports_model->getallproductos($product, $start_date, $end_date);
        }
                
        // echo json_encode($this->data['alldata']);
        $this->data['start_date'] = $start_date;
        $this->data['end_date'] = $end_date;
        $this->data['group_by_date'] = $group_by_date;
        $this->load->view($this->theme . 'reports/print_products', $this->data );
    }
    function get_products()
    {
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') :  date('Y-m-d 00:00:00');;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') :  date('Y-m-d 23:59:00');;
//COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity)*".$this->db->dbprefix('products').".cost, 0) as cost,
        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('products').".name, ".$this->db->dbprefix('products').".code as code, 
            COALESCE(sum(".$this->db->dbprefix('purchase_items').".quantity), 0) as purchase, 
            COALESCE(SUM(CASE WHEN ".$this->db->dbprefix('sales').".InvoiceType = 'NC' THEN -".$this->db->dbprefix('sale_items').".quantity ELSE ".$this->db->dbprefix('sale_items').".quantity END), 0) as sold, 
            ROUND(COALESCE(((SUM(CASE WHEN ".$this->db->dbprefix('sales').".InvoiceType = 'NC' THEN -".$this->db->dbprefix('sale_items').".subtotal ELSE ".$this->db->dbprefix('sale_items').".subtotal END)*".$this->db->dbprefix('products').".tax)/100), 0), 2) as tax, 
            COALESCE(SUM(CASE WHEN ".$this->db->dbprefix('sales').".InvoiceType = 'NC' THEN -(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) ELSE (".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) END), 0) as cost, 
            COALESCE(SUM(CASE WHEN ".$this->db->dbprefix('sales').".InvoiceType = 'NC' THEN -".$this->db->dbprefix('sale_items').".subtotal ELSE ".$this->db->dbprefix('sale_items').".subtotal END), 0) as income, 
            ROUND((COALESCE(SUM(CASE WHEN ".$this->db->dbprefix('sales').".InvoiceType = 'NC' THEN -".$this->db->dbprefix('sale_items').".subtotal ELSE ".$this->db->dbprefix('sale_items').".subtotal END), 0)) - COALESCE(SUM(CASE WHEN ".$this->db->dbprefix('sales').".InvoiceType = 'NC' THEN -(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) ELSE (".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) END), 0) - COALESCE(((SUM(CASE WHEN ".$this->db->dbprefix('sales').".InvoiceType = 'NC' THEN -".$this->db->dbprefix('sale_items').".subtotal ELSE ".$this->db->dbprefix('sale_items').".subtotal END)*".$this->db->dbprefix('products').".tax)/100), 0), 2) as profit, ".$this->db->dbprefix('products').".quantity", FALSE)
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left' )
        ->join('purchase_items', 'sale_items.product_id = purchase_items.product_id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left' )
        ->group_by('products.id');

        if($product) { $this->datatables->where('products.id', $product); }
        if($start_date) { $this->datatables->where('sales.date >=', $start_date);}
        if($end_date) { $this->datatables->where('sales.date <=', $end_date);  }
        $this->datatables->add_column("Actions", "<div class='text-center'><a href='#' onClick=\"MyWindow=window.open('" . site_url('reports/product/$1') . "',target='_blank'); return false;\" title='".lang("view")."' class='tip btn btn-success btn-xs'><i class='fa fa-eye'></i></a></div>", "code");

        echo $this->datatables->generate();

    }

    function product($code)
    {
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('invoice_lists');
        $this->data['code'] = $code;
        $bc = array(array('link' => '#', 'page' => lang('invoice_lists')));
        $meta = array('page_title' => lang('invoice_lists'), 'bc' => $bc);
        $this->page_construct('reports/invoice_lists_by_product', $this->data, $meta);        
    }

    function get_invoices_by_product()
    {
        $code = $this->input->get('code') ? $this->input->get('code') : NULL;
        $this->load->library('datatables');
        $this->datatables->select("tec_sales.id as id, tec_sales.date, tec_sales.customer_name, tec_sales.InvoiceNo,  tec_sales.OriginatingON,  tec_sales.grand_total, tec_sales.paid, (tec_sales.grand_total-tec_sales.paid) as balance,  tec_sales.InvoiceType ");
        $this->datatables->from('sales')
                         ->join('sale_items', 'sale_items.sale_id=sales.id', 'left')
                         ->join('products', 'products.id=sale_items.product_id', 'left')
        ->group_by('sales.id');

        $this->datatables->where("sales.mesa!=","NC"); 
        $this->datatables->where_in("sales.InvoiceType",["FT","NC"]);
        
        if($code){
            $this->datatables->where('products.code', $code);
        }

        if(!$this->Admin) {
            $user_id = $this->session->userdata('user_id');
            $this->datatables->where('sales.created_by', $user_id);
        }
         // $this->datatables->add_column("paid","paid");
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='#' onClick=\"MyWindow=window.open('" . site_url('pos/printInvoice/$1') . "',target='_blank'); return false;\" title='".lang("print_invoice")."' class='tip btn btn-warning btn-xs print$1'><i class='fa fa-print'></i></a>
         <a href='".site_url('sales/add_payment/$1')."' title='" . lang("add_payment") . "' class='add_payment_btn tip btn btn-success btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a>  
         <a  onClick=\"MyWindow=window.open('" . site_url('pos/guia_transporte/$1') . "',target='_blank'); \"' title='" . lang("Guia de Transporte") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-car'></i></a>
         <a href='".site_url('sales/payments/$1')."' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a> 
         <a title='".lang("Nota de Crédito")."' class='tip btn btn-danger btn-xs convert-nc-btn' data-id='$1'><i class='fa fa-exchange'></i></a>  
         </div></div>","id");

        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }
    
    function profit( $income, $cost, $tax)
    {
        return floatval($income)." - ".floatval($cost)." - ".floatval($tax);
    }

    function top_products()
    {

        $this->data['topProducts'] = $this->reports_model->topProducts();
        $this->data['topProducts1'] = $this->reports_model->topProducts1();
        $this->data['topProducts3'] = $this->reports_model->topProducts3();
        $this->data['topProducts12'] = $this->reports_model->topProducts12();

        $this->data['page_title'] = $this->lang->line("top_products");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('top_products')));
        $meta = array('page_title' => lang('top_products'), 'bc' => $bc);
        $this->page_construct('reports/top', $this->data, $meta);
    }

    function registers()
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('registers_report')));
        $meta = array('page_title' => lang('registers_report'), 'bc' => $bc);
        $this->page_construct('reports/registers', $this->data, $meta);
    }

    function get_register_logs()
    {

        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;

        $this->load->library('datatables');
        $this->datatables
        ->select("date, closed_at, CONCAT(" . $this->db->dbprefix('users') . ".first_name, ' ', " . $this->db->dbprefix('users') . ".last_name, '<br>', " . $this->db->dbprefix('users') . ".email) as user, cash_in_hand, CONCAT(total_cc_slips, ' (', total_cc_slips_submitted, ')') as cc_slips, CONCAT(total_cheques, ' (', total_cheques_submitted, ')') as total_cheques, CONCAT(total_cash, ' (', total_cash_submitted, ')') as total_cash, note", FALSE)
        ->from("registers")
        ->join('users', 'users.id=registers.user_id', 'left');

        if ($user) {
            $this->datatables->where('registers.user_id', $user);
        }
        if ($start_date) {
            $this->datatables->where('date BETWEEN "' . $start_date . '" and "' . $end_date . '"');
        }

        echo $this->datatables->generate();


    }

    function payments()
    {
        if($this->session->userdata("reports")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('payments_report')));
        $meta = array('page_title' => lang('payments_report'), 'bc' => $bc);
        $this->page_construct('reports/payments', $this->data, $meta);
    }

    function get_payments()
    {
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $ref = $this->input->get('payment_ref') ? $this->input->get('payment_ref') : NULL;
        $sale_id = $this->input->get('sale_no') ? $this->input->get('sale_no') : NULL;
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $paid_by = $this->input->get('paid_by') ? $this->input->get('paid_by') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;

        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('payments') . ".date, " . $this->db->dbprefix('sales') . ".customer_name as ref, "  .$this->db->dbprefix('payments') . ".id as sale_no,"  .$this->db->dbprefix('payments') . ".InvoiceNo, paid_by, amount, grand_total")
        ->from('payments')
        ->join('sales', 'payments.sale_id=sales.id', 'left')
        ->group_by('payments.id');

        if ($user) {
            $this->datatables->where('payments.created_by', $user);
        }
        if ($ref) {
            $this->datatables->where('payments.reference', $ref);
        }
        if ($paid_by) {
            $this->datatables->where('payments.paid_by', $paid_by);
        }
        if ($sale_id) {
            $this->datatables->where('sales.id', $sale_id);
        }
        if ($customer) {
            $this->datatables->where('sales.customer_id', $customer);
        }
        if ($start_date) {
            $this->datatables->where($this->db->dbprefix('payments').'.date BETWEEN "' . $start_date . '" and "' . $end_date . '"');
        }

        $this->datatables->add_column("Actions", "<div class='text-center'><a href='#' onClick=\"MyWindow=window.open('" . site_url('sales/printPaymentInvoiceR/$1') . "',target='_blank'); return false;\" title='".lang("print_payment")."' class='tip btn btn-success btn-xs print$1'><i class='fa fa-print'></i></a></div>","sale_no");

        echo $this->datatables->generate();

    }

    function alerts() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('stock_alert');
        $bc = array(array('link' => '#', 'page' => lang('stock_alert')));
        $meta = array('page_title' => lang('stock_alert'), 'bc' => $bc);
        $this->page_construct('reports/alerts', $this->data, $meta);

    }

    function get_alerts() {

        $this->load->library('datatables');
        $this->datatables->select($this->db->dbprefix('products').".id as pid, ".$this->db->dbprefix('products').".image as image, ".$this->db->dbprefix('products').".code as code, ".$this->db->dbprefix('products').".name as pname, type, ".$this->db->dbprefix('categories').".name as cname, quantity, alert_quantity, tax, tax_method, cost, price", FALSE)
        ->join('categories', 'categories.id=products.category_id')
        ->from('products')
        ->where('quantity < alert_quantity', NULL, FALSE)
        ->group_by('products.id');
        $this->datatables->add_column("Actions", "<div class='text-center'><a href='#' class='btn btn-xs btn-primary ap tip' data-id='$1' title='".lang('add_to_purcahse_order')."'><i class='fa fa-plus'></i></a></div>", "pid");
        $this->datatables->unset_column('pid');
        echo $this->datatables->generate();

    }

}
